/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.client.sweet;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.xstarlotte.snsnf.entity.client.sweet.RainbowStripUnicornModel;
import net.xstarlotte.snsnf.entity.client.variant.RainbowStripUnicornVariant;
import net.xstarlotte.snsnf.entity.custom.sweet.RainbowStripUnicornEntity;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class RainbowStripUnicornRenderer
extends GeoEntityRenderer<RainbowStripUnicornEntity> {
    private static final Map<RainbowStripUnicornVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(RainbowStripUnicornVariant.class), map -> {
        map.put(RainbowStripUnicornVariant.ONE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/rainbow_strip_unicorn.png"));
        map.put(RainbowStripUnicornVariant.TWO, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/rainbow_strip_unicorn_2.png"));
        map.put(RainbowStripUnicornVariant.THREE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/rainbow_strip_unicorn_3.png"));
        map.put(RainbowStripUnicornVariant.FOUR, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/rainbow_strip_unicorn_4.png"));
        map.put(RainbowStripUnicornVariant.FIVE, ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/entity/sweet/rainbow_strip_unicorn_5.png"));
    });

    public RainbowStripUnicornRenderer(EntityRendererProvider.Context context) {
        super(context, new RainbowStripUnicornModel());
    }

    public ResourceLocation getTextureLocation(RainbowStripUnicornEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public void render(RainbowStripUnicornEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
        } else {
            poseStack.scale(1.0f, 1.0f, 1.0f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

