/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.custom.herb;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CandyCaneCerberusEntity
extends Monster
implements GeoEntity {
    private static final String CTRL = "controller";
    private static final String ANIM_IDLE = "animation.candy_cane_cerberus.idle";
    private static final String ANIM_WALK = "animation.candy_cane_cerberus.walk";
    private static final String ANIM_BITE = "animation.candy_cane_cerberus.bite";
    private static final String ANIM_STOMP = "animation.candy_cane_cerberus.stomp";
    private static final int BITE_TOTAL_TICKS = 20;
    private static final int STOMP_TOTAL_TICKS = 20;
    private static final int BITE_HIT_TICK = 8;
    private static final int STOMP_HIT_TICK = 12;
    private static final double STOP_RANGE_FLOOR = 9.0;
    private static final double BITE_SLACK_EXTRA = 3.0;
    private static final double STOMP_RADIUS_EXTRA = 3.0;
    private static final double HYSTERESIS = 2.0;
    private static final double DIRECT_STEP = 0.05;
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.literal((String)"Candy Cane Cerberus"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private AttackType nextAttack = AttackType.BITE;
    private boolean dealtThisSwing = false;
    private boolean phase2 = false;
    private static final EntityDataAccessor<Byte> ATTACK_STATE = SynchedEntityData.defineId(CandyCaneCerberusEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.defineId(CandyCaneCerberusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CandyCaneCerberusEntity(EntityType<? extends CandyCaneCerberusEntity> type, Level level) {
        super(type, level);
        this.setPersistenceRequired();
        this.setHealth(this.getMaxHealth());
        this.xpReward = 15000;
    }

    public float maxUpStep() {
        return 1.0f;
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return false;
    }

    public boolean shouldDespawnInPeaceful() {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 400.0).add(Attributes.ARMOR, 40.0).add(Attributes.ARMOR_TOUGHNESS, 12.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.46f).add(Attributes.ATTACK_DAMAGE, 20.0).add(Attributes.ATTACK_KNOCKBACK, 1.5);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, CTRL, 3, state -> {
            if (this.isMidAttack()) {
                String clip = this.getAttackType() == AttackType.BITE ? ANIM_BITE : ANIM_STOMP;
                return state.setAndContinue(RawAnimation.begin().then(clip, Animation.LoopType.PLAY_ONCE));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().then(ANIM_WALK, Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then(ANIM_IDLE, Animation.LoopType.LOOP));
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BossHerbAttackGoal(this, 10));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{CandyCaneCerberusEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    protected void dropFromLootTable(DamageSource source, boolean hitByPlayer) {
        super.dropFromLootTable(source, hitByPlayer);
        if (!this.level().isClientSide) {
            this.spawnAtLocation(new ItemStack((ItemLike)Items.EMERALD, 5));
            this.spawnAtLocation(new ItemStack((ItemLike)Items.DIAMOND, 5));
            this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHERITE_INGOT, 5));
        }
    }

    public boolean hurt(DamageSource src, float amount) {
        if (src.is(DamageTypeTags.IS_PROJECTILE)) {
            amount *= 0.25f;
        }
        if (src.is(DamageTypeTags.IS_EXPLOSION)) {
            amount *= 0.5f;
        }
        if (src.is(DamageTypeTags.IS_FIRE)) {
            amount *= 0.5f;
        }
        return super.hurt(src, amount);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    protected void defineSynchedData(SynchedEntityData.Builder b) {
        super.defineSynchedData(b);
        b.define(ATTACK_STATE, (Object)((byte)AttackType.NONE.ordinal()));
        b.define(ATTACK_TICKS, (Object)0);
    }

    private boolean isMidAttack() {
        return this.getAttackType() != AttackType.NONE;
    }

    private AttackType getAttackType() {
        return AttackType.values()[(Byte)this.entityData.get(ATTACK_STATE)];
    }

    private int getAttackTicks() {
        return (Integer)this.entityData.get(ATTACK_TICKS);
    }

    private AttackType popNextAttackType() {
        AttackType t = this.nextAttack;
        this.nextAttack = t == AttackType.BITE ? AttackType.STOMP : AttackType.BITE;
        return t;
    }

    private void startAttack(AttackType type) {
        this.entityData.set(ATTACK_STATE, (Object)((byte)type.ordinal()));
        this.entityData.set(ATTACK_TICKS, (Object)0);
        this.dealtThisSwing = false;
        this.triggerAnim(CTRL, type == AttackType.BITE ? ANIM_BITE : ANIM_STOMP);
        if (!this.level().isClientSide) {
            LivingEntity t = this.getTarget();
            double dist = t == null ? -1.0 : Math.sqrt(this.distanceToSqr((Entity)t));
            System.out.println("[Cerberus] START " + String.valueOf((Object)type) + "  dist=" + String.format("%.2f", dist));
        }
    }

    private void endAttack() {
        this.entityData.set(ATTACK_STATE, (Object)((byte)AttackType.NONE.ordinal()));
        this.entityData.set(ATTACK_TICKS, (Object)0);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
            if (this.tickCount % 20 == 0) {
                this.heal(this.phase2 ? 4.0f : 2.0f);
            }
            if (!this.phase2 && this.getHealth() <= this.getMaxHealth() * 0.5f) {
                this.phase2 = true;
                AttributeInstance speedAttr = this.getAttribute(Attributes.MOVEMENT_SPEED);
                if (speedAttr != null) {
                    speedAttr.setBaseValue((double)0.52f);
                }
            }
        }
        if (!this.level().isClientSide && this.isMidAttack()) {
            boolean inWindow;
            int total;
            int elapsed = this.getAttackTicks() + 1;
            AttackType type = this.getAttackType();
            int hitTick = type == AttackType.BITE ? 8 : 12;
            int n = total = type == AttackType.BITE ? 20 : 20;
            if (type == AttackType.BITE && elapsed < hitTick - 2) {
                Vec3 n2 = this.getLookAngle().scale(0.05);
                this.setDeltaMovement(this.getDeltaMovement().add(n2.x, 0.0, n2.z));
            }
            boolean bl = inWindow = elapsed >= hitTick - 1 && elapsed <= hitTick + 1;
            if (!this.dealtThisSwing && inWindow) {
                boolean landed;
                boolean bl2 = landed = type == AttackType.BITE ? this.doBiteDamage() : this.doStompDamage();
                if (landed) {
                    System.out.println("[Cerberus] HIT " + String.valueOf((Object)type) + " at tick " + elapsed);
                    this.dealtThisSwing = true;
                }
            }
            if (elapsed >= total) {
                this.endAttack();
            } else {
                this.entityData.set(ATTACK_TICKS, (Object)elapsed);
            }
        }
    }

    private AABB frontBox(double forward, double halfW, double height, double yOff) {
        Vec3 look = this.getLookAngle().normalize();
        Vec3 center = new Vec3(this.getX() + look.x * forward, this.getY() + yOff + height * 0.5, this.getZ() + look.z * forward);
        return new AABB(center.x - halfW, center.y - height * 0.5, center.z - halfW, center.x + halfW, center.y + height * 0.5, center.z + halfW);
    }

    private boolean doBiteDamage() {
        LivingEntity target = this.getTarget();
        if (target == null) {
            return false;
        }
        double halfW = (double)this.getBbWidth() * 0.5 + 1.25 + 3.0;
        double height = Math.min((double)this.getBbHeight(), 2.6);
        double forward = halfW + 0.75;
        AABB bite = this.frontBox(forward, halfW, height, 0.2);
        float biteDamage = this.phase2 ? 12.0f : 8.0f;
        List victims = this.level().getEntitiesOfClass(LivingEntity.class, bite, e -> e != this && this.hasLineOfSight((Entity)e));
        boolean hit = false;
        for (LivingEntity v : victims) {
            v.hurt(this.damageSources().mobAttack((LivingEntity)this), biteDamage);
            hit = true;
        }
        return hit;
    }

    private boolean doStompDamage() {
        double r = (double)this.getBbWidth() * 0.5 + 2.0 + 3.0;
        AABB box = this.getBoundingBox().inflate(r, 0.8, r);
        float stompDamage = this.phase2 ? 16.0f : 10.0f;
        double kbScale = this.phase2 ? 1.5 : 1.0;
        List victims = this.level().getEntitiesOfClass(LivingEntity.class, box, e -> e != this && this.hasLineOfSight((Entity)e));
        for (LivingEntity v : victims) {
            v.hurt(this.damageSources().mobAttack((LivingEntity)this), stompDamage);
            Vec3 dir = v.position().subtract(this.position()).normalize().scale(kbScale);
            v.push(dir.x, 0.25, dir.z);
        }
        return !victims.isEmpty();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor lvl, DifficultyInstance diff, MobSpawnType reason, @Nullable SpawnGroupData data) {
        return super.finalizeSpawn(lvl, diff, reason, data);
    }

    private static enum AttackType {
        NONE,
        BITE,
        STOMP;

    }

    private static class BossHerbAttackGoal
    extends Goal {
        private final CandyCaneCerberusEntity mob;
        private final int recoveryTicksDefault;
        private int recoveryTicks = 0;
        private int inRangeTicks = 0;

        public BossHerbAttackGoal(CandyCaneCerberusEntity mob, int recoveryTicks) {
            this.mob = mob;
            this.recoveryTicksDefault = recoveryTicks;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity t = this.mob.getTarget();
            return t != null && t.isAlive();
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void start() {
            this.recoveryTicks = 0;
            this.inRangeTicks = 0;
        }

        public void tick() {
            LivingEntity target = this.mob.getTarget();
            if (target == null) {
                return;
            }
            this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            if (this.mob.isMidAttack()) {
                this.mob.getNavigation().stop();
                return;
            }
            double biteReach = (double)this.mob.getBbWidth() * 0.5 + (double)target.getBbWidth() * 0.5 + 2.0 + 3.0;
            double stopRange = Math.max(biteReach - 0.25, 9.0);
            double stopRangeSq = stopRange * stopRange;
            double nearRange = stopRange + 2.0;
            double nearRangeSq = nearRange * nearRange;
            double d2 = this.mob.distanceToSqr((Entity)target);
            if (d2 > nearRangeSq) {
                this.inRangeTicks = 0;
                this.mob.getNavigation().moveTo((Entity)target, 1.0);
                return;
            }
            this.mob.getNavigation().stop();
            if (d2 > stopRangeSq) {
                Vec3 dir = new Vec3(target.getX() - this.mob.getX(), 0.0, target.getZ() - this.mob.getZ()).normalize();
                Vec3 vel = this.mob.getDeltaMovement();
                this.mob.setDeltaMovement(vel.scale(0.5).add(dir.scale(0.05)));
                return;
            }
            ++this.inRangeTicks;
            if (this.recoveryTicks > 0) {
                --this.recoveryTicks;
                return;
            }
            if (this.inRangeTicks >= 5) {
                AttackType type = this.mob.popNextAttackType();
                this.mob.startAttack(type);
                this.recoveryTicks = this.recoveryTicksDefault;
                this.inRangeTicks = 0;
            }
        }
    }
}

