/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.custom.sweet;

import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.xstarlotte.snsnf.item.SNSItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChocolatePigeonEntity
extends PathfinderMob
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Boolean> DOMESTICATED = SynchedEntityData.defineId(ChocolatePigeonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(ChocolatePigeonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<BlockPos> PERCH_POS = SynchedEntityData.defineId(ChocolatePigeonEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private final RandomSource rng = RandomSource.create();
    @Nullable
    private BlockPos landingTarget = null;
    private int sitTicks = 0;

    public ChocolatePigeonEntity(EntityType<? extends ChocolatePigeonEntity> type, Level level) {
        super(type, level);
        this.xpReward = 5;
        this.moveControl = new FlyingMoveControl((Mob)this, 4, true);
        this.setNoGravity(true);
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.hasCustomName() || (Boolean)this.entityData.get(DOMESTICATED) != false;
    }

    public boolean removeWhenFarAway(double distance) {
        return !this.requiresCustomPersistence();
    }

    private void domesticate() {
        if (!((Boolean)this.entityData.get(DOMESTICATED)).booleanValue()) {
            this.entityData.set(DOMESTICATED, (Object)true);
            this.setPersistenceRequired();
        }
    }

    public void setLeashedTo(Entity holder, boolean sendPacket) {
        super.setLeashedTo(holder, sendPacket);
        if (!this.level().isClientSide && (holder instanceof Player || holder instanceof LeashFenceKnotEntity)) {
            this.domesticate();
        }
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        if (!this.level().isClientSide && name != null) {
            this.domesticate();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DOMESTICATED, (Object)false);
        pBuilder.define(SITTING, (Object)false);
        pBuilder.define(PERCH_POS, (Object)BlockPos.ZERO);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(DOMESTICATED, (Object)pCompound.getBoolean("Domesticated"));
        this.setSitting(pCompound.getBoolean("IsSitting"));
        if (pCompound.contains("PerchX")) {
            this.setPerchPos(new BlockPos(pCompound.getInt("PerchX"), pCompound.getInt("PerchY"), pCompound.getInt("PerchZ")));
        }
        this.sitTicks = pCompound.getInt("SitTicks");
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("Domesticated", ((Boolean)this.entityData.get(DOMESTICATED)).booleanValue());
        pCompound.putBoolean("IsSitting", this.isSitting());
        this.getPerchPos().ifPresent(p -> {
            pCompound.putInt("PerchX", p.getX());
            pCompound.putInt("PerchY", p.getY());
            pCompound.putInt("PerchZ", p.getZ());
        });
        pCompound.putInt("SitTicks", this.sitTicks);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.FLYING_SPEED, 0.4).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.MAX_HEALTH, 10.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SitOnPerchGoal(this, this));
        this.goalSelector.addGoal(1, (Goal)new RandomPerchGoal(this, this, 1.05));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, stack -> stack.is(SNSItem.CANDY_CANE_SUGAR), false));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private static boolean isValidPerch(Level level, BlockPos pos) {
        if (!level.isLoaded(pos)) {
            return false;
        }
        BlockState floor = level.getBlockState(pos);
        if (floor.isAir()) {
            return false;
        }
        boolean solidTop = floor.isFaceSturdy((BlockGetter)level, pos, Direction.UP);
        boolean spaceAbove = level.getBlockState(pos.above()).getCollisionShape((BlockGetter)level, pos.above()).isEmpty();
        boolean safe = !floor.is(Blocks.CACTUS) && !floor.is(Blocks.MAGMA_BLOCK) && !floor.liquid();
        return solidTop && spaceAbove && safe;
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    private void setSitting(boolean value) {
        this.entityData.set(SITTING, (Object)value);
    }

    private Optional<BlockPos> getPerchPos() {
        BlockPos p = (BlockPos)this.entityData.get(PERCH_POS);
        return p.equals((Object)BlockPos.ZERO) ? Optional.empty() : Optional.of(p);
    }

    private void setPerchPos(@Nullable BlockPos pos) {
        this.entityData.set(PERCH_POS, (Object)(pos == null ? BlockPos.ZERO : pos));
    }

    public void tick() {
        super.tick();
        this.setNoGravity(true);
        if (this.isSitting()) {
            this.getNavigation().stop();
            this.setDeltaMovement(Vec3.ZERO);
            this.hasImpulse = false;
        }
    }

    @Nonnull
    protected PathNavigation createNavigation(@Nonnull Level level) {
        FlyingPathNavigation flyingPathNavigator = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigator.setCanOpenDoors(false);
        flyingPathNavigator.setCanFloat(true);
        flyingPathNavigator.setCanPassDoors(true);
        return flyingPathNavigator;
    }

    public void travel(Vec3 input) {
        if (this.isSitting()) {
            return;
        }
        super.travel(input);
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean canBeLeashed(Player player) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (this.isSitting()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.chocolate_pigeon.sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.chocolate_pigeon.fly", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.chocolate_pigeon.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    class SitOnPerchGoal
    extends Goal {
        private final ChocolatePigeonEntity bird;

        SitOnPerchGoal(ChocolatePigeonEntity this$0, ChocolatePigeonEntity bird) {
            this.bird = bird;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            return this.bird.isSitting() && this.bird.getPerchPos().isPresent();
        }

        public boolean canContinueToUse() {
            return this.bird.isSitting() && this.bird.getPerchPos().isPresent() && this.bird.sitTicks > 0;
        }

        public void start() {
            this.bird.getNavigation().stop();
            this.bird.setDeltaMovement(Vec3.ZERO);
        }

        public void tick() {
            BlockPos p = this.bird.getPerchPos().orElse(BlockPos.ZERO);
            if (p != BlockPos.ZERO) {
                double x = (double)p.getX() + 0.5;
                double y = (double)p.getY() + 0.98;
                double z = (double)p.getZ() + 0.5;
                this.bird.setPos(Mth.lerp((double)0.35, (double)this.bird.getX(), (double)x), Mth.lerp((double)0.35, (double)this.bird.getY(), (double)y), Mth.lerp((double)0.35, (double)this.bird.getZ(), (double)z));
            }
            this.bird.setDeltaMovement(Vec3.ZERO);
            --this.bird.sitTicks;
            if (!this.bird.getPerchPos().map(pos -> ChocolatePigeonEntity.isValidPerch(this.bird.level(), pos)).orElse(false).booleanValue()) {
                this.bird.setSitting(false);
                this.bird.setPerchPos(null);
                this.bird.sitTicks = 0;
            }
        }

        public void stop() {
            this.bird.setSitting(false);
            this.bird.setPerchPos(null);
            this.bird.setDeltaMovement(this.bird.getDeltaMovement().add(0.0, 0.25, 0.0));
        }
    }

    class RandomPerchGoal
    extends Goal {
        private final ChocolatePigeonEntity bird;
        private final double speed;
        private int tryCooldown = 0;
        private BlockPos target;

        RandomPerchGoal(ChocolatePigeonEntity this$0, ChocolatePigeonEntity bird, double speed) {
            this.bird = bird;
            this.speed = speed;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            if (this.bird.isSitting() || this.bird.getTarget() != null) {
                return false;
            }
            if (this.tryCooldown > 0) {
                --this.tryCooldown;
                return false;
            }
            if (this.bird.rng.nextInt(160) != 0) {
                return false;
            }
            BlockPos found = this.findNearbyPerch();
            if (found != null) {
                this.target = found;
                return true;
            }
            this.tryCooldown = 60;
            return false;
        }

        public boolean canContinueToUse() {
            return this.target != null && !this.bird.isSitting();
        }

        public void start() {
            if (this.target != null) {
                this.bird.getNavigation().moveTo((double)this.target.getX() + 0.5, (double)this.target.getY() + 1.1, (double)this.target.getZ() + 0.5, this.speed);
            }
        }

        public void tick() {
            double d2;
            if (this.target == null) {
                return;
            }
            if (this.bird.tickCount % 20 == 0 && this.bird.getNavigation().isDone()) {
                this.bird.getNavigation().moveTo((double)this.target.getX() + 0.5, (double)this.target.getY() + 1.1, (double)this.target.getZ() + 0.5, this.speed);
            }
            if ((d2 = this.bird.distanceToSqr((double)this.target.getX() + 0.5, (double)this.target.getY() + 1.0, (double)this.target.getZ() + 0.5)) <= 0.75) {
                if (ChocolatePigeonEntity.isValidPerch(this.bird.level(), this.target)) {
                    this.bird.setPerchPos(this.target);
                    this.bird.setSitting(true);
                    this.bird.getNavigation().stop();
                    this.bird.setDeltaMovement(Vec3.ZERO);
                    this.bird.sitTicks = Mth.nextInt((RandomSource)this.bird.rng, (int)100, (int)400);
                }
                this.target = null;
            }
        }

        public void stop() {
            this.target = null;
        }

        private BlockPos findNearbyPerch() {
            BlockPos origin = this.bird.blockPosition();
            for (int i = 0; i < 28; ++i) {
                int dx = Mth.nextInt((RandomSource)this.bird.rng, (int)-6, (int)6);
                int dy = Mth.nextInt((RandomSource)this.bird.rng, (int)-2, (int)3);
                int dz = Mth.nextInt((RandomSource)this.bird.rng, (int)-6, (int)6);
                BlockPos p = origin.offset(dx, dy, dz);
                if (!ChocolatePigeonEntity.isValidPerch(this.bird.level(), p)) continue;
                return p;
            }
            return null;
        }
    }
}

