/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.custom.sweet;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.DolphinJumpGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.xstarlotte.snsnf.item.SNSItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ColaBottlenoseDolphinEntity
extends Dolphin
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ColaBottlenoseDolphinEntity(EntityType<? extends Dolphin> type, Level level) {
        super(type, level);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Dolphin.createAttributes();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.hasCustomName();
    }

    public boolean removeWhenFarAway(double distanceSq) {
        return !this.requiresCustomPersistence();
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        if (!this.level().isClientSide && name != null) {
            this.setPersistenceRequired();
        }
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.2, 10));
        this.goalSelector.addGoal(2, (Goal)new DolphinJumpGoal((Dolphin)this, 10));
        this.goalSelector.addGoal(3, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new SwimWithSwimmersGoal(this, 1.2, 9.0));
        this.goalSelector.addGoal(5, (Goal)new PlayWithNearbyItemsGoal(this, 9.0, 40));
        this.goalSelector.addGoal(6, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.15, stack -> stack.is((Item)SNSItem.GELATIN.get()), false));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.isInWater()) {
            double r = 9.0;
            for (Player p : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(9.0, 4.5, 9.0), EntitySelector.NO_SPECTATORS)) {
                if (!p.isSwimming() && !p.isUnderWater()) continue;
                p.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 80, 0, true, false));
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is((Item)SNSItem.GELATIN.get())) {
            if (!this.level().isClientSide) {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                this.heal(2.0f);
                this.gameEvent((Holder)GameEvent.EAT, (Entity)this);
                this.playSound(SoundEvents.DOLPHIN_EAT, 1.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (stack.is(Items.COD) || stack.is(Items.SALMON)) {
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        if (state.isMoving()) {
            state.getController().setAnimation(RawAnimation.begin().then("animation.dolphin.swim", Animation.LoopType.LOOP));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("animation.dolphin.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.DOLPHIN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.DOLPHIN_DEATH;
    }

    public static class SwimWithSwimmersGoal
    extends Goal {
        private final Dolphin dolphin;
        private final double speed;
        private final double radius;
        @Nullable
        private Player target;
        private int recalcCooldown;

        public SwimWithSwimmersGoal(Dolphin dolphin, double speed, double radius) {
            this.dolphin = dolphin;
            this.speed = speed;
            this.radius = radius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!this.dolphin.isInWater() || this.dolphin.isBaby()) {
                return false;
            }
            if (this.recalcCooldown-- > 0) {
                return this.target != null;
            }
            this.recalcCooldown = 20 + this.dolphin.getRandom().nextInt(20);
            List players = this.dolphin.level().getEntitiesOfClass(Player.class, this.dolphin.getBoundingBox().inflate(this.radius, this.radius * 0.5, this.radius), p -> !p.isSpectator() && (p.isSwimming() || p.isUnderWater()));
            this.target = players.stream().min((a, b) -> Double.compare(a.distanceToSqr((Entity)this.dolphin), b.distanceToSqr((Entity)this.dolphin))).orElse(null);
            return this.target != null;
        }

        public boolean canContinueToUse() {
            return this.target != null && this.target.isAlive() && this.dolphin.isInWater() && (this.target.isSwimming() || this.target.isUnderWater()) && this.target.distanceToSqr((Entity)this.dolphin) <= this.radius * this.radius * 1.5;
        }

        public void stop() {
            this.target = null;
            this.dolphin.getNavigation().stop();
        }

        public void tick() {
            if (this.target == null) {
                return;
            }
            this.dolphin.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            double dist = this.dolphin.distanceTo((Entity)this.target);
            double keepDist = 2.5;
            if (dist > keepDist) {
                this.dolphin.getNavigation().moveTo((Entity)this.target, this.speed);
            } else {
                this.dolphin.getNavigation().stop();
            }
        }
    }

    public static class PlayWithNearbyItemsGoal
    extends Goal {
        private final Dolphin dolphin;
        private final double radius;
        private final int retargetDelay;
        @Nullable
        private ItemEntity targetItem;
        private int cooldown;

        public PlayWithNearbyItemsGoal(Dolphin dolphin, double radius, int retargetDelayTicks) {
            this.dolphin = dolphin;
            this.radius = radius;
            this.retargetDelay = Math.max(10, retargetDelayTicks);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!this.dolphin.isInWater() || this.dolphin.isBaby()) {
                return false;
            }
            if (this.cooldown-- > 0) {
                return false;
            }
            this.targetItem = this.findTargetItem();
            return this.targetItem != null;
        }

        public boolean canContinueToUse() {
            return this.targetItem != null && this.targetItem.isAlive() && this.dolphin.isInWater() && this.targetItem.distanceToSqr((Entity)this.dolphin) <= this.radius * this.radius;
        }

        public void stop() {
            this.targetItem = null;
            this.dolphin.getNavigation().stop();
            this.cooldown = this.retargetDelay;
        }

        public void tick() {
            if (this.targetItem == null) {
                return;
            }
            this.dolphin.getLookControl().setLookAt((Entity)this.targetItem, 30.0f, 30.0f);
            double d = this.dolphin.distanceTo((Entity)this.targetItem);
            if (d > 1.5) {
                this.dolphin.getNavigation().moveTo((Entity)this.targetItem, 1.2);
            } else {
                RandomSource r = this.dolphin.getRandom();
                double vx = (r.nextDouble() - 0.5) * 0.1;
                double vy = 0.35 + r.nextDouble() * 0.15;
                double vz = (r.nextDouble() - 0.5) * 0.1;
                this.targetItem.setDeltaMovement(this.targetItem.getDeltaMovement().add(vx, vy, vz));
                this.dolphin.playSound(SoundEvents.DOLPHIN_AMBIENT, 0.7f, 1.1f + (r.nextFloat() - 0.5f) * 0.2f);
                this.cooldown = this.retargetDelay;
                this.stop();
            }
        }

        @Nullable
        private ItemEntity findTargetItem() {
            AABB box = this.dolphin.getBoundingBox().inflate(this.radius, this.radius * 0.5, this.radius);
            List items = this.dolphin.level().getEntitiesOfClass(ItemEntity.class, box, it -> it.isAlive() && !it.hasPickUpDelay() && it.isInWater() && it.getDeltaMovement().y > -0.6);
            if (items.isEmpty()) {
                return null;
            }
            return items.stream().min((a, b) -> Double.compare(a.distanceToSqr((Entity)this.dolphin), b.distanceToSqr((Entity)this.dolphin))).orElse(null);
        }
    }
}

