/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.entity.custom.sweet;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredItem;
import net.xstarlotte.snsnf.fluid.SNSFluid;
import net.xstarlotte.snsnf.item.SNSItem;
import net.xstarlotte.snsnf.item.custom.SNSFishBuckets;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RainbowStripJellyfishEntity
extends AbstractSchoolingFish
implements Bucketable,
GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(RainbowStripJellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public RainbowStripJellyfishEntity(EntityType<? extends RainbowStripJellyfishEntity> type, Level level) {
        super(type, level);
        this.xpReward = 3;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.rainbow_strip_jellyfish.swim", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.rainbow_strip_jellyfish.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 5.0, 3));
        this.goalSelector.addGoal(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0);
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean v) {
        this.entityData.set(FROM_BUCKET, (Object)v);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROM_BUCKET, (Object)false);
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.hasCustomName() || this.fromBucket();
    }

    public boolean removeWhenFarAway(double distanceSq) {
        return !this.requiresCustomPersistence();
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        if (!this.level().isClientSide && name != null) {
            this.setPersistenceRequired();
        }
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_FISH;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    public void saveToBucketTag(ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
        stack.update(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY, data -> data.update(nbt -> nbt.putBoolean("FromBucket", true)));
    }

    public void loadFromBucketTag(CompoundTag tag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)tag);
        if (tag.contains("FromBucket")) {
            this.setFromBucket(tag.getBoolean("FromBucket"));
        } else {
            this.setFromBucket(true);
        }
    }

    public ItemStack getBucketItemStack() {
        FluidType eye;
        String fluidId;
        ResourceLocation key = EntityType.getKey((EntityType)this.getType());
        DeferredItem<Item> def = SNSFishBuckets.bucketForKey(key, fluidId = (eye = this.getEyeInFluidType()) == SNSFluid.CHOCOLATE_TYPE.get() ? "chocolate" : (eye == SNSFluid.CREAM_TYPE.get() ? "cream" : (eye == SNSFluid.MINT_WATER_TYPE.get() ? "mint_water" : "water")));
        if (def == null) {
            def = SNSFishBuckets.defaultBucketForKey(key);
        }
        ItemStack stack = new ItemStack((ItemLike)def.get());
        this.saveToBucketTag(stack);
        return stack;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        DeferredItem<Item> def;
        boolean isWaffle;
        ItemStack held = player.getItemInHand(hand);
        boolean bl = isWaffle = held.is((Item)SNSItem.WAFFLE_BUCKET.get()) || held.is((Item)SNSItem.WAFFLE_WATER_BUCKET.get()) || held.is((Item)SNSItem.WAFFLE_CREAM_BUCKET.get()) || held.is((Item)SNSItem.WAFFLE_CHOCOLATE_BUCKET.get()) || held.is((Item)SNSItem.WAFFLE_MINT_WATER_BUCKET.get());
        if (!isWaffle) {
            return super.mobInteract(player, hand);
        }
        if (this.level().isClientSide) {
            return InteractionResult.sidedSuccess((boolean)true);
        }
        ItemStack filled = this.getBucketItemStack();
        String forceFluidId = null;
        if (held.is((Item)SNSItem.WAFFLE_CHOCOLATE_BUCKET.get())) {
            forceFluidId = "chocolate";
        } else if (held.is((Item)SNSItem.WAFFLE_CREAM_BUCKET.get())) {
            forceFluidId = "cream";
        } else if (held.is((Item)SNSItem.WAFFLE_MINT_WATER_BUCKET.get())) {
            forceFluidId = "mint_water";
        } else if (held.is((Item)SNSItem.WAFFLE_WATER_BUCKET.get())) {
            forceFluidId = "water";
        }
        if (forceFluidId != null && (def = SNSFishBuckets.bucketForKey(EntityType.getKey((EntityType)this.getType()), forceFluidId)) != null) {
            filled = new ItemStack((ItemLike)def.get());
        }
        if (filled.isEmpty()) {
            return InteractionResult.PASS;
        }
        this.saveToBucketTag(filled);
        this.setFromBucket(true);
        if (!player.getAbilities().instabuild) {
            held.shrink(1);
        }
        if (held.isEmpty()) {
            player.setItemInHand(hand, filled);
        } else if (!player.getInventory().add(filled)) {
            player.drop(filled, false);
        }
        this.playSound(this.getPickupSound(), 1.0f, 1.0f);
        this.discard();
        return InteractionResult.sidedSuccess((boolean)true);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("FromBucket", this.fromBucket());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("FromBucket")) {
            this.setFromBucket(tag.getBoolean("FromBucket"));
        }
    }
}

