/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.fluid;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.xstarlotte.snsnf.item.SNSItem;

public class SNSFluid {
    public static final String MODID = "snsnf";
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"snsnf");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"snsnf");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"snsnf");
    public static final DeferredHolder<FluidType, FluidType> CHOCOLATE_TYPE = FLUID_TYPES.register("chocolate", () -> new FluidType(FluidType.Properties.create().supportsBoating(true).canConvertToSource(true).canExtinguish(true).canHydrate(true).canDrown(true).canPushEntity(true).canSwim(true).motionScale(0.014).density(1000).viscosity(1000)));
    public static final DeferredHolder<Fluid, Fluid> CHOCOLATE_SOURCE = FLUIDS.register("chocolate", () -> new BaseFlowingFluid.Source(SNSFluid.chocolateProps()));
    public static final DeferredHolder<Fluid, Fluid> CHOCOLATE_FLOWING = FLUIDS.register("chocolate_flowing", () -> new BaseFlowingFluid.Flowing(SNSFluid.chocolateProps()));
    public static final DeferredHolder<Block, Block> CHOCOLATE_BLOCK = BLOCKS.register("chocolate", () -> new LiquidBlock((FlowingFluid)CHOCOLATE_SOURCE.get(), BlockBehaviour.Properties.of().replaceable().liquid().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable()));
    private static BaseFlowingFluid.Properties CHOCOLATE_PROPS_MEMO;
    public static final DeferredHolder<FluidType, FluidType> CREAM_TYPE;
    public static final DeferredHolder<Fluid, Fluid> CREAM_SOURCE;
    public static final DeferredHolder<Fluid, Fluid> CREAM_FLOWING;
    public static final DeferredHolder<Block, Block> CREAM_BLOCK;
    private static BaseFlowingFluid.Properties CREAM_PROPS_MEMO;
    public static final DeferredHolder<FluidType, FluidType> MINT_WATER_TYPE;
    public static final DeferredHolder<Fluid, Fluid> MINT_WATER_SOURCE;
    public static final DeferredHolder<Fluid, Fluid> MINT_WATER_FLOWING;
    public static final DeferredHolder<Block, Block> MINT_WATER_BLOCK;
    private static BaseFlowingFluid.Properties MINT_WATER_PROPS_MEMO;

    private static ResourceLocation mc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)path);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return SNSFluid.tex("block/chocolate_still");
            }

            public ResourceLocation getFlowingTexture() {
                return SNSFluid.tex("block/chocolate_flow");
            }
        }, new FluidType[]{(FluidType)CHOCOLATE_TYPE.get()});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return SNSFluid.tex("block/cream_still");
            }

            public ResourceLocation getFlowingTexture() {
                return SNSFluid.tex("block/cream_flow");
            }

            public int getTintColor() {
                return -529978;
            }
        }, new FluidType[]{(FluidType)CREAM_TYPE.get()});
        event.registerFluidType(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return SNSFluid.tex("block/mint_water_still");
            }

            public ResourceLocation getFlowingTexture() {
                return SNSFluid.tex("block/mint_water_flow");
            }

            public int getTintColor() {
                return -3932173;
            }
        }, new FluidType[]{(FluidType)MINT_WATER_TYPE.get()});
    }

    private static BaseFlowingFluid.Properties chocolateProps() {
        if (CHOCOLATE_PROPS_MEMO == null) {
            CHOCOLATE_PROPS_MEMO = new BaseFlowingFluid.Properties(() -> (FluidType)CHOCOLATE_TYPE.get(), () -> (BaseFlowingFluid)CHOCOLATE_SOURCE.get(), () -> (BaseFlowingFluid)CHOCOLATE_FLOWING.get()).bucket(() -> (Item)SNSItem.WAFFLE_CHOCOLATE_BUCKET.get()).block(() -> (LiquidBlock)CHOCOLATE_BLOCK.get()).slopeFindDistance(4).levelDecreasePerBlock(1).tickRate(5);
        }
        return CHOCOLATE_PROPS_MEMO;
    }

    private static BaseFlowingFluid.Properties creamProps() {
        if (CREAM_PROPS_MEMO == null) {
            CREAM_PROPS_MEMO = new BaseFlowingFluid.Properties(() -> (FluidType)CREAM_TYPE.get(), () -> (BaseFlowingFluid)CREAM_SOURCE.get(), () -> (BaseFlowingFluid)CREAM_FLOWING.get()).bucket(() -> (Item)SNSItem.WAFFLE_CREAM_BUCKET.get()).block(() -> (LiquidBlock)CREAM_BLOCK.get()).slopeFindDistance(4).levelDecreasePerBlock(1).tickRate(5);
        }
        return CREAM_PROPS_MEMO;
    }

    private static BaseFlowingFluid.Properties mintWaterProps() {
        if (MINT_WATER_PROPS_MEMO == null) {
            MINT_WATER_PROPS_MEMO = new BaseFlowingFluid.Properties(() -> (FluidType)MINT_WATER_TYPE.get(), () -> (BaseFlowingFluid)MINT_WATER_SOURCE.get(), () -> (BaseFlowingFluid)MINT_WATER_FLOWING.get()).bucket(() -> (Item)SNSItem.WAFFLE_MINT_WATER_BUCKET.get()).block(() -> (LiquidBlock)MINT_WATER_BLOCK.get()).slopeFindDistance(4).levelDecreasePerBlock(1).tickRate(5);
        }
        return MINT_WATER_PROPS_MEMO;
    }

    private static ResourceLocation tex(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    static {
        CREAM_TYPE = FLUID_TYPES.register("cream", () -> new FluidType(FluidType.Properties.create().supportsBoating(true).canConvertToSource(true).canExtinguish(true).canSwim(true).motionScale(0.014).density(1000).viscosity(1000).canHydrate(true).canDrown(true).canPushEntity(true)));
        CREAM_SOURCE = FLUIDS.register("cream", () -> new BaseFlowingFluid.Source(SNSFluid.creamProps()));
        CREAM_FLOWING = FLUIDS.register("cream_flowing", () -> new BaseFlowingFluid.Flowing(SNSFluid.creamProps()));
        CREAM_BLOCK = BLOCKS.register("cream", () -> new LiquidBlock((FlowingFluid)CREAM_SOURCE.get(), BlockBehaviour.Properties.of().replaceable().liquid().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable()));
        MINT_WATER_TYPE = FLUID_TYPES.register("mint_water", () -> new FluidType(FluidType.Properties.create().supportsBoating(true).canConvertToSource(true).canExtinguish(true).canSwim(true).motionScale(0.014).density(1000).viscosity(1000).canHydrate(true).canDrown(true).canPushEntity(true)));
        MINT_WATER_SOURCE = FLUIDS.register("mint_water", () -> new BaseFlowingFluid.Source(SNSFluid.mintWaterProps()));
        MINT_WATER_FLOWING = FLUIDS.register("mint_water_flowing", () -> new BaseFlowingFluid.Flowing(SNSFluid.mintWaterProps()));
        MINT_WATER_BLOCK = BLOCKS.register("mint_water", () -> new LiquidBlock((FlowingFluid)MINT_WATER_SOURCE.get(), BlockBehaviour.Properties.of().replaceable().liquid().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable()));
    }
}

