/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.item;

import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.xstarlotte.snsnf.mob_effects.HerbHarmEffect;
import net.xstarlotte.snsnf.mob_effects.SNSEffect;

public class HerbEffectSwordItem
extends SwordItem {
    private final Holder<MobEffect> effect;

    public HerbEffectSwordItem(Tier tier, Item.Properties properties, Holder<MobEffect> effect) {
        super(tier, properties);
        this.effect = effect;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean result = super.hurtEnemy(stack, target, attacker);
        if (!attacker.level().isClientSide && this.effect == SNSEffect.HERB_HARM) {
            Player p;
            Player owner = attacker instanceof Player ? (p = (Player)attacker) : null;
            float totalDamage = 12.0f;
            int duration = 100;
            HerbHarmEffect.applyOrRefresh(target, attacker, owner, totalDamage, duration);
        }
        return result;
    }
}

