/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.item;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.xstarlotte.snsnf.block.SNSBlock;
import net.xstarlotte.snsnf.item.SNSItem;
import net.xstarlotte.snsnf.item.custom.SNSFishBuckets;

public class SNSTab {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"snsnf");
    public static final Supplier<CreativeModeTab> SNS_BLOCK = CREATIVE_MODE_TABS.register("sns_block", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.snsnf.sns_block")).icon(() -> new ItemStack((ItemLike)SNSBlock.PEPPERMINT_SWIRL_STONE.get())).displayItems((pParameters, out) -> {
        out.accept(SNSBlock.APPLE_FRUIT_ROLL_GRASS_BLOCK);
        out.accept(SNSBlock.BANANA_FRUIT_ROLL_GRASS_BLOCK);
        out.accept(SNSBlock.BLACKBERRY_ROLL_GRASS_BLOCK);
        out.accept(SNSBlock.BLUEBERRY_ROLL_GRASS_BLOCK);
        out.accept(SNSBlock.RASPBERRY_ROLL_GRASS_BLOCK);
        out.accept(SNSBlock.STRAWBERRY_ROLL_GRASS_BLOCK);
        SNSTab.addFamily(out, "candyfloss", "candyfloss_block");
        SNSTab.addFamily(out, "candyfloss_blue_raspberry", "candyfloss_blue_raspberry_block");
        SNSTab.addFamily(out, "candyfloss_lemon", "candyfloss_lemon_block");
        SNSTab.addFamily(out, "candyfloss_strawberry", "candyfloss_strawberry_block");
        SNSTab.addFamily(out, "candyfloss_vanilla", "candyfloss_vanilla_block");
        SNSTab.addFamily(out, "candy_cane_plank", "candy_cane_planks");
        SNSTab.addFamily(out, "chocolate_plank", "chocolate_planks");
        SNSTab.addFamily(out, "cinnamon_plank", "cinnamon_planks");
        SNSTab.addFamily(out, "crystalised_sugar_plank", "crystalised_sugar_planks");
        SNSTab.addFamily(out, "licorice_plank", "licorice_planks");
        SNSTab.addFamily(out, "rainbow_strip_plank", "rainbow_strip_planks");
        SNSTab.addFamily(out, "waffle", "waffle_block");
        SNSTab.addFamily(out, "white_chocolate_coated_waffle", "white_chocolate_coated_waffle_block");
        SNSTab.addFamily(out, "chocolate_coated_waffle", "chocolate_coated_waffle_block");
        SNSTab.addFamily(out, "dark_chocolate_coated_waffle", "dark_chocolate_coated_waffle_block");
        SNSTab.addFamily(out, "strawberry_chocolate_coated_waffle", "strawberry_chocolate_coated_waffle_block");
        out.accept(SNSBlock.CANDY_CANE_GRASS_BLOCK);
        out.accept(SNSBlock.SUGAR_DIRT_BLOCK);
        out.accept(SNSBlock.CANDY_CANE_LEAVES);
        out.accept(SNSBlock.CANDY_CANE_LOG);
        out.accept(SNSBlock.CANDY_CANE_WOOD);
        out.accept(SNSBlock.STRIPPED_CANDY_CANE_LOG);
        out.accept(SNSBlock.STRIPPED_CANDY_CANE_WOOD);
        out.accept(SNSBlock.CHOCOLATE_LEAVES);
        out.accept(SNSBlock.CHOCOLATE_LOG);
        out.accept(SNSBlock.CHOCOLATE_WOOD);
        out.accept(SNSBlock.STRIPPED_CHOCOLATE_LOG);
        out.accept(SNSBlock.STRIPPED_CHOCOLATE_WOOD);
        out.accept(SNSBlock.CINNAMON_DIRT_BLOCK);
        out.accept(SNSBlock.CINNAMON_GRASS_BLOCK);
        out.accept(SNSBlock.CINNAMON_LEAVES);
        out.accept(SNSBlock.CINNAMON_LOG);
        out.accept(SNSBlock.CINNAMON_WOOD);
        out.accept(SNSBlock.STRIPPED_CINNAMON_LOG);
        out.accept(SNSBlock.STRIPPED_CINNAMON_WOOD);
        out.accept(SNSBlock.COCOA_DIRT_BLOCK);
        out.accept(SNSBlock.COCOA_DARK_DIRT_BLOCK);
        out.accept(SNSBlock.COCOA_WHITE_DIRT_BLOCK);
        out.accept(SNSBlock.CANDYFLOSS_LEAVES);
        out.accept(SNSBlock.CANDYFLOSS_BLUE_RASPBERRY_LEAVES);
        out.accept(SNSBlock.CANDYFLOSS_LEMON_LEAVES);
        out.accept(SNSBlock.CANDYFLOSS_STRAWBERRY_LEAVES);
        out.accept(SNSBlock.CANDYFLOSS_VANILLA_LEAVES);
        out.accept(SNSBlock.CRYSTALISED_SUGAR_GLASS);
        out.accept(SNSBlock.CRYSTALISED_SUGAR_LOG);
        out.accept(SNSBlock.CRYSTALISED_SUGAR_WOOD);
        out.accept(SNSBlock.STRIPPED_CRYSTALISED_SUGAR_LOG);
        out.accept(SNSBlock.STRIPPED_CRYSTALISED_SUGAR_WOOD);
        out.accept(SNSBlock.LICORICE_LOG);
        out.accept(SNSBlock.LICORICE_WOOD);
        out.accept(SNSBlock.STRIPPED_LICORICE_LOG);
        out.accept(SNSBlock.STRIPPED_LICORICE_WOOD);
        out.accept(SNSBlock.RAINBOW_STRIP_GRASS_BLOCK);
        out.accept(SNSBlock.RAINBOW_STRIP_LEAVES);
        out.accept(SNSBlock.RAINBOW_STRIP_LOG);
        out.accept(SNSBlock.RAINBOW_STRIP_WOOD);
        out.accept(SNSBlock.STRIPPED_RAINBOW_STRIP_LOG);
        out.accept(SNSBlock.STRIPPED_RAINBOW_STRIP_WOOD);
        SNSTab.addFamily(out, "chocolate", "chocolate_block");
        SNSTab.addFamily(out, "chocolate_dark", "chocolate_dark_block");
        SNSTab.addFamily(out, "chocolate_white", "chocolate_white_block");
        SNSTab.addFamily(out, "mint", "mint_block");
        SNSTab.addFamily(out, "chocolate_brick", "chocolate_bricks");
        SNSTab.addFamily(out, "chocolate_dark_brick", "chocolate_dark_bricks");
        SNSTab.addFamily(out, "chocolate_white_brick", "chocolate_white_bricks");
        SNSTab.addFamily(out, "mint_brick", "mint_brick");
        SNSTab.addFamily(out, "humbug_brick", "humbug_brick");
        SNSTab.addFamily(out, "peppermint_swirl_brick", "peppermint_swirl_brick");
        SNSTab.addFamily(out, "rhubarb_custard_brick", "rhubarb_custard_brick");
        SNSTab.addFamily(out, "strawberry_cream_brick", "strawberry_cream_brick");
        SNSTab.addFamily(out, "waffle_brick", "waffle_bricks");
        SNSTab.addFamily(out, "peppermint_swirl_stone", "peppermint_swirl_stone");
        SNSTab.addFamily(out, "rhubarb_custard_stone", "rhubarb_custard_stone");
        SNSTab.addFamily(out, "strawberry_cream_stone", "strawberry_cream_stone");
        out.accept(SNSBlock.PEPPERMINT_SWIRL_STONE_COAL_ORE);
        SNSTab.addFamily(out, "gummy_apple", "gummy_apple_block");
        SNSTab.addFamily(out, "gummy_banana", "gummy_banana_block");
        SNSTab.addFamily(out, "gummy_blackberry", "gummy_blackberry_block");
        SNSTab.addFamily(out, "gummy_blueberry", "gummy_blueberry_block");
        SNSTab.addFamily(out, "gummy_raspberry", "gummy_raspberry_block");
        SNSTab.addFamily(out, "gummy_strawberry", "gummy_strawberry_block");
        SNSTab.addFamily(out, "carrot_cake", "carrot_cake_block", false, false);
        SNSTab.addFamily(out, "chocolate_cherry_cake", "chocolate_cherry_cake_block", false, false);
        SNSTab.addFamily(out, "chocolate_mint_cake", "chocolate_mint_cake_block", false, false);
        SNSTab.addFamily(out, "chocolate_orange_cake", "chocolate_orange_cake_block", false, false);
        SNSTab.addFamily(out, "lemon_curd_cake", "lemon_curd_cake_block", false, false);
        SNSTab.addFamily(out, "raspberry_cake", "raspberry_cake_block", false, false);
        SNSTab.addFamily(out, "strawberry_cake", "strawberry_cake_block", false, false);
        SNSTab.addFamily(out, "victoria_sponge_cake", "victoria_sponge_cake_block", false, false);
        out.accept(SNSBlock.BLACKBERRY_SORBET_SAND);
        out.accept(SNSBlock.BLUEBERRY_SORBET_SAND);
        out.accept(SNSBlock.LEMON_SORBET_SAND);
        out.accept(SNSBlock.ORANGE_SORBET_SAND);
        out.accept(SNSBlock.PINEAPPLE_SORBET_SAND);
        out.accept(SNSBlock.RASPBERRY_SORBET_SAND);
        out.accept(SNSBlock.STRAWBERRY_SORBET_SAND);
        out.accept(SNSBlock.SPRINKLES_SAND_PINK);
        out.accept(SNSBlock.SPRINKLES_SAND_ORANGE);
        SNSTab.addFamily(out, "pretzel", "pretzel_block");
    }).build());
    public static final Supplier<CreativeModeTab> SNS_DECORATION = CREATIVE_MODE_TABS.register("sns_decoration", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.snsnf.sns_decoration")).icon(() -> new ItemStack((ItemLike)SNSBlock.WAFFLE_BED.get())).displayItems((pParameters, out) -> {
        out.accept(SNSBlock.BLACKBERRY_LANTERN);
        out.accept(SNSBlock.BLUEBERRY_LANTERN);
        out.accept(SNSBlock.RASPBERRY_LANTERN);
        out.accept(SNSBlock.STRAWBERRY_LANTERN);
        out.accept(SNSBlock.BLACKBERRY_LOLLIPOP_LANTERN);
        out.accept(SNSBlock.BLUEBERRY_LOLLIPOP_LANTERN);
        out.accept(SNSBlock.RASPBERRY_LOLLIPOP_LANTERN);
        out.accept(SNSBlock.STRAWBERRY_LOLLIPOP_LANTERN);
        out.accept(SNSBlock.CANDYFLOSS_LANTERN);
        out.accept(SNSBlock.CANDY_CANE_LADDER);
        out.accept(SNSBlock.CANDY_CANE_LANTERN);
        out.accept(SNSItem.CANDY_CANE_TORCH_ITEM);
        out.accept(SNSBlock.CHOCOLATE_LADDER);
        out.accept(SNSItem.CHOCOLATE_TORCH_ITEM);
        out.accept(SNSBlock.CHOCOLATE_FURNACE);
        out.accept(SNSItem.CINNAMON_TORCH_ITEM);
        out.accept(SNSBlock.CRYSTALISED_SUGAR_FURNACE);
        out.accept(SNSItem.CRYSTALISED_SUGAR_TORCH_ITEM);
        out.accept(SNSBlock.ICE_CREAM_LANTERN);
        out.accept(SNSItem.WAFFLE_TORCH_ITEM);
        out.accept(SNSBlock.CANDY_CANE_CAT_TEDDY);
        out.accept(SNSBlock.CINNADILE_TEDDY);
        out.accept(SNSBlock.CINNAMON_LADDER);
        out.accept(SNSBlock.MINT_MINK_TEDDY);
        out.accept(SNSBlock.MYNX_TEDDY);
        out.accept(SNSBlock.CANDY_CANE_BED);
        out.accept(SNSBlock.CHOCOLATE_BED);
        out.accept(SNSBlock.WAFFLE_BED);
        out.accept(SNSBlock.WAFFLE_CHEST);
        out.accept(SNSBlock.WAFFLE_LADDER);
        out.accept(SNSBlock.CANDY_CANE_FURNACE);
        out.accept(SNSBlock.BOURBON_CARPET);
        out.accept(SNSBlock.CUSTARD_CREAM_CARPET);
        out.accept(SNSBlock.PEPPERMINT_SWIRL_CARPET);
        out.accept(SNSBlock.RAINBOW_STRIP_LADDER);
        out.accept(SNSItem.RAINBOW_STRIP_TORCH_ITEM);
    }).build());
    public static final Supplier<CreativeModeTab> SNS_FLORA = CREATIVE_MODE_TABS.register("sns_flora", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.snsnf.sns_flora")).icon(() -> new ItemStack((ItemLike)SNSBlock.CANDY_CANE_SAPLING.get())).displayItems((pParameters, out) -> {
        out.accept(SNSBlock.APPLE_FRUIT_ROLL_BUSH);
        out.accept(SNSBlock.BANANA_FRUIT_ROLL_BUSH);
        out.accept(SNSBlock.BLACKBERRY_ROLL_BUSH);
        out.accept(SNSBlock.BLUEBERRY_ROLL_BUSH);
        out.accept(SNSBlock.RASPBERRY_ROLL_BUSH);
        out.accept(SNSBlock.STRAWBERRY_ROLL_BUSH);
        out.accept(SNSBlock.CANDYFLOSS_BUSH);
        out.accept(SNSBlock.CANDYFLOSS_COSMOS);
        out.accept(SNSBlock.CANDYFLOSS_COSMOS_2);
        out.accept(SNSBlock.CANDYFLOSS_COSMOS_3);
        out.accept(SNSBlock.CANDYFLOSS_COSMOS_4);
        out.accept(SNSBlock.CANDYFLOSS_COSMOS_5);
        out.accept(SNSBlock.CANDYFLOSS_GRASS);
        out.accept(SNSBlock.CANDYFLOSS_GRASS_SHORT);
        out.accept(SNSBlock.CANDY_CANE_BUSH);
        out.accept(SNSBlock.CANDY_CANE_CARNATION);
        out.accept(SNSBlock.CANDY_CANE_FLOWER);
        out.accept(SNSBlock.CANDY_CANE_FLOWER_2);
        out.accept(SNSBlock.CANDY_CANE_FLOWER_3);
        out.accept(SNSBlock.CANDY_CANE_FLOWER_4);
        out.accept(SNSBlock.CANDY_CANE_GRASS);
        out.accept(SNSBlock.CANDY_CANE_GRASS_LONG);
        out.accept(SNSBlock.CANDYFLOSS_SAPLING);
        out.accept(SNSBlock.CANDY_CANE_SUGAR_CANE);
        out.accept(SNSBlock.CANDY_CANE_SAPLING);
        out.accept(SNSBlock.CHOCOLATE_GRASS);
        out.accept(SNSBlock.CHOCOLATE_SAPLING);
        out.accept(SNSBlock.CINNAMON_FLOWER);
        out.accept(SNSBlock.CINNAMON_FLOWER_2);
        out.accept(SNSBlock.CINNAMON_GRASS);
        out.accept(SNSBlock.CINNAMON_GRASS_LONG);
        out.accept(SNSBlock.CINNAMON_SAPLING);
        out.accept(SNSBlock.MINT_BUSH);
        out.accept(SNSBlock.MINT_FLOWER);
        out.accept(SNSBlock.MINT_FLOWER_2);
        out.accept(SNSBlock.MINT_FLOWER_3);
        out.accept(SNSBlock.MINT_GRASS);
        out.accept(SNSBlock.MINT_GRASS_LONG);
        out.accept(SNSBlock.RAINBOW_STRIP_FLOWER);
        out.accept(SNSBlock.RAINBOW_STRIP_FLOWER_2);
        out.accept(SNSBlock.RAINBOW_STRIP_GRASS);
        out.accept(SNSBlock.RAINBOW_STRIP_GRASS_LONG);
        out.accept(SNSBlock.RAINBOW_STRIP_SAPLING);
    }).build());
    public static final Supplier<CreativeModeTab> SNS_COMBAT = CREATIVE_MODE_TABS.register("sns_combat", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.snsnf.sns_combat")).icon(() -> new ItemStack((ItemLike)SNSItem.CANDY_CANE_HELMET.get())).displayItems((pParameters, out) -> {
        out.accept(SNSItem.CANDY_CANE_HELMET);
        out.accept(SNSItem.CANDY_CANE_CHESTPLATE);
        out.accept(SNSItem.CANDY_CANE_LEGGINGS);
        out.accept(SNSItem.CANDY_CANE_BOOTS);
    }).build());
    public static final Supplier<CreativeModeTab> SNS_ITEM = CREATIVE_MODE_TABS.register("sns_item", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.snsnf.sns_item")).icon(() -> new ItemStack((ItemLike)SNSItem.CANDY_CANE.get())).withTabsBefore(new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"sns_block")}).displayItems((pParameters, out) -> {
        out.accept(SNSItem.ANGEL_CAKE);
        out.accept(SNSItem.BLACKBERRY_LOLLIPOP);
        out.accept(SNSItem.BLUEBERRY_LOLLIPOP);
        out.accept(SNSItem.RASPBERRY_LOLLIPOP);
        out.accept(SNSItem.STRAWBERRY_LOLLIPOP);
        out.accept(SNSItem.LEMON_LOLLIPOP);
        out.accept(SNSItem.ORANGE_LOLLIPOP);
        out.accept(SNSItem.CANDYFLOSS);
        out.accept(SNSItem.CANDYFLOSS_BLUE_RASPBERRY);
        out.accept(SNSItem.CANDYFLOSS_LEMON);
        out.accept(SNSItem.CANDYFLOSS_STRAWBERRY);
        out.accept(SNSItem.CANDYFLOSS_VANILLA);
        out.accept(SNSItem.CANDY_CANE);
        out.accept(SNSItem.CANDY_CANE_ESSENCE_SHARD);
        out.accept(SNSItem.CANDY_CANE_SUGAR);
        out.accept(SNSItem.CANDY_CANE_SWORD);
        out.accept(SNSItem.CHOCOLATE_EGG);
        out.accept(SNSItem.CHOCOLATE_DARK_EGG);
        out.accept(SNSItem.CHOCOLATE_WHITE_EGG);
        out.accept(SNSItem.CHOCOLATE_STICK);
        out.accept(SNSItem.CINNAMON);
        out.accept(SNSItem.CINNAMON_BUN);
        out.accept(SNSItem.CINNAMON_STICK);
        out.accept(SNSItem.COLA_BOTTLE);
        out.accept(SNSItem.CONE);
        out.accept(SNSItem.CRYSTALISED_SUGAR_STICK);
        out.accept(SNSItem.GELATIN);
        out.accept(SNSItem.GUMMY_APPLE);
        out.accept(SNSItem.GUMMY_BANANA);
        out.accept(SNSItem.GUMMY_BLACKBERRY);
        out.accept(SNSItem.GUMMY_BLUEBERRY);
        out.accept(SNSItem.GUMMY_RASPBERRY);
        out.accept(SNSItem.GUMMY_STRAWBERRY);
        out.accept(SNSItem.HUMBUG);
        out.accept(SNSItem.ICE_CREAM);
        out.accept(SNSItem.VANILLA_ICE_CREAM);
        out.accept(SNSItem.MINT_IMPERIAL);
        out.accept(SNSItem.VANILLA_MARSHMALLOW);
        out.accept(SNSItem.BLACKBERRY_MARSHMALLOW);
        out.accept(SNSItem.BLUEBERRY_MARSHMALLOW);
        out.accept(SNSItem.RASPBERRY_MARSHMALLOW);
        out.accept(SNSItem.STRAWBERRY_MARSHMALLOW);
        out.accept(SNSItem.CHOCOLATE_MARSHMALLOW);
        out.accept(SNSItem.MINT_MARSHMALLOW);
        out.accept(SNSItem.PEPPERMINT_SWIRL);
        out.accept(SNSItem.POLO);
        out.accept(SNSItem.PRETZEL);
        out.accept(SNSItem.RAINBOW_STRIP);
        out.accept(SNSItem.RAINBOW_STRIP_STICK);
        out.accept(SNSItem.RHUBARB_CUSTARD);
        out.accept(SNSItem.STRAWBERRY_CREAM);
        out.accept(SNSItem.SPRINKLES_PINK);
        out.accept(SNSItem.SPRINKLES_ORANGE);
        out.accept(SNSItem.WAFFLE_BUCKET);
        for (DeferredItem<Item> bucket : SNSFishBuckets.allFilledBuckets()) {
            out.accept((ItemLike)bucket.get());
        }
        out.accept(SNSItem.WAFFLE_CHOCOLATE_BUCKET);
        out.accept(SNSItem.WAFFLE_CREAM_BUCKET);
        out.accept(SNSItem.WAFFLE_MINT_WATER_BUCKET);
        out.accept(SNSItem.WAFFLE_WATER_BUCKET);
        out.accept(SNSItem.WAFFLE_STICK);
    }).build());
    public static final Supplier<CreativeModeTab> SNS_SPAWN_EGG = CREATIVE_MODE_TABS.register("sns_spawn_egg", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.snsnf.sns_spawn_egg")).icon(() -> new ItemStack((ItemLike)SNSItem.CHEESECAKE_MOUSE_SPAWN_EGG.get())).displayItems((pParameters, out) -> {
        out.accept(SNSItem.ANGEL_CAKE_FISH_SPAWN_EGG);
        out.accept(SNSItem.BLACKBOARRY_SPAWN_EGG);
        out.accept(SNSItem.BLUEBOARRY_SPAWN_EGG);
        out.accept(SNSItem.RASPBOARRY_SPAWN_EGG);
        out.accept(SNSItem.STRAWBOARRY_SPAWN_EGG);
        out.accept(SNSItem.BONBONBINI_SPAWN_EGG);
        out.accept(SNSItem.BUNANA_SPAWN_EGG);
        out.accept(SNSItem.CAKE_RABBIT_SPAWN_EGG);
        out.accept(SNSItem.CANDYFLOSS_LION_SPAWN_EGG);
        out.accept(SNSItem.CANDYFLOSS_SHEEP_SPAWN_EGG);
        out.accept(SNSItem.CANDY_CANE_CAT_SPAWN_EGG);
        out.accept(SNSItem.CANDY_CANE_CERBERUS_SPAWN_EGG);
        out.accept(SNSItem.CANDY_CANE_CROOK_SPAWN_EGG);
        out.accept(SNSItem.CANDY_CANE_FLY_SPAWN_EGG);
        out.accept(SNSItem.CANDY_CANE_TIGER_SPAWN_EGG);
        out.accept(SNSItem.CANDY_CANE_ZEBRA_SPAWN_EGG);
        out.accept(SNSItem.CHEESECAKE_MOUSE_SPAWN_EGG);
        out.accept(SNSItem.CHOCCOON_SPAWN_EGG);
        out.accept(SNSItem.CHOCOLATE_CHICKEN_SPAWN_EGG);
        out.accept(SNSItem.CHOCOLATE_PENGUIN_SPAWN_EGG);
        out.accept(SNSItem.CHOCOLATE_PIGEON_SPAWN_EGG);
        out.accept(SNSItem.CHOCOLATE_REINDEER_SPAWN_EGG);
        out.accept(SNSItem.CINNABUN_SPAWN_EGG);
        out.accept(SNSItem.CINNADILE_SPAWN_EGG);
        out.accept(SNSItem.CINNAFFIN_SPAWN_EGG);
        out.accept(SNSItem.CINNAMANTA_RAY_SPAWN_EGG);
        out.accept(SNSItem.CINNAMOTH_SPAWN_EGG);
        out.accept(SNSItem.COLA_BOTTLENOSE_DOLPHIN_SPAWN_EGG);
        out.accept(SNSItem.DUCKANA_SPAWN_EGG);
        out.accept(SNSItem.ECLAIR_DOG_SPAWN_EGG);
        out.accept(SNSItem.FRUIT_ELF_SPAWN_EGG);
        out.accept(SNSItem.FRUIT_PUG_SPAWN_EGG);
        out.accept(SNSItem.GINGERBREAD_MAN_SPAWN_EGG);
        out.accept(SNSItem.GUMMY_BEAR_SPAWN_EGG);
        out.accept(SNSItem.GUMMY_FISH_SPAWN_EGG);
        out.accept(SNSItem.HAPPLE_SPAWN_EGG);
        out.accept(SNSItem.HUMBUG_SPAWN_EGG);
        out.accept(SNSItem.HUMBULL_SPAWN_EGG);
        out.accept(SNSItem.HUMFLY_SPAWN_EGG);
        out.accept(SNSItem.HUMPUG_SPAWN_EGG);
        out.accept(SNSItem.ICE_CREAM_COW_SPAWN_EGG);
        out.accept(SNSItem.ICE_CREAM_FISH_SPAWN_EGG);
        out.accept(SNSItem.JAMSTER_SPAWN_EGG);
        out.accept(SNSItem.JELLY_BABY_SPAWN_EGG);
        out.accept(SNSItem.LACE_SNAKE_SPAWN_EGG);
        out.accept(SNSItem.LACE_SPIDER_SPAWN_EGG);
        out.accept(SNSItem.MINT_MINK_SPAWN_EGG);
        out.accept(SNSItem.MINTOW_SPAWN_EGG);
        out.accept(SNSItem.MINTMUNK_SPAWN_EGG);
        out.accept(SNSItem.MINT_IMPERIAL_SPAWN_EGG);
        out.accept(SNSItem.MARSHMALLOW_SHEEP_SPAWN_EGG);
        out.accept(SNSItem.MYNX_SPAWN_EGG);
        out.accept(SNSItem.PARFAIT_PIXIE_SPAWN_EGG);
        out.accept(SNSItem.PEPPERMINT_CHURL_SPAWN_EGG);
        out.accept(SNSItem.PEPPERMINT_TWIRL_SPAWN_EGG);
        out.accept(SNSItem.PRETZELFLY_SPAWN_EGG);
        out.accept(SNSItem.RAINBOW_STRIP_JELLYFISH_SPAWN_EGG);
        out.accept(SNSItem.RAINBOW_STRIP_PEGASUS_SPAWN_EGG);
        out.accept(SNSItem.RAINBOW_STRIP_PHOENIX_SPAWN_EGG);
        out.accept(SNSItem.RAINBOW_STRIP_UNICORN_SPAWN_EGG);
        out.accept(SNSItem.SNAPPLE_SPAWN_EGG);
        out.accept(SNSItem.SQUIRROLL_SPAWN_EGG);
        out.accept(SNSItem.SUGARGLIDER_SPAWN_EGG);
        out.accept(SNSItem.SUGAR_WRAPPED_MUMMY_SPAWN_EGG);
        out.accept(SNSItem.TREAT_TOAD_SPAWN_EGG);
        out.accept(SNSItem.WAFER_WHALE_SPAWN_EGG);
        out.accept(SNSItem.WAFER_WITCH_SPAWN_EGG);
        out.accept(SNSItem.WAFFLE_FISH_SPAWN_EGG);
        out.accept(SNSItem.WAFFLE_FISH_MINI_SPAWN_EGG);
    }).build());

    private static void acceptId(CreativeModeTab.Output out, String id) {
        try {
            out.accept(SNSBlock.byId(id));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void addFamily(CreativeModeTab.Output out, String partsBase, String baseBlockId, boolean includeDoor, boolean includeTrapdoor) {
        SNSTab.acceptId(out, baseBlockId);
        SNSTab.acceptId(out, partsBase + "_button");
        if (includeDoor) {
            SNSTab.acceptId(out, partsBase + "_door");
        }
        SNSTab.acceptId(out, partsBase + "_fence");
        SNSTab.acceptId(out, partsBase + "_fence_gate");
        SNSTab.acceptId(out, partsBase + "_pressure_plate");
        SNSTab.acceptId(out, partsBase + "_slab");
        SNSTab.acceptId(out, partsBase + "_stairs");
        if (includeTrapdoor) {
            SNSTab.acceptId(out, partsBase + "_trapdoor");
        }
        SNSTab.acceptId(out, partsBase + "_wall");
    }

    private static void addFamily(CreativeModeTab.Output out, String partsBase, String baseBlockId) {
        SNSTab.addFamily(out, partsBase, baseBlockId, true, true);
    }

    public static void register(IEventBus eventBus) {
        CREATIVE_MODE_TABS.register(eventBus);
    }
}

