/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.item.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.xstarlotte.snsnf.item.SNSItem;

public class SNSEmptyBucketItem
extends BucketItem {
    public SNSEmptyBucketItem(Item.Properties props) {
        super(Fluids.EMPTY, props.stacksTo(16));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult hit;
        InteractionResultHolder res = super.use(level, player, hand);
        if (!res.getResult().consumesAction() && (hit = SNSEmptyBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)).getType() == HitResult.Type.BLOCK) {
            BucketPickup picker;
            ItemStack picked;
            Block block;
            BlockPos pos = hit.getBlockPos();
            if (!level.mayInteract(player, pos)) {
                return InteractionResultHolder.pass((Object)((ItemStack)res.getObject()));
            }
            BlockState state = level.getBlockState(pos);
            FluidState fs = state.getFluidState();
            if (fs.isSource() && fs.getType() == Fluids.WATER && (block = state.getBlock()) instanceof BucketPickup && !(picked = (picker = (BucketPickup)block).pickupBlock(player, (LevelAccessor)level, pos, state)).isEmpty()) {
                level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
                if (!level.isClientSide) {
                    ItemStack leftovers;
                    boolean creative = player.getAbilities().instabuild;
                    player.setItemInHand(hand, new ItemStack((ItemLike)SNSItem.WAFFLE_WATER_BUCKET.get()));
                    if (!creative && ((ItemStack)res.getObject()).getCount() > 1 && !player.addItem(leftovers = new ItemStack((ItemLike)SNSItem.WAFFLE_BUCKET.get(), ((ItemStack)res.getObject()).getCount() - 1))) {
                        player.drop(leftovers, false);
                    }
                }
                return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide);
            }
        }
        return res;
    }
}

