/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.item.custom;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.registries.DeferredItem;
import net.xstarlotte.snsnf.entity.SNSEntity;
import net.xstarlotte.snsnf.fluid.SNSFluid;
import net.xstarlotte.snsnf.item.SNSItem;
import net.xstarlotte.snsnf.item.custom.SNSBucketItem;

public final class SNSFishBuckets {
    public static final List<FishSpec> FISHES = List.of(new FishSpec("angel_cake_fish", SNSEntity.ANGEL_CAKE_FISH, "Angel Cake Fish"), new FishSpec("cinnamanta_ray", SNSEntity.CINNAMANTA_RAY, "Cinnamanta Ray"), new FishSpec("gummy_fish", SNSEntity.GUMMY_FISH, "Gummy Fish"), new FishSpec("ice_cream_fish", SNSEntity.ICE_CREAM_FISH, "Ice Cream Fish"), new FishSpec("mintow", SNSEntity.MINTOW, "Mintow"), new FishSpec("rainbow_strip_jellyfish", SNSEntity.RAINBOW_STRIP_JELLYFISH, "Rainbow Strip Jellyfish"), new FishSpec("waffle_fish", SNSEntity.WAFFLE_FISH, "Waffle Fish"), new FishSpec("waffle_fish_mini", SNSEntity.WAFFLE_FISH_MINI, "Mini Waffle Fish"));
    public static final List<FluidSpec> FLUIDS = List.of(new FluidSpec("water", () -> Fluids.WATER, "Water"), new FluidSpec("chocolate", (Supplier<? extends Fluid>)SNSFluid.CHOCOLATE_SOURCE, "Chocolate"), new FluidSpec("cream", (Supplier<? extends Fluid>)SNSFluid.CREAM_SOURCE, "Cream"), new FluidSpec("mint_water", (Supplier<? extends Fluid>)SNSFluid.MINT_WATER_SOURCE, "Mint Water"));
    public static final String DEFAULT_FLUID_ID = "water";
    private static final Map<ResourceLocation, Map<String, DeferredItem<Item>>> BY_KEY = new HashMap<ResourceLocation, Map<String, DeferredItem<Item>>>();

    private SNSFishBuckets() {
    }

    public static void registerFilledBuckets() {
        for (FishSpec fish : FISHES) {
            ResourceLocation fishKey = ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)fish.id());
            HashMap<String, DeferredItem> perFluid = new HashMap<String, DeferredItem>();
            for (FluidSpec fluid : FLUIDS) {
                String itemId = fish.id() + "_" + fluid.id() + "_bucket";
                DeferredItem bucket = SNSItem.ITEMS.registerItem(itemId, props -> new SNSBucketItem(fish.entity(), fluid.fluid().get(), (Item.Properties)props), new Item.Properties().stacksTo(1));
                perFluid.put(fluid.id(), bucket);
            }
            BY_KEY.put(fishKey, perFluid);
        }
    }

    public static DeferredItem<Item> bucketForKey(ResourceLocation fishKey, String fluidId) {
        Map<String, DeferredItem<Item>> perFluid = BY_KEY.get(fishKey);
        return perFluid == null ? null : perFluid.get(fluidId);
    }

    public static DeferredItem<Item> defaultBucketForKey(ResourceLocation fishKey) {
        return SNSFishBuckets.bucketForKey(fishKey, DEFAULT_FLUID_ID);
    }

    public static Collection<DeferredItem<Item>> allFilledBuckets() {
        return BY_KEY.values().stream().flatMap(map -> map.values().stream()).toList();
    }

    public static ResourceLocation baseBucketTex() {
        return ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"item/waffle_bucket");
    }

    public static ResourceLocation liquidTex(String fluidId) {
        return ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)("item/liquids/" + fluidId + "_fill"));
    }

    public static ResourceLocation fishTex(String fishId) {
        return ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)("item/fish/" + fishId));
    }

    public record FishSpec(String id, Supplier<? extends EntityType<? extends Mob>> entity, String displayName) {
    }

    public record FluidSpec(String id, Supplier<? extends Fluid> fluid, String displayName) {
    }
}

