/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.item.custom.armor.effects;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.xstarlotte.snsnf.item.custom.armor.effects.SNSArmorEffects;

public final class FruitArmorEffects
implements SNSArmorEffects {
    @Override
    public void onWearerWasHit(LivingEntity wearer, Entity attacker, DamageSource src, float amount, boolean fullSet, double scalar) {
        Level level;
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)attacker;
        float dmg = (float)(2.0 * scalar * (fullSet ? 1.5 : 1.0));
        if (dmg > 0.0f && (level = wearer.level()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            DamageSource ds = sl.damageSources().mobAttack(wearer);
            le.hurt(ds, dmg);
        }
        FruitArmorEffects.knockFrom(le, (Entity)wearer, (float)((double)0.6f * (fullSet ? 1.25 : 1.0)));
    }

    private static void knockFrom(LivingEntity victim, Entity from, float strength) {
        double dx = victim.getX() - from.getX();
        double dz = victim.getZ() - from.getZ();
        double norm = Math.max(Math.hypot(dx, dz), 1.0E-4);
        victim.push(dx / norm * (double)strength, 0.15, dz / norm * (double)strength);
        victim.hasImpulse = true;
    }
}

