/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.mixin;

import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.xstarlotte.snsnf.mob_effects.SNSEffect;
import net.xstarlotte.snsnf.util.IEntityHerbEffect;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements IEntityHerbEffect {
    @Unique
    LivingEntity livingEntity = (LivingEntity)this;
    @Unique
    UUID affectedEntityUUID;

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void SNS$tick(CallbackInfo ci) {
        if (this.livingEntity.level().getGameTime() % 20L == 0L && this.livingEntity.hasEffect(SNSEffect.HERB_EFFECT)) {
            Player playerA;
            Registry dTypeReg = this.livingEntity.damageSources().damageTypes;
            Holder.Reference dType = dTypeReg.getHolderOrThrow(DamageTypes.MAGIC);
            this.livingEntity.hurt(new DamageSource((Holder)dType), 2.0f);
            if (this.SNS$getAffectedEntity() != null && (playerA = this.livingEntity.level().getPlayerByUUID(this.SNS$getAffectedEntity())) != null) {
                playerA.heal(2.0f);
            }
        }
    }

    @Override
    public UUID SNS$getAffectedEntity() {
        return this.affectedEntityUUID;
    }

    @Override
    public void SNS$setAffectedEntity(UUID uuid) {
        this.affectedEntityUUID = uuid;
    }
}

