/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.mob_effects;

import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.xstarlotte.snsnf.mob_effects.SNSEffect;

public class HerbHarmEffect
extends MobEffect {
    public static final String KEY = "snsnf_herb_harm";
    private static final String APPLIER = "applier";
    private static final String OWNER = "owner";
    private static final String PER_TICK = "perTick";
    private static final String END_TICK = "endTick";

    public HerbHarmEffect() {
        super(MobEffectCategory.HARMFUL, 0x8B0000);
    }

    public boolean shouldApplyEffectTickThisTick(int tickCount, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity target, int amplifier) {
        long end;
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel level2 = (ServerLevel)level;
        CompoundTag root = target.getPersistentData();
        CompoundTag tag = root.getCompound(KEY);
        Holder<MobEffect> HERB_HARM = SNSEffect.HERB_HARM;
        if (tag.isEmpty()) {
            target.removeEffect(HERB_HARM);
            return true;
        }
        long now = level2.getGameTime();
        if (now >= (end = tag.getLong(END_TICK))) {
            target.removeEffect(HERB_HARM);
            root.remove(KEY);
            return true;
        }
        float perTick = tag.getFloat(PER_TICK);
        if (perTick > 0.0f) {
            Player p;
            LivingEntity le;
            Entity e;
            DamageSource src = level2.damageSources().generic();
            target.hurt(src, perTick);
            if (tag.hasUUID(APPLIER) && (e = level2.getEntity(tag.getUUID(APPLIER))) instanceof LivingEntity && (le = (LivingEntity)e).isAlive()) {
                le.heal(perTick);
            }
            if (tag.hasUUID(OWNER) && (e = level2.getEntity(tag.getUUID(OWNER))) instanceof Player && (p = (Player)e).isAlive()) {
                p.heal(perTick);
            }
        }
        return true;
    }

    public static void applyOrRefresh(LivingEntity target, LivingEntity applier, Player owner, float totalDamage, int durationTicks) {
        Level level = target.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        float perTick = Math.max(0.001f, totalDamage / (float)Math.max(1, durationTicks));
        long now = level2.getGameTime();
        long end = now + (long)durationTicks;
        CompoundTag root = target.getPersistentData();
        CompoundTag tag = root.getCompound(KEY);
        tag.putFloat(PER_TICK, perTick);
        tag.putLong(END_TICK, Math.max(end, tag.getLong(END_TICK)));
        tag.putUUID(APPLIER, applier.getUUID());
        if (owner != null) {
            tag.putUUID(OWNER, owner.getUUID());
        } else {
            tag.remove(OWNER);
        }
        root.put(KEY, (Tag)tag);
        target.addEffect(new MobEffectInstance(SNSEffect.HERB_HARM, durationTicks, 0, true, true, true));
    }

    public static void clear(LivingEntity target) {
        target.getPersistentData().remove(KEY);
        target.removeEffect(SNSEffect.HERB_HARM);
    }
}

