/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.xstarlotte.snsnf.menu.WaffleChestMenu;

public class WaffleChestScreen
extends AbstractContainerScreen<WaffleChestMenu> {
    private static final ResourceLocation TEX = ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)"textures/gui/container/waffle_chest.png");
    private final int rows;

    public WaffleChestScreen(WaffleChestMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.rows = menu.getRows();
        this.imageWidth = 176;
        this.imageHeight = 114 + this.rows * 18;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void renderBg(GuiGraphics gfx, float partial, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int topHeight = this.rows * 18 + 17;
        gfx.blit(TEX, x, y, 0.0f, 0.0f, this.imageWidth, topHeight, 256, 256);
        gfx.blit(TEX, x, y + topHeight, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partial) {
        this.renderBackground(gfx, mouseX, mouseY, partial);
        super.render(gfx, mouseX, mouseY, partial);
        this.renderTooltip(gfx, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
    }
}

