/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.worldgen.biome;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.xstarlotte.snsnf.entity.SNSEntity;
import net.xstarlotte.snsnf.worldgen.SNSPlacedFeatures;

public class SNSDimensionBiomes {
    public static Biome cakeCanopy(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CAKE_RABBIT.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CHEESECAKE_MOUSE.get(), 10, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.ECLAIR_DOG.get(), 10, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.GINGERBREAD_MAN.get(), 10, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.SQUIRROLL.get(), 10, 1, 1));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.ANGEL_CAKE_FISH.get(), 10, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome pretzelPrairie(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.PRETZELFLY.get(), 20, 2, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome appleAcres(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.HAPPLE.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.SNAPPLE.get(), 10, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.FRUIT_ROLL_PLACED_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.1f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome bananaBayou(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.BUNANA.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.DUCKANA.get(), 10, 1, 1));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.FRUIT_ROLL_PLACED_KEY_2);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome blackberryBrambles(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.BLACKBOARRY.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.JAMSTER.get(), 10, 2, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.FRUIT_ROLL_PLACED_KEY_3);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.4f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome blueberryBluff(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.BLUEBOARRY.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.JAMSTER.get(), 10, 2, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.FRUIT_ROLL_PLACED_KEY_4);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome raspberryRise(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.RASPBOARRY.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.JAMSTER.get(), 10, 2, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.FRUIT_ROLL_PLACED_KEY_5);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.6f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome strawberryStrand(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.STRAWBOARRY.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.JAMSTER.get(), 10, 2, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.FRUIT_ROLL_PLACED_KEY_6);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.7f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome cinnamonCraig(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CINNABUN.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CINNADILE.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CINNAFFIN.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.CINNAMANTA_RAY.get(), 20, 1, 2));
        spawnBuilder.addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.CINNAMOTH.get(), 10, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.GINGERBREAD_MAN.get(), 10, 1, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.SKELETON_HORSE, 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 50, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CINNAMON_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CINNAMON_PLACED_KEY_2);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CINNAMON_PLACED_KEY_3);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CINNAMON_PLACED_KEY_4);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CINNAMON_TREE_PLACED_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.ASH, 0.00125f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome mintMoor(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.MINT_MINK.get(), 50, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.MINTMUNK.get(), 50, 2, 3));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.MINTOW.get(), 40, 1, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.MARSHMALLOW_SHEEP.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.MYNX.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.HUMFLY.get(), 50, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.HUMBULL.get(), 50, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.HUMPUG.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.HUMBUG.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.MINT_IMPERIAL.get(), 50, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.MINT_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.MINT_PLACED_KEY_2);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.MINT_PLACED_KEY_3);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.MINT_PLACED_KEY_4);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.MINT_PLACED_KEY_5);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.MINT_PLACED_KEY_6);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_TREE_PLACED_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(-0.5f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.00125f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome peppermintPlains(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CANDY_CANE_CAT.get(), 50, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CANDY_CANE_TIGER.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CANDY_CANE_ZEBRA.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.CANDY_CANE_FLY.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.PEPPERMINT_TWIRL.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.CANDY_CANE_CROOK.get(), 80, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.PEPPERMINT_CHURL.get(), 80, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_2);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_3);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_4);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_5);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_6);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_7);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_8);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_TREE_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.UNDERGROUND_ORES, SNSPlacedFeatures.PEPPERMINT_SWIRL_STONE_COAL_ORE_PLACED_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(-1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.00125f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome sorbetSands(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.PARFAIT_PIXIE.get(), 50, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.ICE_CREAM_COW.get(), 50, 2, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.WAFER_WITCH.get(), 50, 2, 3));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.WAFFLE_FISH.get(), 30, 1, 4));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.WAFFLE_FISH_MINI.get(), 30, 1, 4));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.WAFER_WHALE.get(), 5, 1, 1));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.ICE_CREAM_FISH.get(), 30, 1, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_2);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_3);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_4);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_5);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_6);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_7);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_8);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(-1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.00125f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome sprinkleShores(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.WAFER_WITCH.get(), 100, 2, 3));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.WAFFLE_FISH.get(), 30, 1, 4));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.WAFFLE_FISH_MINI.get(), 30, 1, 4));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.WAFER_WHALE.get(), 5, 1, 1));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.ICE_CREAM_FISH.get(), 30, 1, 4));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_2);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_3);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_4);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_5);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_6);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_7);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDY_CANE_PLACED_KEY_8);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(4048038).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.00125f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome candyflossClouds(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CANDYFLOSS_LION.get(), 50, 2, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CANDYFLOSS_SHEEP.get(), 50, 1, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.LACE_SNAKE.get(), 50, 1, 1));
        spawnBuilder.addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.PRETZELFLY.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.GUMMY_FISH.get(), 50, 1, 4));
        spawnBuilder.addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.COLA_BOTTLENOSE_DOLPHIN.get(), 5, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.LACE_SPIDER.get(), 80, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.SUGAR_WRAPPED_MUMMY.get(), 80, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_PLACED_KEY_2);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_PLACED_KEY_3);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_PLACED_KEY_4);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_PLACED_KEY_5);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_PLACED_KEY_6);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_PLACED_KEY_7);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_PLACED_KEY_8);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_TREE_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_TREE_PLACED_KEY_2);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_TREE_PLACED_KEY_3);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_TREE_PLACED_KEY_4);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CANDYFLOSS_TREE_PLACED_KEY_5);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(3217153).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.00125f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome chocolateChase(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CHOCOLATE_CHICKEN.get(), 50, 2, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CHOCOLATE_PENGUIN.get(), 30, 1, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CHOCOLATE_REINDEER.get(), 30, 1, 3));
        spawnBuilder.addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.CHOCOLATE_PIGEON.get(), 30, 1, 3));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.CHOCCOON.get(), 30, 1, 3));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.LACE_SPIDER.get(), 80, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.SUGAR_WRAPPED_MUMMY.get(), 80, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CHOCOLATE_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.CHOCOLATE_TREE_PLACED_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(-1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(3217153).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.SNOWFLAKE, 0.00125f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    public static Biome rainbowRidge(HolderGetter<PlacedFeature> placedFeatureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.commonSpawns((MobSpawnSettings.Builder)spawnBuilder, (int)30);
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.SUGARGLIDER.get(), 50, 2, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.GUMMY_BEAR.get(), 50, 2, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.JELLY_BABY.get(), 50, 2, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.BONBONBINI.get(), 50, 2, 2));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.RAINBOW_STRIP_PEGASUS.get(), 10, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.RAINBOW_STRIP_PHOENIX.get(), 10, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.RAINBOW_STRIP_UNICORN.get(), 10, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.LACE_SNAKE.get(), 50, 1, 1));
        spawnBuilder.addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.PRETZELFLY.get(), 50, 1, 2));
        spawnBuilder.addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SNSEntity.GUMMY_FISH.get(), 50, 1, 4));
        spawnBuilder.addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.COLA_BOTTLENOSE_DOLPHIN.get(), 5, 1, 2));
        spawnBuilder.addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(SNSEntity.RAINBOW_STRIP_JELLYFISH.get(), 10, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.LACE_SPIDER.get(), 80, 1, 2));
        spawnBuilder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SNSEntity.SUGAR_WRAPPED_MUMMY.get(), 80, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.addExtraEmeralds((BiomeGenerationSettings.Builder)biomeBuilder);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.RAINBOW_STRIP_PLACED_KEY);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.RAINBOW_STRIP_PLACED_KEY_2);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.RAINBOW_STRIP_PLACED_KEY_3);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.RAINBOW_STRIP_PLACED_KEY_4);
        SNSDimensionBiomes.addFeature(biomeBuilder, GenerationStep.Decoration.VEGETAL_DECORATION, SNSPlacedFeatures.RAINBOW_STRIP_TREE_PLACED_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().waterColor(3217153).waterFogColor(0xFFFFFF).fogColor(0xFFFFFF).skyColor(SNSDimensionBiomes.calculateSkyColor(1.0f)).ambientLoopSound((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP).ambientMoodSound(new AmbientMoodSettings((Holder)SoundEvents.AMBIENT_BASALT_DELTAS_MOOD, 90000, 8, 2.0)).backgroundMusic(Musics.createGameMusic((Holder)SoundEvents.AMBIENT_SOUL_SAND_VALLEY_LOOP)).build()).mobSpawnSettings(spawnBuilder.build()).generationSettings(biomeBuilder.build()).build();
    }

    private static void register(BootstrapContext<Biome> context, ResourceKey<Biome> key, Biome biome) {
        context.register(key, (Object)biome);
    }

    private static void addFeature(BiomeGenerationSettings.Builder builder, GenerationStep.Decoration step, ResourceKey<PlacedFeature> placedFeatureKey) {
        builder.addFeature(step, placedFeatureKey);
    }

    private static int calculateSkyColor(float temperature) {
        float f = Mth.clamp((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    private static ResourceKey<Biome> registerBiomeKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"snsnf", (String)name));
    }
}

