/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.xstarlotte.snsnf.worldgen.tree.SNSFoliagePlacerTypes;

public class CandyCaneFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CandyCaneFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CandyCaneFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CandyCaneFoliagePlacer::new));
    public static final Codec<CandyCaneFoliagePlacer> codec = CODEC.codec();

    public CandyCaneFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)SNSFoliagePlacerTypes.CANDY_CANE_FOLIAGE_PLACER.value();
    }

    private void placeLeafIfPossible(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos pos) {
        BlockState state = ((BlockGetter)level).getBlockState(pos);
        if (state.isAir() || state.is(BlockTags.LEAVES)) {
            BlockState leafState = config.foliageProvider.getState(random, pos);
            setter.set(pos, leafState);
        }
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int offset) {
        BlockPos[] positions;
        int dirIndex = attachment.radiusOffset();
        Direction hookDir = Direction.values()[dirIndex];
        BlockPos base = attachment.pos();
        Direction back = hookDir.getOpposite();
        Direction right = hookDir.getClockWise();
        Direction left = hookDir.getCounterClockWise();
        for (BlockPos posn : positions = new BlockPos[]{base.below(0).relative(back, 1).relative(left, 1), base.below(0).relative(back, 1), base.below(0).relative(back, 1).relative(right, 2), base.below(0).relative(back, 1).relative(right, 3), base.below(1).relative(back, 1).relative(left, 1), base.below(1).relative(back, 1).relative(right, 1), base.below(1).relative(back, 1).relative(right, 3), base.below(2).relative(back, 1).relative(left, 1), base.below(2).relative(back, 1), base.below(2).relative(back, 1).relative(right, 1), base.below(2).relative(back, 1).relative(right, 2), base.below(2).relative(back, 1).relative(right, 3), base.below(3).relative(back, 1), base.below(3).relative(back, 1).relative(right, 1), base.below(3).relative(back, 1).relative(right, 2), base.below(4).relative(back, 1).relative(left, 1), base.below(4).relative(back, 1), base.below(4).relative(back, 1).relative(right, 2), base.below(4).relative(back, 1).relative(right, 3)}) {
            this.placeLeafIfPossible(level, setter, random, config, posn);
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 1;
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

