/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.xstarlotte.snsnf.worldgen.tree.SNSTrunkPlacerTypes;

public class CandyCaneTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CandyCaneTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CandyCaneTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CandyCaneTrunkPlacer::new));
    public static final Codec<CandyCaneTrunkPlacer> codec = CODEC.codec();

    public CandyCaneTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)SNSTrunkPlacerTypes.CANDY_CANE_TRUNK_PLACER.value();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader levelSimulatedReader, BiConsumer<BlockPos, BlockState> replacer, RandomSource rand, int height, BlockPos pos, TreeConfiguration config) {
        Direction[] horizontal = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        Direction hookDir = horizontal[rand.nextInt(horizontal.length)];
        ArrayList<FoliagePlacer.FoliageAttachment> attachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (int y = 0; y < height - 2; ++y) {
            BlockPos p = pos.above(y);
            replacer.accept(p, config.trunkProvider.getState(rand, p));
        }
        BlockPos trunkTip = pos.above(height - 2);
        replacer.accept(trunkTip, config.trunkProvider.getState(rand, trunkTip));
        BlockPos hookHoriz1 = trunkTip.relative(hookDir, 1);
        replacer.accept(hookHoriz1, config.trunkProvider.getState(rand, hookHoriz1));
        BlockPos hookHoriz2 = trunkTip.relative(hookDir, 2);
        replacer.accept(hookHoriz2, config.trunkProvider.getState(rand, hookHoriz2));
        BlockPos hookTip = hookHoriz2.below();
        replacer.accept(hookTip, config.trunkProvider.getState(rand, hookTip));
        attachments.add(new FoliagePlacer.FoliageAttachment(trunkTip.relative(hookDir.getCounterClockWise(), 1), hookDir.ordinal(), false));
        return attachments;
    }
}

