/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.xstarlotte.snsnf.worldgen.tree.SNSFoliagePlacerTypes;

public class CandyflossFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CandyflossFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CandyflossFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CandyflossFoliagePlacer::new));
    public static final Codec<CandyflossFoliagePlacer> codec = CODEC.codec();

    public CandyflossFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)SNSFoliagePlacerTypes.CANDYFLOSS_FOLIAGE_PLACER.value();
    }

    private void placeLeafIfPossible(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos pos) {
        BlockState state = ((BlockGetter)level).getBlockState(pos);
        if (state.isAir() || state.is(BlockTags.LEAVES)) {
            BlockState leafState = config.foliageProvider.getState(random, pos);
            setter.set(pos, leafState);
        }
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int offset) {
        BlockPos top = attachment.pos();
        Consumer<BlockPos> place = p -> this.placeLeafIfPossible(level, setter, random, config, (BlockPos)p);
        BiConsumer<BlockPos, int[]> ring = (center, params) -> {
            int r2 = params[0];
            boolean includeCorners = params[1] != 0;
            boolean includeSides = params[2] != 0;
            for (int dx = -r2; dx <= r2; ++dx) {
                for (int dz = -r2; dz <= r2; ++dz) {
                    boolean isCorner;
                    if (Math.max(Math.abs(dx), Math.abs(dz)) != r2) continue;
                    boolean bl = isCorner = Math.abs(dx) == r2 && Math.abs(dz) == r2;
                    if (isCorner && !includeCorners || !isCorner && !includeSides) continue;
                    place.accept(center.offset(dx, 0, dz));
                }
            }
        };
        BiConsumer<BlockPos, Integer> fill = (center, r2) -> {
            for (int dx = -r2.intValue(); dx <= r2; ++dx) {
                for (int dz = -r2.intValue(); dz <= r2; ++dz) {
                    place.accept(center.offset(dx, 0, dz));
                }
            }
        };
        BiConsumer<BlockPos, Integer> fillWithoutCorners = (center, r2) -> {
            for (int dx = -r2.intValue(); dx <= r2; ++dx) {
                for (int dz = -r2.intValue(); dz <= r2; ++dz) {
                    if (Math.abs(dx) == r2 && Math.abs(dz) == r2) continue;
                    place.accept(center.offset(dx, 0, dz));
                }
            }
        };
        place.accept(top.above());
        ring.accept(top, new int[]{1, 0, 1});
        ring.accept(top.below(1), new int[]{1, 1, 1});
        fillWithoutCorners.accept(top.below(2), 2);
        BlockPos l5 = top.below(3);
        int r = 3;
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                if (Math.max(Math.abs(dx), Math.abs(dz)) > r) continue;
                int ax = Math.abs(dx);
                int az = Math.abs(dz);
                if (ax == r && az == r || ax == r && az >= r - 1 || az == r && ax >= r - 1) continue;
                place.accept(l5.offset(dx, 0, dz));
            }
        }
        fillWithoutCorners.accept(top.below(4), 2);
        ring.accept(top.below(5), new int[]{1, 1, 1});
        ring.accept(top.below(6), new int[]{1, 0, 1});
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 3;
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

