/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.xstarlotte.snsnf.worldgen.tree.SNSFoliagePlacerTypes;

public class CinnamonFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CinnamonFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CinnamonFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CinnamonFoliagePlacer::new));
    public static final Codec<CinnamonFoliagePlacer> codec = CODEC.codec();

    public CinnamonFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)SNSFoliagePlacerTypes.CINNAMON_FOLIAGE_PLACER.value();
    }

    private void placeLeafIfPossible(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, BlockPos pos) {
        BlockState state = ((BlockGetter)level).getBlockState(pos);
        if (state.isAir() || state.is(BlockTags.LEAVES)) {
            BlockState leafState = config.foliageProvider.getState(random, pos);
            setter.set(pos, leafState);
        }
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int offset) {
        int dz;
        int dx;
        int dz2;
        int dx2;
        BlockPos centerTop = attachment.pos().below(2);
        for (int dx3 = -1; dx3 <= 1; ++dx3) {
            for (int dz3 = -1; dz3 <= 1; ++dz3) {
                if (dx3 == 0 && dz3 == 0) continue;
                this.placeLeafIfPossible(level, setter, random, config, centerTop.offset(dx3, 0, dz3));
            }
        }
        BlockPos centerL2 = centerTop.below();
        for (dx2 = -1; dx2 <= 1; ++dx2) {
            for (dz2 = -1; dz2 <= 1; ++dz2) {
                if (dx2 == 0 && dz2 == 0) continue;
                this.placeLeafIfPossible(level, setter, random, config, centerL2.offset(dx2, 0, dz2));
            }
        }
        for (dx2 = -2; dx2 <= 2; ++dx2) {
            for (dz2 = -2; dz2 <= 2; ++dz2) {
                if (Math.max(Math.abs(dx2), Math.abs(dz2)) != 2) continue;
                this.placeLeafIfPossible(level, setter, random, config, centerL2.offset(dx2, 0, dz2));
            }
        }
        BlockPos centerL3 = centerL2.below();
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                if (Math.max(Math.abs(dx), Math.abs(dz)) != 2 || Math.abs(dx) == 2 && Math.abs(dz) == 2) continue;
                this.placeLeafIfPossible(level, setter, random, config, centerL3.offset(dx, 0, dz));
            }
        }
        for (dx = -3; dx <= 3; ++dx) {
            for (dz = -3; dz <= 3; ++dz) {
                if (Math.max(Math.abs(dx), Math.abs(dz)) != 3 || Math.abs(dx) == 3 && Math.abs(dz) == 3) continue;
                this.placeLeafIfPossible(level, setter, random, config, centerL3.offset(dx, 0, dz));
            }
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 3;
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

