/*
 * Decompiled with CFR 0.152.
 */
package net.xstarlotte.snsnf.worldgen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.xstarlotte.snsnf.worldgen.tree.SNSTrunkPlacerTypes;

public class CinnamonTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CinnamonTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CinnamonTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CinnamonTrunkPlacer::new));
    public static final Codec<CinnamonTrunkPlacer> codec = CODEC.codec();

    public CinnamonTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)SNSTrunkPlacerTypes.CINNAMON_TRUNK_PLACER.value();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, RandomSource rand, int height, BlockPos pos, TreeConfiguration config) {
        for (int y = 0; y < height; ++y) {
            BlockPos p = pos.above(y);
            replacer.accept(p, config.trunkProvider.getState(rand, p));
        }
        ArrayList<FoliagePlacer.FoliageAttachment> attachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        attachments.add(new FoliagePlacer.FoliageAttachment(pos.above(height), 0, false));
        return attachments;
    }
}

