/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.paths.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final ResourceLocation SUN_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/sun.png");
    public static final ResourceLocation MOON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/moon_phases.png");
    private static final Minecraft mc = Minecraft.getInstance();

    public static void swapVanillaTexture(ResourceLocation original, ResourceLocation replacement) {
        TextureManager textureManager = mc.getTextureManager();
        SimpleTexture newTexture = new SimpleTexture(replacement);
        newTexture.bind();
        textureManager.register(original, (AbstractTexture)newTexture);
    }

    public static void renderCustomSun(RenderLevelStageEvent event, ResourceLocation texture) {
        PoseStack posestack = event.getPoseStack();
        posestack.pushPose();
        posestack.mulPose(event.getModelViewMatrix());
        GlStateManager._enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager._depthMask((boolean)false);
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        float f11 = 1.0f - RenderUtils.mc.getInstance().player.level().getRainLevel(partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        posestack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        posestack.mulPose(Axis.XP.rotationDegrees(RenderUtils.mc.getInstance().player.level().getTimeOfDay(partialTick) * 360.0f));
        Matrix4f matrix4f1 = posestack.last().pose();
        float f12 = 30.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f1, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f1, f12, 100.0f, f12).setUv(1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager._disableBlend();
        RenderSystem.defaultBlendFunc();
        GlStateManager._depthMask((boolean)true);
        posestack.popPose();
    }

    public static void renderCustomMoon(RenderLevelStageEvent event, ResourceLocation texture) {
        PoseStack posestack = event.getPoseStack();
        posestack.pushPose();
        posestack.mulPose(event.getModelViewMatrix());
        GlStateManager._enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager._depthMask((boolean)false);
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        float f11 = 1.0f - RenderUtils.mc.getInstance().player.level().getRainLevel(partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        posestack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        posestack.mulPose(Axis.XP.rotationDegrees(RenderUtils.mc.getInstance().player.level().getTimeOfDay(partialTick) * 360.0f));
        Matrix4f matrix4f1 = posestack.last().pose();
        float f12 = 20.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int k = RenderUtils.mc.getInstance().player.level().getMoonPhase();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f1, -f12, -100.0f, f12).setUv(f15, f16);
        bufferbuilder.addVertex(matrix4f1, f12, -100.0f, f12).setUv(f13, f16);
        bufferbuilder.addVertex(matrix4f1, f12, -100.0f, -f12).setUv(f13, f14);
        bufferbuilder.addVertex(matrix4f1, -f12, -100.0f, -f12).setUv(f15, f14);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager._disableBlend();
        RenderSystem.defaultBlendFunc();
        GlStateManager._depthMask((boolean)true);
        posestack.popPose();
    }

    public static void renderCustomSkybox(RenderLevelStageEvent event, ResourceLocation texture, int color, float alpha) {
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        poseStack.mulPose(event.getModelViewMatrix());
        GlStateManager._enableBlend();
        RenderSystem.defaultBlendFunc();
        GlStateManager._depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        int[] rgb = RenderUtils.getRGB(color);
        RenderSystem.setShaderColor((float)((float)rgb[0] / 255.0f), (float)((float)rgb[1] / 255.0f), (float)((float)rgb[2] / 255.0f), (float)alpha);
        Tesselator tesselator = Tesselator.getInstance();
        float distance = 100.0f;
        float size = 100.0f;
        RenderUtils.renderSkyboxQuad(poseStack, tesselator, -size, distance, -size, 0.25f, 0.33333334f, size, distance, -size, 0.5f, 0.33333334f, size, distance, size, 0.5f, 0.0f, -size, distance, size, 0.25f, 0.0f);
        RenderUtils.renderSkyboxQuad(poseStack, tesselator, -size, -distance, -size, 0.25f, 0.6666667f, -size, -distance, size, 0.25f, 1.0f, size, -distance, size, 0.5f, 1.0f, size, -distance, -size, 0.5f, 0.6666667f);
        RenderUtils.renderSkyboxQuad(poseStack, tesselator, -distance, -size, size, 0.0f, 0.6666667f, -distance, -size, -size, 0.25f, 0.6666667f, -distance, size, -size, 0.25f, 0.33333334f, -distance, size, size, 0.0f, 0.33333334f);
        RenderUtils.renderSkyboxQuad(poseStack, tesselator, -size, -size, -distance, 0.25f, 0.6666667f, size, -size, -distance, 0.5f, 0.6666667f, size, size, -distance, 0.5f, 0.33333334f, -size, size, -distance, 0.25f, 0.33333334f);
        RenderUtils.renderSkyboxQuad(poseStack, tesselator, distance, -size, -size, 0.5f, 0.6666667f, distance, -size, size, 0.75f, 0.6666667f, distance, size, size, 0.75f, 0.33333334f, distance, size, -size, 0.5f, 0.33333334f);
        RenderUtils.renderSkyboxQuad(poseStack, tesselator, size, -size, distance, 0.75f, 0.6666667f, -size, -size, distance, 1.0f, 0.6666667f, -size, size, distance, 1.0f, 0.33333334f, size, size, distance, 0.75f, 0.33333334f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager._depthMask((boolean)true);
        GlStateManager._disableBlend();
        poseStack.popPose();
    }

    private static void renderSkyboxQuad(PoseStack poseStack, Tesselator tesselator, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, float x4, float y4, float z4, float u4, float v4) {
        Matrix4f matrix = poseStack.last().pose();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(matrix, x1, y1, z1).setUv(u1, v1);
        buffer.addVertex(matrix, x2, y2, z2).setUv(u2, v2);
        buffer.addVertex(matrix, x3, y3, z3).setUv(u3, v3);
        buffer.addVertex(matrix, x4, y4, z4).setUv(u4, v4);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static int[] getRGB(int hexColor) {
        int[] rgb = new int[]{hexColor >> 16 & 0xFF, hexColor >> 8 & 0xFF, hexColor & 0xFF};
        return rgb;
    }
}

