/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.paths.configuration;

import net.neoforged.neoforge.common.ModConfigSpec;

public class PathsConfigConfiguration {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Boolean> PATH_ON;
    public static final ModConfigSpec.ConfigValue<Double> PATH_STEPS;
    public static final ModConfigSpec.ConfigValue<Boolean> PATHS_PERM;
    public static final ModConfigSpec.ConfigValue<Boolean> PATH_RECOVERY;
    public static final ModConfigSpec.ConfigValue<Double> PATH_RECOVER_TIME;
    public static final ModConfigSpec.ConfigValue<Boolean> PATH_BONEMEAL;
    public static final ModConfigSpec.ConfigValue<Boolean> GRASS;
    public static final ModConfigSpec.ConfigValue<Boolean> DIRT;
    public static final ModConfigSpec.ConfigValue<Boolean> MUD;
    public static final ModConfigSpec.ConfigValue<Boolean> PODZOL;
    public static final ModConfigSpec.ConfigValue<Boolean> MOSS;
    public static final ModConfigSpec.ConfigValue<Boolean> MYCELIUM;
    public static final ModConfigSpec.ConfigValue<Boolean> SAND;
    public static final ModConfigSpec.ConfigValue<Double> SAND_STEPS;
    public static final ModConfigSpec.ConfigValue<Boolean> SAND_RECOVERY;
    public static final ModConfigSpec.ConfigValue<Double> SAND_RECOVER_TIME;
    public static final ModConfigSpec.ConfigValue<Boolean> SNOW;
    public static final ModConfigSpec.ConfigValue<Boolean> SNOW_RECOVERY;
    public static final ModConfigSpec.ConfigValue<Double> SNOW_RECOVER_TIME;
    public static final ModConfigSpec.ConfigValue<Boolean> SNOW_COVER;
    public static final ModConfigSpec.ConfigValue<Boolean> SNOW_PARTICLES;
    public static final ModConfigSpec.ConfigValue<Boolean> STONE;
    public static final ModConfigSpec.ConfigValue<Boolean> GRASS_CLEAR;
    public static final ModConfigSpec.ConfigValue<Boolean> SNEAK_PATH;
    public static final ModConfigSpec.ConfigValue<Boolean> FEATHER_PATH;
    public static final ModConfigSpec.ConfigValue<Boolean> RIDE_PATH;
    public static final ModConfigSpec.ConfigValue<Boolean> VILLAGER_PATH;

    static {
        BUILDER.push("grassanddirtoptions");
        PATH_ON = BUILDER.comment("Grass/dirt paths on").define("paths_on", true);
        PATH_STEPS = BUILDER.comment("Number of collisions to activate grass/dirt paths").define("path_steps", (Object)3.0);
        PATHS_PERM = BUILDER.comment("Well worn paths become permanent").define("perm_paths", true);
        PATH_RECOVERY = BUILDER.comment("Lightly formed paths can recover over time").define("path_recovery", true);
        PATH_RECOVER_TIME = BUILDER.comment("Percentage chance of recovery on random tick").define("path_recover_time", (Object)10.0);
        PATH_BONEMEAL = BUILDER.comment("Grass paths can be recovered with bonemeal").define("grass_bonemeal", true);
        BUILDER.push("blocks");
        GRASS = BUILDER.comment("Grass paths active").define("grass_paths", true);
        DIRT = BUILDER.comment("Dirt paths active").define("dirt_paths", true);
        MUD = BUILDER.comment("Mud paths active").define("mud_paths", true);
        PODZOL = BUILDER.comment("Podzol paths active").define("podzol_paths", true);
        MOSS = BUILDER.comment("Moss paths active").define("moss_paths", true);
        MYCELIUM = BUILDER.comment("Mycelium paths active").define("mycelium_paths", true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("sandoptions");
        SAND = BUILDER.comment("Sand paths active").define("sand_paths", true);
        SAND_STEPS = BUILDER.comment("Number of collisions to activate sand paths").define("sand_steps", (Object)1.0);
        SAND_RECOVERY = BUILDER.comment("Sand paths can recover over time").define("sand_recovery", true);
        SAND_RECOVER_TIME = BUILDER.comment("Percentage chance of recovery on random tick").define("sand_recover_time", (Object)10.0);
        BUILDER.pop();
        BUILDER.push("snowoptions");
        SNOW = BUILDER.comment("Snow paths active").define("snow_paths", true);
        SNOW_RECOVERY = BUILDER.comment("Snow paths can recover over time").define("snow_recovery", false);
        SNOW_RECOVER_TIME = BUILDER.comment("Percentage chance of recovery on random tick").define("snow_recover_time", (Object)10.0);
        SNOW_COVER = BUILDER.comment("Snow paths recover if it's snowing").define("snow_cover", true);
        SNOW_PARTICLES = BUILDER.comment("Snow step particles active").define("snow_particles", true);
        BUILDER.pop();
        BUILDER.push("stoneoptions");
        STONE = BUILDER.comment("Right click on stone/cobblestone with pickaxe to create").define("stone_paths", true);
        BUILDER.pop();
        BUILDER.push("globaloptions");
        GRASS_CLEAR = BUILDER.comment("Walking through tall grass breaks it").define("grass_clear", false);
        SNEAK_PATH = BUILDER.comment("Allow paths to be created when sneaking").define("sneak_path", false);
        FEATHER_PATH = BUILDER.comment("Allow paths to be created with feather falling enchantment").define("feather_path", false);
        RIDE_PATH = BUILDER.comment("Player ridden entities can make paths").define("ride_path", true);
        VILLAGER_PATH = BUILDER.comment("Allow villagers to make paths").define("villager_path", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

