/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.paths.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class PathsConfigConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> PATH_ON;
    public static final ForgeConfigSpec.ConfigValue<Double> PATH_STEPS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> PATHS_PERM;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GRASS_CLEAR;
    public static final ForgeConfigSpec.ConfigValue<Boolean> PATH_RECOVERY;
    public static final ForgeConfigSpec.ConfigValue<Double> PATH_RECOVER_TIME;
    public static final ForgeConfigSpec.ConfigValue<Boolean> PATH_BONEMEAL;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GRASS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DIRT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> MUD;
    public static final ForgeConfigSpec.ConfigValue<Boolean> PODZOL;
    public static final ForgeConfigSpec.ConfigValue<Boolean> MOSS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> MYCELIUM;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SAND;
    public static final ForgeConfigSpec.ConfigValue<Double> SAND_STEPS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SAND_RECOVERY;
    public static final ForgeConfigSpec.ConfigValue<Double> SAND_RECOVER_TIME;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SNOW;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SNOW_RECOVERY;
    public static final ForgeConfigSpec.ConfigValue<Double> SNOW_RECOVER_TIME;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SNOW_COVER;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SNOW_PARTICLES;
    public static final ForgeConfigSpec.ConfigValue<Boolean> STONE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SNEAK_PATH;
    public static final ForgeConfigSpec.ConfigValue<Boolean> FEATHER_PATH;
    public static final ForgeConfigSpec.ConfigValue<Boolean> RIDE_PATH;
    public static final ForgeConfigSpec.ConfigValue<Boolean> VILLAGER_PATH;

    static {
        BUILDER.push("grass and dirt options");
        PATH_ON = BUILDER.comment("Grass/dirt paths on").define("pathsOn", true);
        PATH_STEPS = BUILDER.comment("Number of collisions to activate grass/dirt paths").define("pathSteps", (Object)3.0);
        PATHS_PERM = BUILDER.comment("Well worn paths become permanent").define("permPaths", true);
        GRASS_CLEAR = BUILDER.comment("Walking through tall grass breaks it").define("grassClear", false);
        PATH_RECOVERY = BUILDER.comment("Lightly formed paths can recover over time").define("pathRecovery", true);
        PATH_RECOVER_TIME = BUILDER.comment("Percentage chance of recovery on random tick").define("pathRecoverTime", (Object)10.0);
        PATH_BONEMEAL = BUILDER.comment("Grass paths can be recovered with bonemeal").define("grassBonemeal", true);
        BUILDER.push("blocks");
        GRASS = BUILDER.comment("Grass paths active").define("grassPaths", true);
        DIRT = BUILDER.comment("Dirt paths active").define("dirtPaths", true);
        MUD = BUILDER.comment("Mud paths active").define("mudPaths", true);
        PODZOL = BUILDER.comment("Podzol paths active").define("podzolPaths", true);
        MOSS = BUILDER.comment("Moss paths active").define("mossPaths", true);
        MYCELIUM = BUILDER.comment("Mycelium paths active").define("myceliumPaths", true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("sand options");
        SAND = BUILDER.comment("Sand paths active").define("sandPaths", true);
        SAND_STEPS = BUILDER.comment("Number of collisions to activate sand paths").define("sandSteps", (Object)1.0);
        SAND_RECOVERY = BUILDER.comment("Sand paths can recover over time").define("sandRecovery", true);
        SAND_RECOVER_TIME = BUILDER.comment("Percentage chance of recovery on random tick").define("sandRecoverTime", (Object)10.0);
        BUILDER.pop();
        BUILDER.push("snow options");
        SNOW = BUILDER.comment("Snow paths active").define("snowPaths", true);
        SNOW_RECOVERY = BUILDER.comment("Snow paths can recover over time").define("snowRecovery", false);
        SNOW_RECOVER_TIME = BUILDER.comment("Percentage chance of recovery on random tick").define("snowRecoverTime", (Object)10.0);
        SNOW_COVER = BUILDER.comment("Snow paths recover if it's snowing").define("snowCover", true);
        SNOW_PARTICLES = BUILDER.comment("Snow step particles active").define("snowParticles", true);
        BUILDER.pop();
        BUILDER.push("stone options");
        STONE = BUILDER.comment("Right click on stone/cobblestone with pickaxe to create").define("stonePaths", true);
        BUILDER.pop();
        BUILDER.push("global options");
        SNEAK_PATH = BUILDER.comment("Allow paths to be created when sneaking").define("sneakPath", false);
        FEATHER_PATH = BUILDER.comment("Allow paths to be created with feather falling enchantment").define("featherPath", false);
        RIDE_PATH = BUILDER.comment("Player ridden entities can make paths").define("ridePath", true);
        VILLAGER_PATH = BUILDER.comment("Allow villagers to make paths").define("villagerPath", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

