/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.ChargingStationBlock;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.menu.ChargingStationMenu;
import com.atsuishio.superbwarfare.network.dataslot.ContainerEnergyData;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargingStationBlockEntity
extends BlockEntity
implements WorldlyContainer,
MenuProvider {
    protected static final int SLOT_FUEL = 0;
    protected static final int SLOT_CHARGE = 1;
    public static final int MAX_DATA_COUNT = 4;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    public static final int MAX_ENERGY = (Integer)MiscConfig.CHARGING_STATION_MAX_ENERGY.get();
    public static final int DEFAULT_FUEL_TIME = (Integer)MiscConfig.CHARGING_STATION_DEFAULT_FUEL_TIME.get();
    public static final int CHARGE_SPEED = (Integer)MiscConfig.CHARGING_STATION_GENERATE_SPEED.get();
    public static final int CHARGE_OTHER_SPEED = (Integer)MiscConfig.CHARGING_STATION_TRANSFER_SPEED.get();
    public static final int CHARGE_RADIUS = (Integer)MiscConfig.CHARGING_STATION_CHARGE_RADIUS.get();
    public int fuelTick = 0;
    public int maxFuelTick = DEFAULT_FUEL_TIME;
    public boolean showRange = false;
    protected final ContainerEnergyData dataAccess = new ContainerEnergyData(){

        @Override
        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> ChargingStationBlockEntity.this.fuelTick;
                case 1 -> ChargingStationBlockEntity.this.maxFuelTick;
                case 2 -> {
                    Level level = ChargingStationBlockEntity.this.level;
                    if (level == null) {
                        yield 0;
                    }
                    IEnergyStorage cap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, ChargingStationBlockEntity.this.getBlockPos(), null);
                    if (cap == null) {
                        yield 0;
                    }
                    yield cap.getEnergyStored();
                }
                case 3 -> {
                    if (ChargingStationBlockEntity.this.showRange) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        @Override
        public void set(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    ChargingStationBlockEntity.this.fuelTick = pValue;
                    break;
                }
                case 1: {
                    ChargingStationBlockEntity.this.maxFuelTick = pValue;
                    break;
                }
                case 2: {
                    Level level = ChargingStationBlockEntity.this.level;
                    if (level == null) {
                        return;
                    }
                    IEnergyStorage cap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, ChargingStationBlockEntity.this.getBlockPos(), null);
                    if (cap == null) {
                        return;
                    }
                    cap.receiveEnergy(pValue, false);
                    break;
                }
                case 3: {
                    ChargingStationBlockEntity.this.showRange = pValue == 1;
                }
            }
        }

        @Override
        public int getCount() {
            return 4;
        }
    };
    private final IEnergyStorage energyStorage = new EnergyStorage(MAX_ENERGY);

    public ChargingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CHARGING_STATION.get(), pos, state);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, ChargingStationBlockEntity blockEntity) {
        IEnergyStorage handler;
        if (blockEntity.showRange != (Boolean)pState.getValue((Property)ChargingStationBlock.SHOW_RANGE)) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)ChargingStationBlock.SHOW_RANGE, (Comparable)Boolean.valueOf(blockEntity.showRange)));
            ChargingStationBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
        if ((handler = blockEntity.getEnergyStorage(null)) == null) {
            return;
        }
        int energy = handler.getEnergyStored();
        if (energy > 0) {
            blockEntity.chargeEntity(handler);
        }
        if (handler.getEnergyStored() > 0) {
            blockEntity.chargeItemStack(handler);
        }
        if (handler.getEnergyStored() > 0) {
            blockEntity.chargeBlock(handler);
        }
        if (blockEntity.fuelTick > 0) {
            --blockEntity.fuelTick;
            if (energy < handler.getMaxEnergyStored()) {
                handler.receiveEnergy(CHARGE_SPEED, false);
            }
        } else if (!blockEntity.getItem(0).isEmpty()) {
            if (handler.getEnergyStored() >= handler.getMaxEnergyStored()) {
                return;
            }
            ItemStack fuel = blockEntity.getItem(0);
            int burnTime = fuel.getBurnTime(RecipeType.SMELTING);
            IEnergyStorage fuelEnergy = (IEnergyStorage)fuel.getCapability(Capabilities.EnergyStorage.ITEM);
            if (fuelEnergy != null) {
                int energyToExtract = Math.min(CHARGE_OTHER_SPEED, handler.getMaxEnergyStored() - handler.getEnergyStored());
                if (fuelEnergy.canExtract() && handler.canReceive()) {
                    handler.receiveEnergy(fuelEnergy.extractEnergy(energyToExtract, false), false);
                }
                blockEntity.setChanged();
            } else if (burnTime > 0) {
                blockEntity.fuelTick = burnTime;
                blockEntity.maxFuelTick = burnTime;
                if (fuel.hasCraftingRemainingItem()) {
                    if (fuel.getCount() <= 1) {
                        blockEntity.setItem(0, fuel.getCraftingRemainingItem());
                    } else {
                        ItemStack copy = fuel.getCraftingRemainingItem().copy();
                        copy.setCount(1);
                        ItemEntity itemEntity = new ItemEntity(pLevel, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.2, (double)pPos.getZ() + 0.5, copy);
                        pLevel.addFreshEntity((Entity)itemEntity);
                        fuel.shrink(1);
                    }
                } else {
                    fuel.shrink(1);
                }
                blockEntity.setChanged();
            } else if (fuel.get(DataComponents.FOOD) != null) {
                FoodProperties foodComponent = (FoodProperties)fuel.get(DataComponents.FOOD);
                if (foodComponent == null) {
                    return;
                }
                int nutrition = foodComponent.nutrition();
                float saturation = foodComponent.saturation() * 2.0f * (float)nutrition;
                int tick = nutrition * 80 + (int)(saturation * 200.0f);
                if (fuel.hasCraftingRemainingItem()) {
                    tick += 400;
                }
                fuel.shrink(1);
                blockEntity.fuelTick = tick;
                blockEntity.maxFuelTick = tick;
                blockEntity.setChanged();
            }
        }
    }

    private void chargeEntity(IEnergyStorage handler) {
        if (this.level == null) {
            return;
        }
        if (this.level.getGameTime() % 20L != 0L) {
            return;
        }
        List entities = this.level.getEntitiesOfClass(Entity.class, new AABB(this.getBlockPos()).inflate((double)CHARGE_RADIUS));
        entities.forEach(entity -> {
            IEnergyStorage cap = (IEnergyStorage)entity.getCapability(Capabilities.EnergyStorage.ENTITY, null);
            if (cap == null || !cap.canReceive()) {
                return;
            }
            int charged = cap.receiveEnergy(Math.min(handler.getEnergyStored(), CHARGE_OTHER_SPEED * 20), false);
            handler.extractEnergy(charged, false);
        });
        this.setChanged();
    }

    private void chargeItemStack(IEnergyStorage handler) {
        ItemStack stack = this.getItem(1);
        if (stack.isEmpty()) {
            return;
        }
        IEnergyStorage consumer = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (consumer != null && consumer.getEnergyStored() < consumer.getMaxEnergyStored()) {
            int charged = consumer.receiveEnergy(Math.min(CHARGE_OTHER_SPEED, handler.getEnergyStored()), false);
            handler.extractEnergy(Math.min(charged, handler.getEnergyStored()), false);
        }
        this.setChanged();
    }

    private void chargeBlock(IEnergyStorage handler) {
        if (this.level == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            IEnergyStorage energy;
            BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(direction));
            if (blockEntity == null || (energy = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, blockEntity.getBlockPos(), (Object)direction)) == null || blockEntity instanceof ChargingStationBlockEntity || !energy.canReceive() || energy.getEnergyStored() >= energy.getMaxEnergyStored()) continue;
            int receiveEnergy = energy.receiveEnergy(Math.min(handler.getEnergyStored(), CHARGE_OTHER_SPEED), false);
            handler.extractEnergy(receiveEnergy, false);
            blockEntity.setChanged();
            this.setChanged();
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        if (this.level != null) {
            ((EnergyStorage)this.energyStorage).deserializeNBT((HolderLookup.Provider)this.level.registryAccess(), (Tag)IntTag.valueOf((int)((Integer)componentInput.getOrDefault(ModDataComponents.ENERGY, (Object)0))));
        }
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(ModDataComponents.ENERGY, (Object)this.energyStorage.getEnergyStored());
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        Tag energy;
        super.loadAdditional(tag, registries);
        if (tag.contains("Energy") && (energy = tag.get("Energy")) instanceof IntTag) {
            ((EnergyStorage)this.energyStorage).deserializeNBT(registries, energy);
        }
        this.fuelTick = tag.getInt("FuelTick");
        this.maxFuelTick = tag.getInt("MaxFuelTick");
        this.showRange = tag.getBoolean("ShowRange");
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("Energy", this.energyStorage.getEnergyStored());
        tag.putInt("FuelTick", this.fuelTick);
        tag.putInt("MaxFuelTick", this.maxFuelTick);
        tag.putBoolean("ShowRange", this.showRange);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction pSide) {
        return new int[]{0};
    }

    public boolean canPlaceItemThroughFace(int pIndex, @NotNull ItemStack pItemStack, @Nullable Direction pDirection) {
        return pIndex == 0;
    }

    public boolean canTakeItemThroughFace(int pIndex, @NotNull ItemStack pStack, @NotNull Direction pDirection) {
        return false;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    @NotNull
    public ItemStack removeItem(int pSlot, int pAmount) {
        return ContainerHelper.removeItem(this.items, (int)pSlot, (int)pAmount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int pSlot) {
        return ContainerHelper.takeItem(this.items, (int)pSlot);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean flag = !pStack.isEmpty() && ItemStack.isSameItem((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
        if (pSlot == 0 && !flag) {
            this.setChanged();
        }
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)pPlayer);
    }

    public void clearContent() {
        this.items.clear();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.superbwarfare.charging_station");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return new ChargingStationMenu(pContainerId, pPlayerInventory, (Container)this, this.dataAccess);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)compoundtag, this.items, (HolderLookup.Provider)registries);
        compoundtag.putBoolean("ShowRange", this.showRange);
        return compoundtag;
    }

    @ParametersAreNonnullByDefault
    public void saveToItem(ItemStack stack, HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        if (this.level != null) {
            tag.put("Energy", ((EnergyStorage)this.energyStorage).serializeNBT(registries));
        }
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)this.getType(), (CompoundTag)tag);
    }

    @Nullable
    public IEnergyStorage getEnergyStorage(@Nullable Direction side) {
        return this.energyStorage;
    }
}

