/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.capability.player;

import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.network.message.receive.PlayerVariablesSyncMessage;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="superbwarfare")
public class PlayerVariable
implements INBTSerializable<CompoundTag> {
    private PlayerVariable old = null;
    public Map<Ammo, Integer> ammo = new EnumMap<Ammo, Integer>(Ammo.class);
    public boolean tacticalSprint = false;

    public void sync(Entity entity) {
        if (!entity.hasData(ModAttachments.PLAYER_VARIABLE)) {
            return;
        }
        PlayerVariable newVariable = (PlayerVariable)entity.getData(ModAttachments.PLAYER_VARIABLE);
        if (this.old != null && this.old.equals(newVariable)) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(entity.getId(), this.compareAndUpdate()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static PlayerVariable getOrDefault(Entity entity) {
        return (PlayerVariable)entity.getData(ModAttachments.PLAYER_VARIABLE);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage(player2.getId(), PlayerVariable.getOrDefault((Entity)player2).compareAndUpdate()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage(player2.getId(), PlayerVariable.getOrDefault((Entity)player2).compareAndUpdate()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage(player2.getId(), PlayerVariable.getOrDefault((Entity)player2).forceUpdate()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public PlayerVariable watch() {
        this.old = this.copy();
        return this;
    }

    public Map<Byte, Integer> forceUpdate() {
        HashMap<Byte, Integer> map = new HashMap<Byte, Integer>();
        for (Ammo type : Ammo.values()) {
            map.put((byte)type.ordinal(), type.get(this));
        }
        map.put((byte)-1, this.tacticalSprint ? 1 : 0);
        return map;
    }

    public Map<Byte, Integer> compareAndUpdate() {
        HashMap<Byte, Integer> map = new HashMap<Byte, Integer>();
        PlayerVariable old = this.old == null ? new PlayerVariable() : this.old;
        for (Ammo type : Ammo.values()) {
            Integer oldCount = old.ammo.getOrDefault((Object)type, 0);
            int newCount = type.get(this);
            if (oldCount == newCount) continue;
            map.put((byte)type.ordinal(), newCount);
        }
        if (old.tacticalSprint != this.tacticalSprint) {
            map.put((byte)-1, this.tacticalSprint ? 1 : 0);
        }
        return map;
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Ammo type : Ammo.values()) {
            type.set(nbt, type.get(this));
        }
        nbt.putBoolean("TacticalSprint", this.tacticalSprint);
        return nbt;
    }

    public void readFromNBT(CompoundTag tag) {
        for (Ammo type : Ammo.values()) {
            type.set(this, type.get(tag));
        }
        this.tacticalSprint = tag.getBoolean("TacticalSprint");
    }

    public PlayerVariable copy() {
        PlayerVariable clone = new PlayerVariable();
        for (Ammo type : Ammo.values()) {
            type.set(clone, type.get(this));
        }
        clone.tacticalSprint = this.tacticalSprint;
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerVariable)) {
            return false;
        }
        PlayerVariable other = (PlayerVariable)obj;
        for (Ammo type : Ammo.values()) {
            if (type.get(this) == type.get(other)) continue;
            return false;
        }
        return this.tacticalSprint == other.tacticalSprint;
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        event.getOriginal().revive();
        PlayerVariable original = (PlayerVariable)event.getOriginal().getData(ModAttachments.PLAYER_VARIABLE);
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        event.getEntity().setData(ModAttachments.PLAYER_VARIABLE, (Object)original.copy());
    }

    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.writeToNBT();
    }

    @ParametersAreNonnullByDefault
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.readFromNBT(nbt);
    }
}

