/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.decorator;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.IItemDecorator;

@OnlyIn(value=Dist.CLIENT)
public class ContainerItemDecorator
implements IItemDecorator {
    private static final Map<String, ResourceLocation> icons = new HashMap<String, ResourceLocation>();

    @ParametersAreNonnullByDefault
    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        if (!(stack.getItem() instanceof ContainerBlockItem)) {
            return false;
        }
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data == null) {
            return false;
        }
        CompoundTag tag = data.copyTag();
        ResourceLocation icon = null;
        if (tag.contains("EntityType")) {
            String typeString = tag.getString("EntityType");
            if (icons.containsKey(typeString)) {
                icon = icons.get(typeString);
            } else {
                EntityType entityType = EntityType.byString((String)typeString).orElse(null);
                if (entityType == null) {
                    return false;
                }
                Minecraft mc = Minecraft.getInstance();
                ClientLevel level = mc.level;
                if (level == null) {
                    return false;
                }
                Entity entity = entityType.create((Level)level);
                if (!(entity instanceof VehicleEntity)) {
                    return false;
                }
                VehicleEntity vehicle = (VehicleEntity)entity;
                icon = vehicle.getVehicleItemIcon();
                icons.put(typeString, icon);
            }
        }
        if (icon == null) {
            return false;
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        RenderHelper.preciseBlit(guiGraphics, icon, xOffset, yOffset, 200.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
        pose.popPose();
        return true;
    }
}

