/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.language.ClientLanguageGetter;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.FireModeInfo;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

@OnlyIn(value=Dist.CLIENT)
public class AmmoBarOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("ammo_bar");
    private static final ResourceLocation LINE = Mod.loc("textures/overlay/ammo_bar/fire_mode/line.png");
    private static final ResourceLocation MOUSE = Mod.loc("textures/overlay/ammo_bar/fire_mode/mouse.png");
    private static final ResourceLocation CHOSEN = Mod.loc("textures/gui/attachment/chosen.png");
    private static final ResourceLocation NOT_CHOSEN = Mod.loc("textures/gui/attachment/not_chosen.png");
    private static final ResourceLocation AMMO_STACK = Mod.loc("textures/gui/attachment/ammo_stack.png");
    private static final Function<String, ResourceLocation> TO_RESOURCE_LOCATION = Util.memoize(str -> Mod.loc("textures/overlay/ammo_bar/fire_mode/" + str + ".png"));
    private static final Pattern REPLACE_FORMAT_CODE = Pattern.compile("\u00a7.");

    private static ResourceLocation getFireMode(GunData data) {
        return TO_RESOURCE_LOCATION.apply(AmmoBarOverlay.toUnderScores(data.selectedFireModeInfo().name));
    }

    private static String toUnderScores(String str) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0) {
                    builder.append('_');
                }
                builder.append(Character.toLowerCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static String getGunAmmoString(GunData data, Player player) {
        if (data.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.ENERGY) {
            IEnergyStorage storage = (IEnergyStorage)data.stack.getCapability(Capabilities.EnergyStorage.ITEM);
            double energy = storage == null ? 0.0 : Mth.clamp((double)((double)storage.getEnergyStored() / (double)Math.max(1, storage.getMaxEnergyStored())), (double)0.0, (double)1.0);
            return FormatTool.format1DZZ(energy * 100.0) + "%";
        }
        if (data.meleeOnly() || data.useBackpackAmmo() && data.hasInfiniteBackupAmmo((Entity)player)) {
            return "\u221e";
        }
        return data.useBackpackAmmo() ? "" + (data.countBackupAmmo((Entity)player) - data.virtualAmmo.get()) : "" + data.ammo.get();
    }

    private static String getBackupAmmoString(GunData data, Player player) {
        if (data.meleeOnly() || data.useBackpackAmmo() || data.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.ENERGY) {
            return "";
        }
        return data.hasInfiniteBackupAmmo((Entity)player) ? "\u221e" : "" + (data.countBackupAmmo((Entity)player) - data.virtualAmmo.get());
    }

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!((Boolean)DisplayConfig.AMMO_HUD.get()).booleanValue()) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof GunItem) {
            VehicleEntity vehicle;
            GunItem gunItem = (GunItem)item;
            item = player.getVehicle();
            if (!(item instanceof VehicleEntity) || !(vehicle = (VehicleEntity)item).banHand((LivingEntity)player)) {
                int x = screenWidth + (Integer)DisplayConfig.WEAPON_HUD_X_OFFSET.get();
                int y = screenHeight + (Integer)DisplayConfig.WEAPON_HUD_Y_OFFSET.get();
                PoseStack poseStack = guiGraphics.pose();
                GunData data = GunData.from(stack);
                guiGraphics.blit(gunItem.getGunIcon(data), x - 135, y - 40, 0.0f, 0.0f, 64, 16, 64, 16);
                Font font = Minecraft.getInstance().font;
                if (stack.getItem() != ModItems.MINIGUN.get()) {
                    guiGraphics.drawString(font, "[" + ModKeyMappings.FIRE_MODE.getKey().getDisplayName().getString() + "]", (float)x - 111.5f, (float)(y - 20), 0xFFFFFF, false);
                }
                ResourceLocation fireMode = AmmoBarOverlay.getFireMode(data);
                int selectedFireMode = data.selectedFireMode.get();
                DefaultGunData computed = data.compute();
                List<FireModeInfo> fireModes = computed.availableFireModes();
                if (((Boolean)DisplayConfig.ADVANCED_AMMO_HUD.get()).booleanValue() && fireModes.size() > 3) {
                    guiGraphics.drawCenteredString(font, selectedFireMode + 1 + "/" + fireModes.size(), x - 75, y - 20, 0xCCCCCC);
                }
                if (stack.getItem() == ModItems.MINIGUN.get()) {
                    fireMode = MOUSE;
                    guiGraphics.drawString(font, computed.rpm + " RPM", (float)x - 111.0f, (float)(y - 20), 0xFFFFFF, false);
                    guiGraphics.blit(fireMode, x - 126, y - 22, 0.0f, 0.0f, 12, 12, 12, 12);
                } else {
                    guiGraphics.blit(fireMode, x - 95, y - 21, 0.0f, 0.0f, 8, 8, 8, 8);
                    guiGraphics.blit(LINE, x - 95, y - 16, 0.0f, 0.0f, 8, 8, 8, 8);
                }
                int size = computed.getAmmoConsumers().size();
                if (((Boolean)DisplayConfig.ADVANCED_AMMO_HUD.get()).booleanValue() && (size > 1 || size == 1 && data.selectedAmmoConsumer().type != AmmoConsumer.AmmoConsumeType.PLAYER_AMMO)) {
                    boolean renderStackCount;
                    AmmoConsumer ammoConsumer = data.selectedAmmoConsumer();
                    RenderHelper.preciseBlit(guiGraphics, AMMO_STACK, x - 62, (float)y - 20.5f, 0.0f, 0.0f, 24.0f, 8.5f, 24.0f, 24.0f);
                    poseStack.pushPose();
                    poseStack.translate((float)(x - 57), (float)(y - 21), 0.0f);
                    poseStack.scale(0.75f, 0.75f, 1.0f);
                    AmmoConsumer.AmmoConsumeType consumerType = ammoConsumer.type;
                    boolean bl = renderStackCount = consumerType == AmmoConsumer.AmmoConsumeType.ITEM || consumerType == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO;
                    if (renderStackCount) {
                        ItemStack ammoStack;
                        if (consumerType == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO) {
                            Ammo ammoType = ammoConsumer.getPlayerAmmoType();
                            ammoStack = switch (ammoType) {
                                default -> throw new MatchException(null, null);
                                case Ammo.HANDGUN -> new ItemStack((ItemLike)ModItems.HANDGUN_AMMO.get());
                                case Ammo.RIFLE -> new ItemStack((ItemLike)ModItems.RIFLE_AMMO.get());
                                case Ammo.SHOTGUN -> new ItemStack((ItemLike)ModItems.SHOTGUN_AMMO.get());
                                case Ammo.SNIPER -> new ItemStack((ItemLike)ModItems.SNIPER_AMMO.get());
                                case Ammo.HEAVY -> new ItemStack((ItemLike)ModItems.HEAVY_AMMO.get());
                            };
                        } else {
                            ammoStack = ammoConsumer.stack();
                        }
                        poseStack.translate(1.75f, 0.0f, 0.0f);
                        guiGraphics.renderFakeItem(ammoStack, 3, -1);
                        poseStack.translate(-1.75f, 0.0f, 0.0f);
                        String text = "" + data.countBackupAmmoItem((Entity)player);
                        guiGraphics.drawString(font, text, 24, 8, 0xFFFFFF, true);
                    }
                    poseStack.popPose();
                    if (!renderStackCount) {
                        if (consumerType == AmmoConsumer.AmmoConsumeType.INVALID) {
                            RenderHelper.preciseBlit(guiGraphics, AMMO_STACK, x - 50, (float)y - 19.5f, 12.0f, 8.5f, 5.0f, 8.0f, 24.0f, 24.0f);
                        } else if (consumerType == AmmoConsumer.AmmoConsumeType.ENERGY) {
                            RenderHelper.preciseBlit(guiGraphics, AMMO_STACK, x - 50, (float)y - 19.5f, 12.0f, 16.5f, 5.0f, 8.0f, 24.0f, 24.0f);
                        } else {
                            RenderHelper.preciseBlit(guiGraphics, AMMO_STACK, (float)x - 51.0f, y - 20, 0.0f, 8.5f, 7.0f, 8.0f, 24.0f, 24.0f);
                        }
                    }
                    if (size > 1) {
                        float offset = 47.0f;
                        int count = size / 2;
                        float posX = size % 2 == 0 ? (float)(x - count * 6 + 1) : (float)(x - count * 6 - 2);
                        float posY = y - 8;
                        for (int i = 0; i < size; ++i) {
                            RenderHelper.preciseBlit(guiGraphics, i == data.selectedAmmoType.get() ? CHOSEN : NOT_CHOSEN, posX - offset + (float)(6 * i), posY, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, 4.0f);
                        }
                    }
                }
                poseStack.pushPose();
                poseStack.scale(1.5f, 1.5f, 1.0f);
                int gunAmmoY = data.useBackpackAmmo() ? y - 38 : y + 5 - 48;
                guiGraphics.drawString(font, AmmoBarOverlay.getGunAmmoString(data, (Player)player), (float)x / 1.5f - 42.666668f, (float)gunAmmoY / 1.5f, 0xFFFFFF, true);
                poseStack.popPose();
                if (data.virtualAmmo.get() > 0 && !data.meleeOnly()) {
                    guiGraphics.drawString(font, "+" + data.virtualAmmo.get(), (float)(x - 62) + (float)font.width(AmmoBarOverlay.getGunAmmoString(data, (Player)player)) * 1.5f, (float)(y - 46), 0x55FFFF, true);
                }
                guiGraphics.drawString(font, AmmoBarOverlay.getBackupAmmoString(data, (Player)player), x - 64, y - 30, 0xCCCCCC, true);
                poseStack.pushPose();
                poseStack.scale(0.9f, 0.9f, 1.0f);
                String gunName = AmmoBarOverlay.getGunDisplayName(stack);
                guiGraphics.drawString(font, gunName, (float)x / 0.9f - (100.0f + (float)font.width(gunName) / 2.0f) / 0.9f, (float)y / 0.9f - 66.66667f, 0xFFFFFF, true);
                String ammoName = REPLACE_FORMAT_CODE.matcher(AmmoBarOverlay.getAmmoDisplayName(data)).replaceAll("");
                guiGraphics.drawString(font, ammoName, (float)x / 0.9f - (100.0f + (float)font.width(ammoName) / 2.0f) / 0.9f, (float)y / 0.9f - 56.666668f, 13149817, true);
                poseStack.popPose();
            }
        }
    }

    private static String getGunDisplayName(ItemStack stack) {
        if (!stack.isEmpty()) {
            return ClientLanguageGetter.EN_US.getOrDefault(stack.getDescriptionId());
        }
        return "";
    }

    private static String getAmmoDisplayName(GunData data) {
        AmmoConsumer consumer = data.selectedAmmoConsumer();
        if (consumer.type == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO) {
            return consumer.getPlayerAmmoType().displayName;
        }
        if (consumer.type == AmmoConsumer.AmmoConsumeType.INFINITE) {
            return "Infinity";
        }
        if (data.meleeOnly()) {
            return "Melee";
        }
        if (consumer.type == AmmoConsumer.AmmoConsumeType.ENERGY) {
            return "Energy";
        }
        if (!consumer.stack().isEmpty()) {
            Component nameComponent = consumer.stack().getHoverName();
            ComponentContents componentContents = nameComponent.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatableComponent = (TranslatableContents)componentContents;
                return ClientLanguageGetter.EN_US.getOrDefault(translatableComponent.getKey());
            }
            return ClientLanguageGetter.EN_US.getOrDefault(consumer.stack().getDescriptionId());
        }
        return "";
    }
}

