/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HandsomeFrameOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("handsome_frame");
    private static final ResourceLocation FRAME = Mod.loc("textures/overlay/frame/frame.png");
    private static final ResourceLocation FRAME_WEAK = Mod.loc("textures/overlay/frame/frame_weak.png");
    private static final ResourceLocation FRAME_TARGET = Mod.loc("textures/overlay/frame/frame_target_triangle.png");
    private static final ResourceLocation FRAME_LOCK = Mod.loc("textures/overlay/frame/frame_lock.png");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        VehicleEntity vehicle;
        LocalPlayer player = Minecraft.getInstance().player;
        PoseStack poseStack = guiGraphics.pose();
        if (player == null) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (ClientEventHandler.isEditing) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player)) {
            return;
        }
        if (stack.getItem() instanceof GunItem && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            GunData data = GunData.from(stack);
            short level = data.perk.getLevel(ModPerks.INTELLIGENT_CHIP);
            if (level == 0) {
                return;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            List<Entity> allEntities = SeekTool.seekLivingEntitiesThroughWall((Entity)player, 32 + 8 * (level - 1), 30.0);
            List<Entity> visibleEntities = SeekTool.seekLivingEntities((Entity)player, 32 + 8 * (level - 1), 30.0);
            Entity nearestEntity = SeekTool.seekLivingEntity((Entity)player, 32 + 8 * (level - 1), 30.0);
            Entity targetEntity = ClientEventHandler.lockedEntity;
            for (Entity e : allEntities) {
                Vec3 pos = new Vec3(Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)e.xo, (double)e.getX()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)(e.yo + (double)e.getEyeHeight()), (double)e.getEyeY()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)e.zo, (double)e.getZ()));
                Vec3 point = VectorUtil.worldToScreen(pos);
                boolean lockOn = e == targetEntity;
                boolean isNearestEntity = e == nearestEntity;
                poseStack.pushPose();
                float x = (float)point.x;
                float y = (float)point.y;
                boolean canBeSeen = visibleEntities.contains(e);
                ResourceLocation icon = lockOn ? FRAME_LOCK : (canBeSeen ? (isNearestEntity ? FRAME_TARGET : FRAME) : FRAME_WEAK);
                RenderHelper.preciseBlit(guiGraphics, icon, x - 12.0f, y - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                poseStack.popPose();
            }
        }
    }
}

