/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.IFFOverlay;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpyglassRangeOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("spyglass_range");
    private static final ResourceLocation INDICATOR = Mod.loc("textures/overlay/spyglass/indicator.png");
    private static final ResourceLocation SPYGLASS = Mod.loc("textures/overlay/spyglass/spyglass.png");
    private static float scopeScale = 1.0f;
    private static float lerpHoldArtilleryIndicator;

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        LocalPlayer player = mc.player;
        Camera camera = mc.gameRenderer.getMainCamera();
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        if (player == null) {
            return;
        }
        if ((player.isUsingItem() && player.getUseItem().is((Item)ModItems.ARTILLERY_INDICATOR.get()) || player.isScoping()) && mc.options.getCameraType() == CameraType.FIRST_PERSON) {
            if (player.getUseItem().is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                Vec3 pos;
                ItemStack stack = player.getUseItem();
                poseStack.pushPose();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float deltaFrame = deltaTracker.getGameTimeDeltaPartialTick(true);
                scopeScale = (float)Mth.lerp((double)(0.5f * deltaFrame), (double)scopeScale, (double)((double)1.35f + (double)0.2f * ClientEventHandler.firePos));
                float f = Math.min(screenWidth, screenHeight);
                float f1 = Math.min((float)screenWidth / f, (float)screenHeight / f) * scopeScale;
                float i = Mth.floor((float)(f * f1));
                float j = Mth.floor((float)(f * f1));
                float k = ((float)screenWidth - i) / 2.0f;
                float l = ((float)screenHeight - j) / 2.0f;
                float w = i * 21.0f / 9.0f;
                RenderHelper.preciseBlit(guiGraphics, SPYGLASS, k - 2.0f * w / 7.0f, l, 0.0f, 0.0f, w, j, w, j);
                FiringParameters.Parameters parameters = (FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
                if (parameters != null) {
                    BlockPos blockPos = parameters.pos();
                    pos = new Vec3((double)blockPos.getX() - 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5);
                } else {
                    pos = Vec3.ZERO;
                }
                Vec3 point = VectorUtil.worldToScreen(pos);
                if (VectorUtil.canSee(pos)) {
                    float x = (float)point.x;
                    float y = (float)point.y;
                    RenderHelper.preciseBlit(guiGraphics, INDICATOR, Mth.clamp((float)(x - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.clamp((float)(y - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
                }
                ListTag tags = NBTTool.getTag(stack).getList("Cannons", 10);
                for (int m = 0; m < tags.size(); ++m) {
                    CompoundTag tag = tags.getCompound(m);
                    Entity entity = EntityFindUtil.findEntity(player.level(), tag.getString("UUID"));
                    if (entity == null) continue;
                    Vec3 posF = VectorTool.lerpGetEntityBoundingBoxCenter(entity, deltaFrame);
                    Vec3 pointF = VectorUtil.worldToScreen(posF);
                    if (!VectorUtil.canSee(posF)) continue;
                    float xf = (float)pointF.x;
                    float yf = (float)pointF.y;
                    RenderHelper.preciseBlit(guiGraphics, IFFOverlay.FRIENDLY_ARTILLERY, Mth.clamp((float)(xf - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.clamp((float)(yf - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
                }
                poseStack.popPose();
                lerpHoldArtilleryIndicator = Mth.lerp((float)deltaTracker.getGameTimeDeltaPartialTick(true), (float)lerpHoldArtilleryIndicator, (float)(0.05f * (float)ClientEventHandler.holdArtilleryIndicator));
                if (lerpHoldArtilleryIndicator > 0.0f) {
                    float alpha = Mth.clamp((float)(lerpHoldArtilleryIndicator * 20.0f), (float)0.0f, (float)5.0f) * 0.2f;
                    RenderHelper.renderCircularRing(guiGraphics, (float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 0.07f, 0.052f, new float[]{0.0f, 0.0f, 0.0f, 0.4f * alpha}, new float[]{1.0f, 1.0f, 1.0f, 0.8f * alpha}, lerpHoldArtilleryIndicator, true);
                }
            }
            boolean lookAtEntity = false;
            BlockHitResult result = player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(player.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 hitPos = result.getLocation();
            double blockRange = player.getEyePosition(1.0f).distanceTo(hitPos);
            double entityRange = 0.0;
            Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, 520.0);
            if (lookingEntity instanceof VehicleEntity) {
                return;
            }
            if (lookingEntity != null) {
                lookAtEntity = true;
                entityRange = player.distanceTo(lookingEntity);
            }
            if (lookAtEntity) {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)(FormatTool.format1D(entityRange, "M ") + lookingEntity.getDisplayName().getString()))), screenWidth / 2 + 12, screenHeight / 2 - 28, -1, false);
            } else if (blockRange > 500.0) {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)"---M")), screenWidth / 2 + 12, screenHeight / 2 - 28, -1, false);
            } else {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)FormatTool.format1D(blockRange, "M"))), screenWidth / 2 + 12, screenHeight / 2 - 28, -1, false);
            }
        } else {
            scopeScale = 1.0f;
        }
    }
}

