/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.entity.vehicle.Type63Entity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class Type63InfoOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("type_63_info");
    private static final ItemStack AP = new ItemStack((ItemLike)ModItems.MEDIUM_ROCKET_AP.get());
    private static final ItemStack HE = new ItemStack((ItemLike)ModItems.MEDIUM_ROCKET_HE.get());
    private static final ItemStack CM = new ItemStack((ItemLike)ModItems.MEDIUM_ROCKET_CM.get());

    public void render(GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        PoseStack poseStack = guiGraphics.pose();
        if (player == null) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, player.entityInteractionRange());
        if (!(lookingEntity instanceof Type63Entity)) {
            return;
        }
        Type63Entity type63Entity = (Type63Entity)lookingEntity;
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.mortar.pitch").append((Component)Component.literal((String)FormatTool.format2D(((Float)type63Entity.getEntityData().get(Type63Entity.SHOOT_PITCH)).floatValue(), "\u00b0"))), screenWidth / 2 - 130, screenHeight / 2 - 26, -1, false);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.mortar.yaw").append((Component)Component.literal((String)FormatTool.format2D(((Float)type63Entity.getEntityData().get(Type63Entity.SHOOT_YAW)).floatValue(), "\u00b0"))), screenWidth / 2 - 130, screenHeight / 2 - 16, -1, false);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.mortar.range").append((Component)Component.literal((String)FormatTool.format1D(Math.max((int)RangeTool.getRange(((Float)type63Entity.getEntityData().get(Type63Entity.SHOOT_PITCH)).floatValue(), 10.0, 0.05), 0), "m"))), screenWidth / 2 - 130, screenHeight / 2 - 6, -1, false);
        List items = (List)type63Entity.getEntityData().get(Type63Entity.LOADED_AMMO);
        for (int i = 0; i < type63Entity.barrel.length; ++i) {
            if (OBB.getLookingObb((Player)player, player.entityInteractionRange()) != type63Entity.barrel[i]) continue;
            int type = (Integer)items.get(i);
            ItemStack stack = switch (type) {
                case 0 -> AP;
                case 1 -> HE;
                case 2 -> CM;
                default -> ItemStack.EMPTY;
            };
            Vec3 pos = OBB.vector3dToVec3(type63Entity.barrel[i].center());
            Vec3 point = VectorUtil.worldToScreen(pos);
            poseStack.pushPose();
            float x = (float)point.x;
            float y = (float)point.y;
            Component component = stack.getHoverName();
            if (stack.isEmpty()) {
                component = Component.translatable((String)"tips.superbwarfare.barrel_empty");
                width = Minecraft.getInstance().font.width((FormattedText)component);
                poseStack.translate(x - (float)width / 2.0f, y, 0.0f);
                guiGraphics.drawString(Minecraft.getInstance().font, component, 0, 0, -1, false);
            } else {
                width = Minecraft.getInstance().font.width((FormattedText)component) + 20;
                poseStack.pushPose();
                poseStack.translate(x - (float)width / 2.0f, y, 0.0f);
                guiGraphics.renderFakeItem(stack, 0, 0);
                poseStack.translate(20.0f, 4.0f, 0.0f);
                guiGraphics.drawString(Minecraft.getInstance().font, component, 0, 0, -1, false);
            }
            poseStack.popPose();
        }
        ItemStack stack = player.getOffhandItem();
        if (player.getMainHandItem().getItem() instanceof FiringParameters) {
            stack = player.getMainHandItem();
        }
        if (stack.getItem() instanceof FiringParameters) {
            FiringParameters.Parameters parameters = (FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
            if (parameters == null) {
                parameters = new FiringParameters.Parameters();
            }
            double targetX = parameters.pos().getX();
            double targetY = parameters.pos().getY() - 1;
            double targetZ = parameters.pos().getZ();
            boolean isDepressed = parameters.isDepressed();
            Vec3 targetPos = new Vec3(targetX, targetY, targetZ);
            Vec3 launchVector = RangeTool.calculateLaunchVector(type63Entity.getShootPos(partialTick), targetPos, 10.0, 0.05, isDepressed);
            Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.apply(lookingEntity);
            double d0 = (targetPos.x - vec3.x) * 0.2;
            double d2 = (targetPos.z - vec3.z) * 0.2;
            double targetYaw = Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
            if (launchVector == null) {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.mortar.out_of_range").withStyle(ChatFormatting.RED), screenWidth / 2 + 90, screenHeight / 2 - 26, -1, false);
                return;
            }
            float angle = (float)VehicleVecUtils.getXRotFromVector(launchVector);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.target.pitch").append((Component)Component.literal((String)FormatTool.format2D(angle, "\u00b0"))), screenWidth / 2 + 90, screenHeight / 2 - 26, -1, false);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.target.yaw").append((Component)Component.literal((String)FormatTool.format2D(targetYaw, "\u00b0"))), screenWidth / 2 + 90, screenHeight / 2 - 16, -1, false);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.mortar.target_pos").append((Component)Component.literal((String)(FormatTool.format0D(targetX) + " " + FormatTool.format0D(targetY) + " " + FormatTool.format0D(targetZ)))), screenWidth / 2 + 90, screenHeight / 2 - 6, -1, false);
            if (angle < -5.0f || angle > 60.0f) {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.mortar.warn", (Object[])new Object[]{lookingEntity.getDisplayName()}).withStyle(ChatFormatting.RED), screenWidth / 2 + 90, screenHeight / 2 + 4, -1, false);
                if (angle > 60.0f && !isDepressed) {
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.ballistics.warn").withStyle(ChatFormatting.RED), screenWidth / 2 + 90, screenHeight / 2 + 14, -1, false);
                }
            }
        }
    }
}

