/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay.weapon;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class AircraftHud {
    public static final String ID = "@Aircraft";
    private static float lerpVy = 1.0f;
    private static float lerpG = 1.0f;
    private static float diffY;
    private static float diffX;
    public static double bombHitPosX;
    public static double bombHitPosY;
    public static double bombHitPosZ;
    private static final ResourceLocation BOMB_SCOPE;
    private static final ResourceLocation BOMB_SCOPE_PITCH;
    private static final ResourceLocation HUD_BASE_MISSILE;
    private static final ResourceLocation HUD_BASE;
    private static final ResourceLocation HUD_LINE;
    private static final ResourceLocation HUD_IND;
    private static final ResourceLocation HUD_BOMB;
    private static final ResourceLocation HUD_BASE2;
    private static final ResourceLocation COMPASS_IND;
    private static final ResourceLocation HELICOPTER_ROLL_IND;
    private static final ResourceLocation HELICOPTER_SPEED_FRAME;
    private static final ResourceLocation COMPASS;
    private static final ResourceLocation CROSSHAIR_3P;
    private static final ResourceLocation BOMB_RING;

    public static void render(VehicleEntity vehicle, Player player, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        float y;
        float x;
        if (player != vehicle.getFirstPassenger()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        PoseStack poseStack = guiGraphics.pose();
        GunData gunData = vehicle.getGunData((Entity)player);
        if (gunData == null) {
            return;
        }
        poseStack.pushPose();
        boolean bomb = gunData.compute().crosshair.equals("@AirBomb");
        int color = vehicle.getHudColor();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        lerpVy = (float)Mth.lerp((double)(0.021f * partialTick), (double)lerpVy, (double)(vehicle.getDeltaMovement().y() * 20.0));
        diffY = (float)Mth.lerp((double)partialTick, (double)diffY, (double)ClientMouseHandler.lerpSpeedX);
        diffX = (float)Mth.lerp((double)partialTick, (double)diffX, (double)ClientMouseHandler.lerpSpeedY);
        Vec3 shootPos = vehicle.getShootPosForHud((Entity)player, partialTick);
        BlockHitResult result = player.level().clip(new ClipContext(shootPos, shootPos.add(vehicle.getShootDirectionForHud((Entity)player, partialTick).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 hitPos = result.getLocation();
        double dis = shootPos.distanceTo(hitPos);
        Entity lookingEntity = vehicle.getPlayerLookAtEntityOnVehicle((Entity)player, 512.0, partialTick);
        if (lookingEntity != null) {
            dis = shootPos.distanceTo(lookingEntity.position());
        }
        Vec3 pos = cameraPos.add(vehicle.getViewVector(partialTick).scale(512.0));
        Vec3 posCross = shootPos.add(vehicle.getShootDirectionForHud((Entity)player, partialTick).scale(dis));
        if (bomb) {
            bombHitPosX = Mth.lerp((double)partialTick, (double)bombHitPosX, (double)vehicle.bombHitPos((Entity)player).x);
            bombHitPosY = Mth.lerp((double)partialTick, (double)bombHitPosY, (double)vehicle.bombHitPos((Entity)player).y);
            bombHitPosZ = Mth.lerp((double)partialTick, (double)bombHitPosZ, (double)vehicle.bombHitPos((Entity)player).z);
            posCross = new Vec3(bombHitPosX, bombHitPosY, bombHitPosZ);
        }
        Vec3 p = VectorUtil.worldToScreen(pos);
        Vec3 pCross = VectorUtil.worldToScreen(posCross);
        if (bomb && ClientEventHandler.zoomVehicle && VectorUtil.canSee(posCross)) {
            float f = Math.min((int)screenWidth, (int)screenHeight);
            float f1 = Math.min((float)((float)screenWidth / f), (float)((float)screenHeight / f));
            int i = Mth.floor((float)(f * f1));
            int j = Mth.floor((float)(f * f1));
            float x2 = (float)screenWidth / 2.0f;
            float y2 = (float)screenHeight / 2.0f;
            poseStack.pushPose();
            poseStack.translate(x2, y2, 0.0f);
            Component component = vehicle.thirdPersonAmmoComponent(gunData, player);
            guiGraphics.drawString(mc.font, component, 25, -11, 1, false);
            poseStack.popPose();
            RenderHelper.preciseBlit(guiGraphics, BOMB_SCOPE, x2 - 1.5f * (float)i, y2 - 1.5f * (float)j, 0.0f, 0.0f, 3 * i, 3 * j, 3 * i, 3 * j);
            poseStack.pushPose();
            poseStack.rotateAround(Axis.ZP.rotationDegrees(vehicle.getRoll(partialTick)), x2, y2, 0.0f);
            RenderHelper.preciseBlit(guiGraphics, BOMB_SCOPE_PITCH, x2 - 1.5f * (float)i, y2 - 1.5f * (float)j - 4.0f * vehicle.getPitch(partialTick), 0.0f, 0.0f, 3 * i, 3 * j, 3 * i, 3 * j);
            VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x2 - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y2 - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
            poseStack.popPose();
            return;
        }
        poseStack.pushPose();
        if ((mc.options.getCameraType() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) && VectorUtil.canSee(pos)) {
            x = (float)p.x;
            y = (float)p.y;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (gunData.compute().crosshair.equals("@AirCraftMissile")) {
                RenderHelper.preciseBlitWithColor(guiGraphics, HUD_BASE_MISSILE, x - 160.0f, y - 160.0f, 0.0f, 0.0f, 320.0f, 320.0f, 320.0f, 320.0f, color);
            } else {
                RenderHelper.preciseBlitWithColor(guiGraphics, HUD_BASE, x - 160.0f, y - 160.0f, 0.0f, 0.0f, 320.0f, 320.0f, 320.0f, 320.0f, color);
            }
            RenderHelper.preciseBlitWithColor(guiGraphics, COMPASS, x - 128.0f, y - 122.0f, 128.0f + 1.4222223f * vehicle.getYRot(), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f, color);
            RenderHelper.preciseBlitWithColor(guiGraphics, COMPASS_IND, x - 4.0f, y - 130.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f, color);
            poseStack.pushPose();
            poseStack.rotateAround(Axis.ZP.rotationDegrees(vehicle.getRoll(partialTick)), x, y + 48.0f, 0.0f);
            RenderHelper.preciseBlitWithColor(guiGraphics, HELICOPTER_ROLL_IND, x - 4.0f, y + 144.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f, color);
            poseStack.popPose();
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.format0D(vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)) * 72.0)), (int)x - 105, (int)y - 61, color, false);
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.format0D(vehicle.getY())), (int)x + 111 - 36, (int)y - 61, color, false);
            RenderHelper.preciseBlitWithColor(guiGraphics, HELICOPTER_SPEED_FRAME, x - 108.0f, y - 64.0f, 0.0f, 0.0f, 36.0f, 12.0f, 36.0f, 12.0f, color);
            RenderHelper.preciseBlitWithColor(guiGraphics, HELICOPTER_SPEED_FRAME, x + 108.0f - 36.0f, y - 64.0f, 0.0f, 0.0f, 36.0f, 12.0f, 36.0f, 12.0f, color);
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.DECIMAL_FORMAT_1ZZ.format(lerpVy)), (int)x - 96, (int)y + 60, color, false);
            lerpG = (float)Mth.lerp((double)(0.1f * partialTick), (double)lerpG, (double)(vehicle.getAcceleration() / 9.8));
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)"M"), (int)x - 105, (int)y + 70, color, false);
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)"0.2"), (int)x - 96, (int)y + 70, color, false);
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)"G"), (int)x - 105, (int)y + 78, color, false);
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.DECIMAL_FORMAT_1ZZ.format(lerpG)), (int)x - 96, (int)y + 78, color, false);
            if (vehicle.hasDecoy()) {
                if (vehicle.getDecoyState().equals("READY")) {
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.flare.ready").append((Component)Component.literal((String)(" [" + ModKeyMappings.RELEASE_DECOY.getKey().getDisplayName().getString() + "]"))), (int)x + 72, (int)y, color, false);
                } else {
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.flare.reloading"), (int)x + 72, (int)y, 0xFF0000, false);
                }
            }
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)"TGT"), (int)x + 76, (int)y + 78, color, false);
            int heat = vehicle.getWeaponHeat((LivingEntity)player);
            Component component = vehicle.firstPersonAmmoComponent(gunData, player);
            guiGraphics.drawString(mc.font, component, (int)x - mc.font.width((FormattedText)component) / 2, (int)y + 91, MathTool.getGradientColor(color, 0xFF0000, heat, 2), false);
            poseStack.pushPose();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.rotateAround(Axis.ZP.rotationDegrees(-vehicle.getRoll(partialTick)), x, y, 0.0f);
            float pitch = vehicle.getPitch(partialTick);
            RenderHelper.preciseBlitWithColor(guiGraphics, HUD_LINE, x - 96.0f + diffY, y - 128.0f, 0.0f, 448.0f + 4.10625f * pitch, 192.0f, 256.0f, 192.0f, 1152.0f, color);
            RenderHelper.preciseBlitWithColor(guiGraphics, HUD_IND, x - 18.0f + diffY, y - 12.0f, 0.0f, 0.0f, 36.0f, 24.0f, 36.0f, 24.0f, color);
            RenderHelper.preciseBlitWithColor(guiGraphics, HUD_LINE, x - 96.0f + diffY, y - 128.0f, 0.0f, 448.0f + 4.10625f * pitch, 192.0f, 256.0f, 192.0f, 1152.0f, color);
            if (bomb) {
                RenderHelper.preciseBlitWithColor(guiGraphics, HUD_BOMB, x - 64.0f + diffY, y - 64.0f, 0.0f, 0.0f, 128.0f, 128.0f, 128.0f, 128.0f, color);
            } else {
                RenderHelper.preciseBlitWithColor(guiGraphics, HUD_IND, x - 18.0f + diffY, y - 12.0f, 0.0f, 0.0f, 36.0f, 24.0f, 36.0f, 24.0f, color);
            }
            poseStack.popPose();
            if (vehicle.hasEnergyStorage()) {
                if ((double)vehicle.getEnergy() < 0.02 * (double)vehicle.getMaxEnergy()) {
                    guiGraphics.drawString(mc.font, (Component)Component.literal((String)"NO POWER!"), (int)x - 144, (int)y + 14, -65536, false);
                } else if ((double)vehicle.getEnergy() < 0.2 * (double)vehicle.getMaxEnergy()) {
                    guiGraphics.drawString(mc.font, (Component)Component.literal((String)"LOW POWER"), (int)x - 144, (int)y + 14, 16739072, false);
                }
            }
        }
        poseStack.pushPose();
        if (VectorUtil.canSee(posCross)) {
            x = (float)pCross.x;
            y = (float)pCross.y;
            if (!(mc.options.getCameraType() != CameraType.FIRST_PERSON && !ClientEventHandler.zoomVehicle || gunData.compute().crosshair.equals("@AirBomb") || gunData.compute().crosshair.equals("@AirCraftMissile"))) {
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderHelper.preciseBlitWithColor(guiGraphics, HUD_BASE2, x - 72.0f + diffY, y - 72.0f + diffX, 0.0f, 0.0f, 144.0f, 144.0f, 144.0f, 144.0f, color);
            } else if (mc.options.getCameraType() != CameraType.FIRST_PERSON && !ClientEventHandler.zoomVehicle) {
                poseStack.pushPose();
                poseStack.rotateAround(Axis.ZP.rotationDegrees(vehicle.getRoll(partialTick)), x, y, 0.0f);
                poseStack.pushPose();
                poseStack.translate(x, y, 0.0f);
                poseStack.scale(0.75f, 0.75f, 1.0f);
                ResourceLocation cross = CROSSHAIR_3P;
                float size = 16.0f;
                if (gunData.compute().crosshair.equals("@AirBomb")) {
                    cross = BOMB_RING;
                    size = 24.0f;
                }
                float heat = (float)vehicle.getWeaponHeat((LivingEntity)player) / 100.0f;
                Component component = vehicle.thirdPersonAmmoComponent(gunData, player);
                guiGraphics.drawString(mc.font, component, 25, -9, Mth.hsvToRgb((float)0.0f, (float)heat, (float)1.0f), false);
                if (vehicle.hasDecoy()) {
                    if (vehicle.getDecoyState().equals("READY")) {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.flare.ready").append((Component)Component.literal((String)(" [" + ModKeyMappings.RELEASE_DECOY.getKey().getDisplayName().getString() + "]"))), 25, 1, -1, false);
                    } else {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.flare.reloading"), 25, 1, 0xFF0000, false);
                    }
                }
                poseStack.popPose();
                RenderHelper.preciseBlit(guiGraphics, cross, x - 0.5f * size, y - 0.5f * size, 0.0f, 0.0f, size, size, size, size);
                VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                poseStack.popPose();
            }
        }
        double speed = vehicle.getDeltaMovement().length() * 72.0;
        double height = vehicle.position().distanceTo(Vec3.atLowerCornerOf((Vec3i)vehicle.level().clip(new ClipContext(vehicle.position(), vehicle.position().add(new Vec3(0.0, -1.0, 0.0).scale(160.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)vehicle)).getBlockPos()));
        double blockInWay = vehicle.position().distanceTo(Vec3.atLowerCornerOf((Vec3i)vehicle.level().clip(new ClipContext(vehicle.position(), vehicle.position().add(vehicle.getDeltaMovement().add(0.0, 0.06, 0.0).normalize().scale(160.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)vehicle)).getBlockPos()));
        if (lerpVy < -42.0f) {
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"SINK RATE, PULL UP!"), screenWidth / 2 - 53, screenHeight / 2 + 24, -65536, false);
            if (player.tickCount % 30 == 0) {
                player.level().playLocalSound(player.getOnPos(), (SoundEvent)ModSounds.PULL_UP.get(), SoundSource.PLAYERS, 3.0f, 1.0f, false);
            }
        } else if ((lerpVy < -10.0f || lerpVy < -3.0f && speed > 170.0) && height < 30.0 || speed > 100.0 && blockInWay < 144.0) {
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"TERRAIN TERRAIN"), screenWidth / 2 - 42, screenHeight / 2 + 24, -65536, false);
            if (player.tickCount % 30 == 0) {
                player.level().playLocalSound(player.getOnPos(), (SoundEvent)ModSounds.TERRAIN.get(), SoundSource.PLAYERS, 3.0f, 1.0f, false);
            }
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    static {
        BOMB_SCOPE = Mod.loc("textures/overlay/vehicle/aircraft/bomb_scope.png");
        BOMB_SCOPE_PITCH = Mod.loc("textures/overlay/vehicle/aircraft/bomb_scope_pitch.png");
        HUD_BASE_MISSILE = Mod.loc("textures/overlay/vehicle/aircraft/hud_base_missile.png");
        HUD_BASE = Mod.loc("textures/overlay/vehicle/aircraft/hud_base.png");
        HUD_LINE = Mod.loc("textures/overlay/vehicle/aircraft/hud_line.png");
        HUD_IND = Mod.loc("textures/overlay/vehicle/aircraft/hud_ind.png");
        HUD_BOMB = Mod.loc("textures/overlay/vehicle/aircraft/bomb.png");
        HUD_BASE2 = Mod.loc("textures/overlay/vehicle/aircraft/hud_base2.png");
        COMPASS_IND = Mod.loc("textures/overlay/vehicle/aircraft/compass_ind.png");
        HELICOPTER_ROLL_IND = Mod.loc("textures/overlay/vehicle/helicopter/roll_ind.png");
        HELICOPTER_SPEED_FRAME = Mod.loc("textures/overlay/vehicle/helicopter/speed_frame.png");
        COMPASS = Mod.loc("textures/overlay/vehicle/base/compass.png");
        CROSSHAIR_3P = Mod.loc("textures/overlay/vehicle/crosshair/third_camera.png");
        BOMB_RING = Mod.loc("textures/overlay/crosshair/rex_circle.png");
    }
}

