/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay.weapon;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleMainWeaponHudOverlay;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class HelicopterHud {
    public static final String ID = "@Helicopter";
    private static final ResourceLocation HELI_BASE = Mod.loc("textures/overlay/vehicle/helicopter/heli_base.png");
    private static final ResourceLocation ROLL_IND = Mod.loc("textures/overlay/vehicle/helicopter/roll_ind.png");
    private static final ResourceLocation HELI_LINE = Mod.loc("textures/overlay/vehicle/helicopter/heli_line.png");
    private static final ResourceLocation HELI_POWER_RULER = Mod.loc("textures/overlay/vehicle/helicopter/heli_power_ruler.png");
    private static final ResourceLocation HELI_POWER = Mod.loc("textures/overlay/vehicle/helicopter/heli_power.png");
    private static final ResourceLocation HELI_VY_MOVE = Mod.loc("textures/overlay/vehicle/helicopter/heli_vy_move.png");
    private static final ResourceLocation SPEED_FRAME = Mod.loc("textures/overlay/vehicle/helicopter/speed_frame.png");
    private static final ResourceLocation CROSSHAIR_IND = Mod.loc("textures/overlay/vehicle/helicopter/crosshair_ind.png");
    private static final ResourceLocation HELI_DRIVER_ANGLE = Mod.loc("textures/overlay/vehicle/helicopter/heli_driver_angle.png");
    private static final ResourceLocation FRAME = Mod.loc("textures/overlay/vehicle/land/tv_frame.png");
    private static final ResourceLocation LINE = Mod.loc("textures/overlay/vehicle/land/line.png");
    private static final ResourceLocation COMPASS = Mod.loc("textures/overlay/vehicle/base/compass.png");
    private static final ResourceLocation CROSSHAIR_3P = Mod.loc("textures/overlay/vehicle/crosshair/third_camera.png");
    private static float scopeScale = 1.0f;
    private static float lerpVy = 1.0f;
    private static float lerpPower = 1.0f;

    public static void render(VehicleEntity vehicle, LocalPlayer player, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        int index = vehicle.getSeatIndex((Entity)player);
        GunData data = vehicle.getGunData(index);
        if (data == null) {
            scopeScale = 0.7f;
            return;
        }
        int color = vehicle.getHudColor();
        if (vehicle.getSeatIndex((Entity)player) == vehicle.computed().turretControllerIndex && vehicle.hasTurret()) {
            if (ClientEventHandler.zoomVehicle) {
                VehicleMainWeaponHudOverlay.renderWeaponInfoFirst(guiGraphics, vehicle, (Player)player, vehicle.getGunData((Entity)player), mc.font, screenWidth, screenHeight, color);
                RenderHelper.preciseBlitWithColor(guiGraphics, COMPASS, (float)screenWidth / 2.0f - 128.0f, 10.0f, (float)(128.0 - 1.4222222566604614 * VehicleVecUtils.getYRotFromVector(vehicle.getBarrelVector(partialTick))), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f, color);
                RenderHelper.preciseBlitWithColor(guiGraphics, ROLL_IND, (float)screenWidth / 2.0f - 8.0f, 30.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, color);
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int addW = screenWidth / screenHeight * 48;
                int addH = screenWidth / screenHeight * 27;
                RenderHelper.preciseBlit(guiGraphics, FRAME, (float)(-addW) / 2.0f, (float)(-addH) / 2.0f, 10.0f, 0.0f, 0.0f, screenWidth + addW, screenHeight + addH, screenWidth + addW, screenHeight + addH);
                RenderHelper.preciseBlitWithColor(guiGraphics, LINE, (float)screenWidth / 2.0f - 64.0f, screenHeight - 56, 0.0f, 0.0f, 128.0f, 1.0f, 128.0f, 1.0f, color);
                guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.format0D(vehicle.getDeltaMovement().dot(vehicle.getViewVector(partialTick)) * 72.0, " km/h")), screenWidth / 2 + 160, screenHeight / 2 - 48, color, false);
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(vehicle.getY(), " m")), screenWidth / 2 + 160, screenHeight / 2 - 39, color, false);
                VehicleMainWeaponHudOverlay.renderEnergyInfo(vehicle, guiGraphics, screenWidth, screenHeight, mc.font);
                boolean lookAtEntity = false;
                BlockHitResult result = player.level().clip(new ClipContext(vehicle.getShootPosForHud((Entity)player, partialTick), vehicle.getShootPosForHud((Entity)player, partialTick).add(vehicle.getShootDirectionForHud((Entity)player, partialTick).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                Vec3 hitPos = result.getLocation();
                double blockRange = player.getEyePosition(1.0f).distanceTo(hitPos);
                double entityRange = 0.0;
                Entity lookingEntity = TraceTool.camerafFindLookingEntity((Player)player, vehicle.getShootPosForHud((Entity)player, partialTick), vehicle.getShootDirectionForHud((Entity)player, partialTick), 512.0);
                if (lookingEntity != null) {
                    lookAtEntity = true;
                    entityRange = player.distanceTo(lookingEntity);
                }
                if (lookAtEntity) {
                    int width = Minecraft.getInstance().font.width(FormatTool.format0D(entityRange, " m"));
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(entityRange, " m")), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
                } else if (blockRange > 500.0) {
                    int width = Minecraft.getInstance().font.width("---m");
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"---m"), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
                } else {
                    int width = Minecraft.getInstance().font.width(FormatTool.format0D(blockRange, " m"));
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(blockRange, " m")), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
                }
            }
        } else {
            poseStack.pushPose();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            scopeScale = Mth.lerp((float)partialTick, (float)scopeScale, (float)1.0f);
            float f = Math.min((int)screenWidth, (int)screenHeight);
            float f1 = Math.min((float)((float)screenWidth / f), (float)((float)screenHeight / f)) * scopeScale;
            float i = Mth.floor((float)(f * f1));
            float j = Mth.floor((float)(f * f1));
            float k = ((float)screenWidth - i) / 2.0f;
            float l = ((float)screenHeight - j) / 2.0f;
            Vec3 shootPos = vehicle.getShootPosForHud((Entity)player, partialTick);
            BlockHitResult result = player.level().clip(new ClipContext(shootPos, shootPos.add(vehicle.getShootDirectionForHud((Entity)player, partialTick).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 hitPos = result.getLocation();
            double dis = shootPos.distanceTo(hitPos);
            Entity lookingEntity = vehicle.getPlayerLookAtEntityOnVehicle((Entity)player, 512.0, partialTick);
            if (lookingEntity != null) {
                dis = shootPos.distanceTo(lookingEntity.position());
            }
            Vec3 pos = shootPos.add(vehicle.getShootDirectionForHud((Entity)player, partialTick).scale(dis));
            Vec3 screenPos = VectorUtil.worldToScreen(pos);
            double speed = vehicle.getDeltaMovement().length() * 72.0;
            double height = vehicle.position().distanceTo(Vec3.atLowerCornerOf((Vec3i)vehicle.level().clip(new ClipContext(vehicle.position(), vehicle.position().add(new Vec3(0.0, -1.0, 0.0).scale(100.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)vehicle)).getBlockPos()));
            double blockInWay = vehicle.position().distanceTo(Vec3.atLowerCornerOf((Vec3i)vehicle.level().clip(new ClipContext(vehicle.position(), vehicle.position().add(vehicle.getDeltaMovement().add(0.0, 0.06, 0.0).normalize().scale(100.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)vehicle)).getBlockPos()));
            float x = (float)screenPos.x;
            float y = (float)screenPos.y;
            if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) {
                RenderHelper.preciseBlitWithColor(guiGraphics, HELI_BASE, k, l, 0.0f, 0.0f, i, j, i, j, color);
                float diffY = -Mth.lerp((float)partialTick, (float)vehicle.turretYRotO, (float)vehicle.getTurretYRot()) * 0.3f;
                float diffX = (float)(Mth.wrapDegrees((double)(-VehicleVecUtils.getXRotFromVector(vehicle.getBarrelVector(partialTick)) - (double)Mth.lerp((float)partialTick, (float)vehicle.xRotO, (float)vehicle.getXRot()))) * (double)0.072f);
                RenderHelper.preciseBlitWithColor(guiGraphics, HELI_DRIVER_ANGLE, k + diffY, l + diffX, 0.0f, 0.0f, i, j, i, j, color);
                RenderHelper.preciseBlitWithColor(guiGraphics, COMPASS, (float)screenWidth / 2.0f - 128.0f, 6.0f, 128.0f + 1.4222223f * vehicle.getYRot(), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f, color);
                poseStack.pushPose();
                poseStack.rotateAround(Axis.ZP.rotationDegrees(-vehicle.getRoll(partialTick)), (float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 0.0f);
                float pitch = vehicle.getPitch(partialTick);
                RenderHelper.preciseBlitWithColor(guiGraphics, HELI_LINE, (float)screenWidth / 2.0f - 128.0f, (float)screenHeight / 2.0f - 512.0f - 5.475f * pitch, 0.0f, 0.0f, 256.0f, 1024.0f, 256.0f, 1024.0f, color);
                poseStack.popPose();
                poseStack.pushPose();
                poseStack.rotateAround(Axis.ZP.rotationDegrees(vehicle.getRoll(partialTick)), (float)screenWidth / 2.0f, (float)screenHeight / 2.0f - 56.0f, 0.0f);
                RenderHelper.preciseBlitWithColor(guiGraphics, ROLL_IND, (float)screenWidth / 2.0f - 8.0f, (float)screenHeight / 2.0f - 88.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, color);
                poseStack.popPose();
                RenderHelper.preciseBlitWithColor(guiGraphics, HELI_POWER_RULER, (float)screenWidth / 2.0f + 100.0f, (float)screenHeight / 2.0f - 64.0f, 0.0f, 0.0f, 64.0f, 128.0f, 64.0f, 128.0f, color);
                float power = vehicle.getPower();
                lerpPower = Mth.lerp((float)(0.001f * partialTick), (float)lerpPower, (float)power);
                RenderHelper.preciseBlitWithColor(guiGraphics, HELI_POWER, (float)screenWidth / 2.0f + 130.0f, (float)screenHeight / 2.0f - 64.0f + 124.0f - power * 980.0f, 0.0f, 0.0f, 4.0f, power * 980.0f, 4.0f, power * 980.0f, color);
                lerpVy = (float)Mth.lerp((double)(0.021f * partialTick), (double)lerpVy, (double)(vehicle.getDeltaMovement().y() * 20.0));
                RenderHelper.preciseBlitWithColor(guiGraphics, HELI_VY_MOVE, (float)screenWidth / 2.0f + 138.0f, (float)screenHeight / 2.0f - 3.0f - Math.max((float)lerpVy, (float)-24.0f) * 2.5f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f, color);
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(lerpVy, "m/s")), screenWidth / 2 + 146, (int)((double)((float)screenHeight / 2.0f - 3.0f) - (double)Math.max((float)lerpVy, (float)-24.0f) * 2.5), lerpVy < -24.0f || (lerpVy < -10.0f || lerpVy < -1.0f && speed > 100.0) && height < 36.0 || speed > 40.0 && blockInWay < 72.0 ? -65536 : color, false);
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(vehicle.getY())), screenWidth / 2 + 104, screenHeight / 2, color, false);
                RenderHelper.preciseBlitWithColor(guiGraphics, SPEED_FRAME, (float)screenWidth / 2.0f - 144.0f, (float)screenHeight / 2.0f - 6.0f, 0.0f, 0.0f, 50.0f, 18.0f, 50.0f, 18.0f, color);
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(speed, "km/h")), screenWidth / 2 - 140, screenHeight / 2, color, false);
                if (vehicle.hasDecoy()) {
                    if (vehicle.getDecoyState().equals("READY")) {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.flare.ready").append((Component)Component.literal((String)(" [" + ModKeyMappings.RELEASE_DECOY.getKey().getDisplayName().getString() + "]"))), screenWidth / 2 - 160, screenHeight / 2 - 50, color, false);
                    } else {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.flare.reloading"), screenWidth / 2 - 160, screenHeight / 2 - 50, 0xFF0000, false);
                    }
                }
                Component component = vehicle.firstPersonAmmoComponent(data, (Player)player);
                int heat = vehicle.getWeaponHeat((LivingEntity)player);
                guiGraphics.drawString(mc.font, component, screenWidth / 2 - 160, screenHeight / 2 - 59, MathTool.getGradientColor(color, 0xFF0000, heat, 2), false);
                VehicleMainWeaponHudOverlay.renderEnergyInfo(vehicle, guiGraphics, screenWidth, screenHeight, mc.font);
                RenderHelper.preciseBlitWithColor(guiGraphics, CROSSHAIR_IND, x - 8.0f, y - 8.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, color);
                VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
            } else if (VectorUtil.canSee(pos)) {
                poseStack.pushPose();
                poseStack.rotateAround(Axis.ZP.rotationDegrees(vehicle.getRoll(partialTick)), x, y, 0.0f);
                RenderHelper.preciseBlit(guiGraphics, CROSSHAIR_3P, x - 8.0f, y - 8.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
                VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                poseStack.pushPose();
                poseStack.translate(x, y, 0.0f);
                poseStack.scale(0.75f, 0.75f, 1.0f);
                VehicleMainWeaponHudOverlay.renderWeaponInfoThird(guiGraphics, vehicle, (Player)player, data, mc.font);
                if (vehicle.hasDecoy()) {
                    if (vehicle.getDecoyState().equals("READY")) {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.flare.ready").append((Component)Component.literal((String)(" [" + ModKeyMappings.RELEASE_DECOY.getKey().getDisplayName().getString() + "]"))), 30, 1, -1, false);
                    } else {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.flare.reloading"), 30, 1, 0xFF0000, false);
                    }
                }
                poseStack.popPose();
                poseStack.popPose();
            }
            if (lerpVy < -16.0f) {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"SINK RATE\uff0cPULL UP!"), screenWidth / 2 - 53, screenHeight / 2 + 24, -65536, false);
                if (player.tickCount % 30 == 0) {
                    player.level().playLocalSound(player.getOnPos(), (SoundEvent)ModSounds.PULL_UP.get(), SoundSource.PLAYERS, 3.0f, 1.0f, false);
                }
            } else if ((lerpVy < -10.0f || lerpVy < -3.0f && speed > 100.0) && height < 36.0 || speed > 72.0 && blockInWay < 72.0) {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"TERRAIN TERRAIN"), screenWidth / 2 - 42, screenHeight / 2 + 24, -65536, false);
                if (player.tickCount % 30 == 0) {
                    player.level().playLocalSound(player.getOnPos(), (SoundEvent)ModSounds.TERRAIN.get(), SoundSource.PLAYERS, 3.0f, 1.0f, false);
                }
            }
            poseStack.popPose();
        }
    }
}

