/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.particle;

import com.atsuishio.superbwarfare.client.particle.CannonMuzzleFlareOption;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CannonMuzzleFlareParticle
extends TextureSheetParticle {
    public float fade;
    public int animationSpeed;
    public float sizeAdd;
    private final SpriteSet spriteSet;

    protected CannonMuzzleFlareParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet, float rCol, float gCol, float bCol, int life, float fade, int animationSpeed, float sizeAdd) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.35f, 0.35f);
        this.quadSize *= 11.0f;
        this.lifetime = Math.max(1, life + this.random.nextInt(1));
        this.gravity = -0.05f;
        this.hasPhysics = false;
        this.xd = vx * 0.6;
        this.yd = vy * 0.6;
        this.zd = vz * 0.6;
        this.setSpriteFromAge(spriteSet);
        this.rCol = rCol;
        this.gCol = gCol;
        this.bCol = bCol;
        this.roll = (float)Math.random() * 0.03141593f;
        this.fade = fade;
        this.animationSpeed = animationSpeed;
        this.sizeAdd = sizeAdd;
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            this.setSprite(this.spriteSet.get(Mth.clamp((int)(this.age / this.animationSpeed % 12 + 1), (int)0, (int)12), 12));
        }
        this.quadSize += this.sizeAdd;
        this.alpha *= this.fade;
        this.rCol *= 0.93f;
        this.gCol *= 0.93f;
        this.bCol *= 0.93f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Provider(SpriteSet spriteSet) implements ParticleProvider<CannonMuzzleFlareOption>
    {
        public Particle createParticle(CannonMuzzleFlareOption pType, @NotNull ClientLevel pLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CannonMuzzleFlareParticle(pLevel, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, pType.getRed(), pType.getGreen(), pType.getBlue(), pType.life(), pType.fade(), pType.getAnimationSpeed(), pType.sizeAdd());
        }
    }
}

