/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.particle;

import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CustomCloudParticle
extends TextureSheetParticle {
    protected boolean cooldown;
    protected boolean light;
    private final SpriteSet spriteSet;

    protected CustomCloudParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet, float rCol, float gCol, float bCol, int life, float size, float gravity, boolean cooldown, boolean light) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.4f, 0.4f);
        this.quadSize *= size;
        this.lifetime = Math.max(1, life + (this.random.nextInt(life) - (int)(0.1 * (double)life)));
        this.gravity = gravity;
        this.hasPhysics = false;
        this.xd = vx * 0.01;
        this.yd = vy * 0.01;
        this.zd = vz * 0.01;
        this.setSpriteFromAge(spriteSet);
        this.rCol = rCol;
        this.gCol = gCol;
        this.bCol = bCol;
        this.cooldown = cooldown;
        this.light = light;
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return this.light ? ParticleRenderType.PARTICLE_SHEET_LIT : ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        if (this.cooldown) {
            this.rCol *= 0.985f;
            this.gCol *= 0.985f;
            this.bCol *= 0.985f;
        }
        if (!this.removed) {
            this.setSprite(this.spriteSet.get(Math.min(this.age / 8 + 1, 8), 8));
        }
        if (this.age++ < this.lifetime && !(this.alpha <= 0.0f)) {
            this.alpha = 1.0f - (float)this.age / (float)this.lifetime;
        } else {
            this.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<CustomCloudOption> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(CustomCloudOption pType, @NotNull ClientLevel pLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CustomCloudParticle(pLevel, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, pType.getRed(), pType.getGreen(), pType.getBlue(), pType.getLife(), pType.getSize(), pType.getGravity(), pType.getCooldown(), pType.getLight());
        }
    }
}

