/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.renderer.ModRenderTypes;
import com.atsuishio.superbwarfare.entity.projectile.AbstractLaserEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractLaserEntityRenderer<T extends AbstractLaserEntity>
extends EntityRenderer<T> {
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private final float quadRadius;
    private final float beamRadius;

    public AbstractLaserEntityRenderer(EntityRendererProvider.Context context, float quadRadius, float beamRadius) {
        super(context);
        this.quadRadius = quadRadius;
        this.beamRadius = beamRadius;
    }

    @NotNull
    public abstract ResourceLocation getTextureLocation(@NotNull T var1);

    public void render(T beam, float entityYaw, float delta, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        double collidePosX = ((AbstractLaserEntity)((Object)beam)).prevCollidePosX + (((AbstractLaserEntity)((Object)beam)).collidePosX - ((AbstractLaserEntity)((Object)beam)).prevCollidePosX) * (double)delta;
        double collidePosY = ((AbstractLaserEntity)((Object)beam)).prevCollidePosY + (((AbstractLaserEntity)((Object)beam)).collidePosY - ((AbstractLaserEntity)((Object)beam)).prevCollidePosY) * (double)delta;
        double collidePosZ = ((AbstractLaserEntity)((Object)beam)).prevCollidePosZ + (((AbstractLaserEntity)((Object)beam)).collidePosZ - ((AbstractLaserEntity)((Object)beam)).prevCollidePosZ) * (double)delta;
        double posX = ((AbstractLaserEntity)((Object)beam)).xo + (beam.getX() - ((AbstractLaserEntity)((Object)beam)).xo) * (double)delta;
        double posY = ((AbstractLaserEntity)((Object)beam)).yo + (beam.getY() - ((AbstractLaserEntity)((Object)beam)).yo) * (double)delta;
        double posZ = ((AbstractLaserEntity)((Object)beam)).zo + (beam.getZ() - ((AbstractLaserEntity)((Object)beam)).zo) * (double)delta;
        float yaw = ((AbstractLaserEntity)((Object)beam)).preYaw + (((AbstractLaserEntity)((Object)beam)).yaw - ((AbstractLaserEntity)((Object)beam)).preYaw) * delta;
        float pitch = ((AbstractLaserEntity)((Object)beam)).prePitch + (((AbstractLaserEntity)((Object)beam)).pitch - ((AbstractLaserEntity)((Object)beam)).prePitch) * delta;
        float length = (float)Math.sqrt(Math.pow(collidePosX - posX, 2.0) + Math.pow(collidePosY - posY, 2.0) + Math.pow(collidePosZ - posZ, 2.0));
        int frame = Mth.floor((float)(((float)(((AbstractLaserEntity)((Object)beam)).ticker.getTick() - 1) + delta) * 2.0f));
        if (frame < 0) {
            frame = 6;
        }
        if (!((AbstractLaserEntity)((Object)beam)).isAccumulating()) {
            return;
        }
        VertexConsumer vertex$builder = bufferIn.getBuffer(ModRenderTypes.LASER.apply(this.getTextureLocation(beam)));
        this.renderStart(beam, frame, matrixStackIn, vertex$builder, delta, packedLightIn);
        this.renderBeam(length, 57.295776f * yaw, 57.295776f * pitch, frame, matrixStackIn, vertex$builder, packedLightIn);
        matrixStackIn.pushPose();
        matrixStackIn.translate(collidePosX - posX, collidePosY - posY, collidePosZ - posZ);
        this.renderEnd(beam, frame, ((AbstractLaserEntity)((Object)beam)).blockSide, matrixStackIn, vertex$builder, delta, packedLightIn);
        matrixStackIn.popPose();
    }

    protected void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn, boolean inGround) {
        float minU = 0.0f + 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        float SIZE = this.quadRadius + (inGround ? 0.2f : 0.0f);
        PoseStack.Pose pose = matrixStackIn.last();
        Matrix4f matrix4f = pose.pose();
        Matrix3f matrix3f = pose.normal();
        this.drawVertex(matrix4f, matrix3f, pose, builder, -SIZE, -SIZE, 0.0f, minU, minV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, pose, builder, -SIZE, SIZE, 0.0f, minU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, pose, builder, SIZE, SIZE, 0.0f, maxU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, pose, builder, SIZE, -SIZE, 0.0f, maxU, minV, packedLightIn);
    }

    protected void renderStart(T entity, int frame, PoseStack matrixStackIn, VertexConsumer builder, float delta, int packedLightIn) {
        matrixStackIn.pushPose();
        Quaternionf quaternionf = this.entityRenderDispatcher.cameraOrientation();
        matrixStackIn.mulPose(quaternionf);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, false);
        matrixStackIn.popPose();
    }

    protected void renderEnd(T entity, int frame, Direction side, PoseStack matrixStackIn, VertexConsumer builder, float delta, int packedLightIn) {
        matrixStackIn.pushPose();
        Quaternionf quaternionf = this.entityRenderDispatcher.cameraOrientation();
        matrixStackIn.mulPose(quaternionf);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, false);
        matrixStackIn.popPose();
        if (side == null) {
            return;
        }
        matrixStackIn.pushPose();
        Quaternionf rotation = side.getRotation();
        rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        matrixStackIn.mulPose(rotation);
        matrixStackIn.translate(0.0f, 0.0f, -0.01f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, true);
        matrixStackIn.popPose();
    }

    protected void renderBeam(float length, float yaw, float pitch, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(yaw - 90.0f));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(-pitch));
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Minecraft.getInstance().gameRenderer.getMainCamera().getXRot() + 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(-Minecraft.getInstance().gameRenderer.getMainCamera().getXRot() - 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(-Minecraft.getInstance().gameRenderer.getMainCamera().getXRot() + 180.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.popPose();
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(-Minecraft.getInstance().gameRenderer.getMainCamera().getXRot() - 180.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.popPose();
        matrixStackIn.popPose();
    }

    protected void drawBeam(float length, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose pose = matrixStackIn.last();
        Matrix4f matrix4f = pose.pose();
        Matrix3f matrix3f = pose.normal();
        float offset = 0.0f;
        float size = this.beamRadius;
        this.drawVertex(matrix4f, matrix3f, pose, builder, -size, offset, 0.0f, minU, minV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, pose, builder, -size, length, 0.0f, minU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, pose, builder, size, length, 0.0f, maxU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, pose, builder, size, offset, 0.0f, maxU, minV, packedLightIn);
    }

    protected void drawVertex(Matrix4f matrix, Matrix3f normals, PoseStack.Pose pose, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, int packedLightIn) {
        vertexBuilder.addVertex(matrix, offsetX, offsetY, offsetZ).setColor(1, 1, 1, 1).setUv(textureX, textureY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

