/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.layer.vehicle.DroneLayer;
import com.atsuishio.superbwarfare.client.model.entity.DroneModel;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class DroneRenderer
extends GeoEntityRenderer<DroneEntity> {
    private String entityNameCache = "";
    private Entity entityCache = null;
    private int attachedTick = Integer.MAX_VALUE;

    public DroneRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new DroneModel());
        this.addRenderLayer(new DroneLayer((GeoRenderer<DroneEntity>)this));
        this.shadowRadius = 0.2f;
    }

    public RenderType getRenderType(DroneEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void defaultRender(PoseStack poseStack, DroneEntity animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-animatable.getYaw(partialTick)));
        poseStack.mulPose(Axis.XP.rotationDegrees(animatable.getBodyPitch(partialTick)));
        poseStack.mulPose(Axis.ZP.rotationDegrees(animatable.getRoll(partialTick)));
        super.defaultRender(poseStack, (GeoAnimatable)animatable, bufferSource, renderType, buffer, yaw, partialTick, packedLight);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            boolean firstPerson;
            ItemStack stack = player.getMainHandItem();
            CompoundTag tag = NBTTool.getTag(stack);
            DroneEntity drone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"));
            boolean bl = firstPerson = Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON || Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK;
            if (!(stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked") && drone != null && drone.getUUID() == animatable.getUUID() && firstPerson)) {
                this.renderAttachments(animatable, yaw, partialTick, poseStack, bufferSource, packedLight);
            }
        }
        poseStack.popPose();
    }

    private void renderAttachments(DroneEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Entity renderEntity;
        SynchedEntityData data = entity.getEntityData();
        String attached = (String)data.get(DroneEntity.DISPLAY_ENTITY);
        if (attached.isEmpty()) {
            return;
        }
        if (this.entityNameCache.equals(attached) && this.entityCache != null) {
            renderEntity = this.entityCache;
        } else {
            renderEntity = EntityType.byString((String)attached).map(type -> type.create(entity.level())).orElse(null);
            if (renderEntity == null) {
                return;
            }
            CompoundTag tag = (CompoundTag)data.get(DroneEntity.DISPLAY_ENTITY_TAG);
            if (!tag.isEmpty()) {
                renderEntity.load(tag);
            }
            this.entityNameCache = attached;
            this.entityCache = renderEntity;
            this.attachedTick = entity.tickCount;
        }
        List displayData = (List)data.get(DroneEntity.DISPLAY_DATA);
        renderEntity.tickCount = ((Float)displayData.get(11)).floatValue() >= 0.0f ? ((Float)displayData.get(11)).intValue() : entity.tickCount - this.attachedTick;
        float[] scale = new float[]{((Float)displayData.get(0)).floatValue(), ((Float)displayData.get(1)).floatValue(), ((Float)displayData.get(2)).floatValue()};
        float[] offset = new float[]{((Float)displayData.get(3)).floatValue(), ((Float)displayData.get(4)).floatValue(), ((Float)displayData.get(5)).floatValue()};
        float[] rotation = new float[]{((Float)displayData.get(6)).floatValue(), ((Float)displayData.get(7)).floatValue(), ((Float)displayData.get(8)).floatValue()};
        Float xLength = (Float)displayData.get(9);
        Float yLength = (Float)displayData.get(10);
        for (int i = 0; i < (Integer)data.get(VehicleEntity.AMMO); ++i) {
            float z;
            float x;
            if ((Integer)data.get(DroneEntity.MAX_AMMO) == 1) {
                x = 0.0f;
                z = 0.0f;
            } else {
                x = xLength.floatValue() / 2.0f * (float)(i % 2 == 0 ? 1 : -1);
                int rows = (Integer)data.get(DroneEntity.MAX_AMMO) / 2;
                int row = i / 2;
                if (rows < 2) {
                    z = 0.0f;
                } else {
                    float rowLength = yLength.floatValue() / (float)rows;
                    z = -yLength.floatValue() / 2.0f + rowLength * (float)row;
                }
            }
            poseStack.pushPose();
            poseStack.translate(x + offset[0], offset[1], z + offset[2]);
            poseStack.scale(scale[0], scale[1], scale[2]);
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation[2]));
            poseStack.mulPose(Axis.XP.rotationDegrees(rotation[0]));
            poseStack.mulPose(Axis.ZP.rotationDegrees(rotation[1]));
            this.entityRenderDispatcher.render(renderEntity, 0.0, 0.0, 0.0, entityYaw, partialTicks, poseStack, buffer, packedLight);
            poseStack.popPose();
        }
    }
}

