/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.ClientRenderHandler;
import com.atsuishio.superbwarfare.client.layer.projectile.ProjectileEntityInsideLayer;
import com.atsuishio.superbwarfare.client.layer.projectile.ProjectileEntityLayer;
import com.atsuishio.superbwarfare.client.model.entity.ProjectileEntityModel;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class ProjectileEntityRenderer
extends GeoEntityRenderer<ProjectileEntity> {
    public ProjectileEntityRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new ProjectileEntityModel());
        this.shadowRadius = 0.0f;
        this.addRenderLayer(new ProjectileEntityLayer((GeoRenderer<ProjectileEntity>)this));
        this.addRenderLayer(new ProjectileEntityInsideLayer((GeoRenderer<ProjectileEntity>)this));
    }

    public RenderType getRenderType(ProjectileEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.energySwirl((ResourceLocation)this.getTextureLocation((Entity)animatable), (float)1.0f, (float)1.0f);
    }

    public void preRender(PoseStack poseStack, ProjectileEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        if (entity.tickCount > 1 && !entity.isInWater()) {
            super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        }
    }

    public void defaultRender(PoseStack poseStack, ProjectileEntity entityIn, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        if (entityIn.tickCount > 1 && !entityIn.isInWater()) {
            poseStack.pushPose();
            ClientRenderHandler.transformVirtualRenderPosition(poseStack, entityIn, partialTick);
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)entityIn.yRotO, (float)entityIn.getYRot()) - 90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f + Mth.lerp((float)partialTick, (float)entityIn.xRotO, (float)entityIn.getXRot())));
            super.defaultRender(poseStack, (GeoAnimatable)entityIn, bufferSource, renderType, buffer, yaw, partialTick, packedLight);
            poseStack.popPose();
        }
    }

    protected float getDeathMaxRotation(ProjectileEntity entityLivingBaseIn) {
        return 0.0f;
    }
}

