/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.gun;

import com.atsuishio.superbwarfare.client.ItemModelHelper;
import com.atsuishio.superbwarfare.client.animation.AnimationHelper;
import com.atsuishio.superbwarfare.client.model.item.M98bItemModel;
import com.atsuishio.superbwarfare.client.renderer.CustomGunRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.item.gun.sniper.M98bItem;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.GeoBone;

public class M98bItemRenderer
extends CustomGunRenderer<M98bItem> {
    public M98bItemRenderer() {
        super(new M98bItemModel());
    }

    public void renderRecursively(PoseStack stack, M98bItem animatable, GeoBone bone, RenderType type, MultiBufferSource buffer, VertexConsumer bufferIn, boolean isReRender, float partialTick, int packedLightIn, int packedOverlayIn, int color) {
        Minecraft mc = Minecraft.getInstance();
        String name = bone.getName();
        boolean renderingArms = false;
        if (name.equals("Lefthand") || name.equals("Righthand")) {
            bone.setHidden(true);
            renderingArms = true;
        } else {
            bone.setHidden(false);
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack.getItem() instanceof GunItem && GeoItem.getId((ItemStack)itemStack) == this.getInstanceId(animatable)) {
            if (this.renderPerspective == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || this.renderPerspective == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                AnimationHelper.handleShootFlare(name, stack, itemStack, bone, buffer, packedLightIn);
                ItemModelHelper.handleGunAttachments(bone, itemStack, name);
                if (this.renderPerspective == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                    GunData data = GunData.from(itemStack);
                    if (data.attachment.get(AttachmentType.SCOPE) == 2 && !NBTTool.getTag(itemStack).getBoolean("ScopeAlt") && bone.getName().endsWith("_hide")) {
                        bone.setHidden(ClientEventHandler.zoomPos > 0.7 && ClientEventHandler.zoom);
                    }
                    if (data.attachment.get(AttachmentType.SCOPE) == 3 && bone.getName().endsWith("_hide3")) {
                        bone.setHidden(ClientEventHandler.zoomPos > 0.7 && ClientEventHandler.zoom);
                    }
                    int scopeType = data.attachment.get(AttachmentType.SCOPE);
                    switch (scopeType) {
                        case 1: {
                            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.275, 30.0, 1.2f, 255, 0, 0, 255, "dot", false);
                            break;
                        }
                        case 2: {
                            if (NBTTool.getTag(itemStack).getBoolean("ScopeAlt")) {
                                AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.34, 30.0, 0.18f, 255, 0, 0, 255, "delta", false);
                                break;
                            }
                            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.294, 13.0, 0.75f, 255, 0, 0, 255, "hamr", true);
                            break;
                        }
                        case 3: {
                            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.29, 27.0, 5.0f, 255, 0, 0, 255, "sniper", true);
                        }
                    }
                }
            } else {
                ItemModelHelper.hideAllAttachments(bone, name);
            }
        } else {
            ItemModelHelper.hideAllAttachments(bone, name);
        }
        if (renderingArms) {
            AnimationHelper.renderArms(player, this.renderPerspective, stack, name, bone, buffer, type, packedLightIn, false);
        }
        super.renderRecursively(stack, (Item)animatable, bone, type, buffer, bufferIn, isReRender, partialTick, packedLightIn, packedOverlayIn, color);
    }
}

