/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.menu.ReforgingTableMenu;
import com.atsuishio.superbwarfare.network.message.send.GunReforgeMessage;
import com.atsuishio.superbwarfare.network.message.send.SetPerkLevelMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ReforgingTableScreen
extends AbstractContainerScreen<ReforgingTableMenu> {
    private static final ResourceLocation TEXTURE = Mod.loc("textures/gui/reforging_table.png");

    public ReforgingTableScreen(ReforgingTableMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 176;
        this.imageHeight = 177;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 200, 200);
        RenderSystem.disableBlend();
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int ammoPerkLevel = ((ReforgingTableMenu)this.menu).ammoPerkLevel.get();
        int funcPerkLevel = ((ReforgingTableMenu)this.menu).funcPerkLevel.get();
        int damagePerkLevel = ((ReforgingTableMenu)this.menu).damagePerkLevel.get();
        if (ammoPerkLevel > 0) {
            this.renderNumber(pGuiGraphics, this.leftPos + 136, this.topPos + 31, 1, 178, ammoPerkLevel);
        }
        if (funcPerkLevel > 0) {
            this.renderNumber(pGuiGraphics, this.leftPos + 146, this.topPos + 31, 1, 184, funcPerkLevel);
        }
        if (damagePerkLevel > 0) {
            this.renderNumber(pGuiGraphics, this.leftPos + 156, this.topPos + 31, 1, 190, damagePerkLevel);
        }
        int upgradePoint = ((ReforgingTableMenu)this.menu).availableLevel();
        this.renderNumber(pGuiGraphics, this.leftPos + 43, this.topPos + 20, 51, 178, upgradePoint);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderNumber(GuiGraphics guiGraphics, int x, int y, int u, int v, int number) {
        int g = number / 10;
        int s = number % 10;
        guiGraphics.blit(TEXTURE, x, y, (float)(u + 5 * g), (float)v, 5, 5, 200, 200);
        guiGraphics.blit(TEXTURE, x + 4, y, (float)(u + 5 * s), (float)v, 5, 5, 200, 200);
    }

    protected void init() {
        super.init();
        this.titleLabelX = 8;
        this.titleLabelY = 2;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = 85;
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        ReforgeButton button = new ReforgeButton(i + 124, j + 70);
        UpgradeButton ammoUpgrade = new UpgradeButton(i + 98, j + 21, Perk.Type.AMMO);
        DowngradeButton ammoDowngrade = new DowngradeButton(i + 69, j + 21, Perk.Type.AMMO);
        UpgradeButton funcUpgrade = new UpgradeButton(i + 98, j + 41, Perk.Type.FUNCTIONAL);
        DowngradeButton funcDowngrade = new DowngradeButton(i + 69, j + 41, Perk.Type.FUNCTIONAL);
        UpgradeButton damageUpgrade = new UpgradeButton(i + 98, j + 61, Perk.Type.DAMAGE);
        DowngradeButton damageDowngrade = new DowngradeButton(i + 69, j + 61, Perk.Type.DAMAGE);
        this.addRenderableWidget((GuiEventListener)button);
        this.addRenderableWidget((GuiEventListener)ammoUpgrade);
        this.addRenderableWidget((GuiEventListener)ammoDowngrade);
        this.addRenderableWidget((GuiEventListener)funcUpgrade);
        this.addRenderableWidget((GuiEventListener)funcDowngrade);
        this.addRenderableWidget((GuiEventListener)damageUpgrade);
        this.addRenderableWidget((GuiEventListener)damageDowngrade);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ReforgeButton
    extends AbstractButton {
        protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), this.isHovered() ? 81.0f : 51.0f, 184.0f, 29, 15, 200, 200);
        }

        public ReforgeButton(int pX, int pY) {
            super(pX, pY, 40, 16, (Component)Component.empty());
        }

        public void onPress() {
            PacketDistributor.sendToServer((CustomPacketPayload)GunReforgeMessage.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class UpgradeButton
    extends AbstractButton {
        public Perk.Type type;

        public UpgradeButton(int pX, int pY, Perk.Type type) {
            super(pX, pY, 9, 9, (Component)Component.empty());
            this.type = type;
        }

        protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), 187.0f, this.isHovered() ? 10.0f : 0.0f, 9, 9, 200, 200);
        }

        public void onPress() {
            if (((ReforgingTableMenu)ReforgingTableScreen.this.menu).getPerkItemBySlot(this.type) == ItemStack.EMPTY) {
                return;
            }
            switch (this.type) {
                case AMMO: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).menu).ammoPerkLevel.get() < 20) break;
                    return;
                }
                case FUNCTIONAL: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).menu).funcPerkLevel.get() < 20) break;
                    return;
                }
                case DAMAGE: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).menu).damagePerkLevel.get() < 20) break;
                    return;
                }
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new SetPerkLevelMessage(this.type.ordinal(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class DowngradeButton
    extends AbstractButton {
        public Perk.Type type;

        protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), 177.0f, this.isHovered() ? 10.0f : 0.0f, 9, 9, 200, 200);
        }

        public DowngradeButton(int pX, int pY, Perk.Type type) {
            super(pX, pY, 12, 12, (Component)Component.empty());
            this.type = type;
        }

        public void onPress() {
            if (((ReforgingTableMenu)ReforgingTableScreen.this.menu).getPerkItemBySlot(this.type) == ItemStack.EMPTY) {
                return;
            }
            switch (this.type) {
                case AMMO: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).menu).ammoPerkLevel.get() > 1) break;
                    return;
                }
                case FUNCTIONAL: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).menu).funcPerkLevel.get() > 1) break;
                    return;
                }
                case DAMAGE: {
                    if (((ReforgingTableMenu)((ReforgingTableScreen)ReforgingTableScreen.this).menu).damagePerkLevel.get() > 1) break;
                    return;
                }
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new SetPerkLevelMessage(this.type.ordinal(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

