/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.component.CellImageComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ClientCellImageTooltip
implements ClientTooltipComponent {
    protected final int width;
    protected final int height;
    protected final ItemStack stack;

    public ClientCellImageTooltip(CellImageComponent tooltip) {
        this.width = tooltip.width;
        this.height = tooltip.height;
        this.stack = tooltip.stack;
    }

    public void renderImage(@NotNull Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        if (this.shouldRenderEnergyTooltip()) {
            this.renderEnergyTooltip(font, guiGraphics, x, y);
        }
        guiGraphics.pose().popPose();
    }

    protected boolean shouldRenderEnergyTooltip() {
        return this.stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
    }

    protected void renderEnergyTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getEnergyComponent(), x, y, 0xFFFFFF);
    }

    protected Component getEnergyComponent() {
        int i;
        IEnergyStorage storage = (IEnergyStorage)this.stack.getCapability(Capabilities.EnergyStorage.ITEM);
        assert (storage != null);
        int energy = storage.getEnergyStored();
        int maxEnergy = storage.getMaxEnergyStored();
        float percentage = Mth.clamp((float)((float)energy / (float)maxEnergy), (float)0.0f, (float)1.0f);
        MutableComponent component = Component.empty();
        ChatFormatting format = percentage <= 0.2f ? ChatFormatting.RED : (percentage <= 0.6f ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
        int count = (int)(percentage * 50.0f);
        for (i = 0; i < count; ++i) {
            component.append((Component)Component.literal((String)"|").withStyle(format));
        }
        component.append((Component)Component.empty().withStyle(ChatFormatting.RESET));
        for (i = 0; i < 50 - count; ++i) {
            component.append((Component)Component.literal((String)"|").withStyle(ChatFormatting.GRAY));
        }
        component.append((Component)Component.literal((String)(" " + energy + "/" + maxEnergy + " FE")).withStyle(ChatFormatting.GRAY));
        return component;
    }

    public int getHeight() {
        int height = 20;
        if (this.shouldRenderEnergyTooltip()) {
            height -= 10;
        }
        return height;
    }

    public int getWidth(@NotNull Font font) {
        int width = Screen.hasShiftDown() ? Math.max(this.width, 20) : 20;
        if (this.shouldRenderEnergyTooltip()) {
            width = Math.max(width, font.width(this.getEnergyComponent().getVisualOrderText()) + 10);
        }
        return width;
    }
}

