/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.ClientGunImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.tools.FormatTool;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ClientSentinelImageTooltip
extends ClientGunImageTooltip {
    public ClientSentinelImageTooltip(GunImageComponent tooltip) {
        super(tooltip);
    }

    @Override
    protected Component getDamageComponent() {
        IEnergyStorage cap = (IEnergyStorage)this.stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap != null && cap.getEnergyStored() > 0) {
            DefaultGunData computed = this.data.compute();
            double damage = computed.damage;
            double explosionDamage = computed.explosionDamage;
            Object dmgStr = FormatTool.format1D(damage);
            if (computed.projectileAmount > 1) {
                dmgStr = (String)dmgStr + " * " + computed.projectileAmount;
            }
            MutableComponent component = Component.translatable((String)"des.superbwarfare.guns.damage").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)dmgStr).withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.BOLD));
            if (explosionDamage > 0.0) {
                Object expDmgStr = FormatTool.format1D(explosionDamage);
                if (computed.projectileAmount > 1) {
                    expDmgStr = (String)expDmgStr + " * " + computed.projectileAmount;
                }
                component = component.append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(" + " + (String)expDmgStr)).withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.BOLD));
            }
            return component;
        }
        return super.getDamageComponent();
    }
}

