/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.data.ComplexJsonResourceReloadListener;
import com.atsuishio.superbwarfare.data.ModColor;
import com.atsuishio.superbwarfare.data.ObjectToList;
import com.atsuishio.superbwarfare.data.ResourceLocationAdapter;
import com.atsuishio.superbwarfare.data.SoundEventAdapter;
import com.atsuishio.superbwarfare.data.StringOrVec3;
import com.atsuishio.superbwarfare.data.StringToObject;
import com.atsuishio.superbwarfare.data.Vec2Adapter;
import com.atsuishio.superbwarfare.data.Vec3Adapter;
import com.atsuishio.superbwarfare.data.vehicle.subdata.CollisionLevel;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="superbwarfare")
public class DataLoader {
    public static final Gson GSON = DataLoader.createCommonBuilder().create();
    public static final LoadingCache<Object, JsonObject> JSON_OBJECT_CACHE = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Object, JsonObject>(){

        @NotNull
        public JsonObject load(@NotNull Object object) {
            return GSON.toJsonTree(object).getAsJsonObject();
        }
    });
    private static final Map<String, GeneralData<?>> LOADED_DATA = new HashMap();
    private static final Map<String, GeneralData<?>> LOADED_RESOURCE = new HashMap();
    public static final ComplexJsonResourceReloadListener SERVER_LISTENER = new ComplexJsonResourceReloadListener(LOADED_DATA);
    public static final ComplexJsonResourceReloadListener CLIENT_LISTENER = new ComplexJsonResourceReloadListener(LOADED_RESOURCE);

    @SubscribeEvent
    public static void addDataReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)SERVER_LISTENER);
    }

    public static <T> DataMap<T> createData(String directory, Class<T> clazz) {
        return DataLoader.createData(directory, clazz, null);
    }

    public static <T> DataMap<T> createData(String directory, Class<T> clazz, @Nullable Consumer<Map<String, Object>> onReload) {
        if (LOADED_DATA.containsKey(directory)) {
            return DataLoader.LOADED_DATA.get((Object)directory).proxyMap;
        }
        DataMap proxyMap = new DataMap(directory, LOADED_DATA);
        LOADED_DATA.put(directory, new GeneralData(clazz, proxyMap, new HashMap<String, Object>(), onReload));
        return proxyMap;
    }

    public static <T> DataMap<T> createResource(String directory, Class<T> clazz) {
        return DataLoader.createResource(directory, clazz, null);
    }

    public static <T> DataMap<T> createResource(String directory, Class<T> clazz, @Nullable Consumer<Map<String, Object>> onReload) {
        if (LOADED_RESOURCE.containsKey(directory)) {
            return DataLoader.LOADED_RESOURCE.get((Object)directory).proxyMap;
        }
        DataMap proxyMap = new DataMap(directory, LOADED_RESOURCE);
        LOADED_RESOURCE.put(directory, new GeneralData(clazz, proxyMap, new HashMap<String, Object>(), onReload));
        return proxyMap;
    }

    public static GsonBuilder createCommonBuilder() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).setLenient().serializeSpecialFloatingPointValues().registerTypeAdapter(Vec2.class, (Object)new Vec2Adapter()).registerTypeAdapter(Vec3.class, (Object)new Vec3Adapter()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationAdapter()).registerTypeAdapter(SoundEvent.class, (Object)new SoundEventAdapter()).registerTypeAdapter(ModColor.class, (Object)new ModColor.ModColorAdapter()).registerTypeAdapter(StringOrVec3.class, (Object)new StringOrVec3.StringOrVec3Adapter()).registerTypeAdapter(CollisionLevel.Limit.class, (Object)new CollisionLevel.LimitAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new ObjectToList.AdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new StringToObject.AdapterFactory());
    }

    public static Object processValue(Object value) {
        if (value instanceof ObjectToList) {
            ObjectToList otl = (ObjectToList)value;
            return otl.list.stream().map(DataLoader::processValue).toList();
        }
        if (value instanceof StringToObject) {
            StringToObject sto = (StringToObject)value;
            return DataLoader.processValue(sto.value);
        }
        return value;
    }

    public static class DataMap<T>
    extends HashMap<String, T> {
        private final String directory;
        private final Map<String, GeneralData<?>> loadedData;

        private DataMap(String directory, Map<String, GeneralData<?>> loadedData) {
            this.directory = directory;
            this.loadedData = loadedData;
        }

        @Override
        public int size() {
            if (!this.loadedData.containsKey(this.directory)) {
                return 0;
            }
            return this.loadedData.get((Object)this.directory).data.size();
        }

        @Override
        public boolean isEmpty() {
            if (!this.loadedData.containsKey(this.directory)) {
                return true;
            }
            return this.loadedData.get((Object)this.directory).data.isEmpty();
        }

        @Override
        public T get(Object key) {
            if (!this.loadedData.containsKey(this.directory)) {
                return null;
            }
            return (T)this.loadedData.get((Object)this.directory).data.get(key);
        }

        @Override
        public T getOrDefault(Object key, T defaultValue) {
            T value = this.get(key);
            return value == null ? defaultValue : value;
        }

        public T getOrElseGet(Object key, Supplier<T> supplier) {
            T value = this.get(key);
            return value == null ? supplier.get() : value;
        }

        @Override
        public boolean containsKey(Object key) {
            if (!this.loadedData.containsKey(this.directory)) {
                return false;
            }
            return this.loadedData.get((Object)this.directory).data.containsKey(key);
        }

        @Override
        public T put(String key, T value) {
            return (T)this.loadedData.get((Object)this.directory).data.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends T> m) {
            this.loadedData.get((Object)this.directory).data.putAll(m);
        }

        @Override
        public T remove(Object key) {
            return (T)this.loadedData.get((Object)this.directory).data.remove(key);
        }

        @Override
        public void clear() {
            this.loadedData.get((Object)this.directory).data.clear();
        }

        @Override
        public boolean containsValue(Object value) {
            if (!this.loadedData.containsKey(this.directory)) {
                return false;
            }
            return this.loadedData.get((Object)this.directory).data.containsValue(value);
        }

        @Override
        @NotNull
        public Set<String> keySet() {
            if (!this.loadedData.containsKey(this.directory)) {
                return Set.of();
            }
            return this.loadedData.get((Object)this.directory).data.keySet();
        }

        @Override
        @NotNull
        public Collection<T> values() {
            if (!this.loadedData.containsKey(this.directory)) {
                return Set.of();
            }
            return this.loadedData.get((Object)this.directory).data.values().stream().map(v -> v).toList();
        }

        @Override
        @NotNull
        public Set<Map.Entry<String, T>> entrySet() {
            if (!this.loadedData.containsKey(this.directory)) {
                return Set.of();
            }
            return this.loadedData.get((Object)this.directory).data.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry((String)e.getKey(), e.getValue())).collect(Collectors.toCollection(HashSet::new));
        }

        public String getDirectory() {
            return this.directory;
        }
    }

    public record GeneralData<T>(Class<?> type, DataMap<T> proxyMap, HashMap<String, Object> data, @Nullable Consumer<Map<String, Object>> onReload) {
    }

    @EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
    static class ClientReloadListener {
        ClientReloadListener() {
        }

        @SubscribeEvent
        public static void addResourceReloadListener(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)CLIENT_LISTENER);
        }
    }
}

