/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.Mod;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SoundEventAdapter
extends TypeAdapter<SoundEvent> {
    private static final Pattern PATTERN = Pattern.compile("^(?<location>\\S+)( (?<range>-?\\d*(\\.(?=\\d))?\\d*))?$", 2);

    public void write(JsonWriter out, SoundEvent value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(value.getLocation().toString());
    }

    public SoundEvent read(JsonReader in) throws IOException {
        ResourceLocation location;
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (in.peek() != JsonToken.STRING) {
            throw new IllegalStateException("excepted SoundEvent to be String but was " + String.valueOf(in.peek()));
        }
        String str = in.nextString().trim();
        Matcher matcher = PATTERN.matcher(str);
        if (!matcher.matches()) {
            Mod.LOGGER.error("invalid SoundEvent {}!", (Object)str);
            return null;
        }
        Object locationGroup = matcher.group("location");
        if (!((String)locationGroup).contains(":")) {
            locationGroup = "minecraft:" + (String)locationGroup;
        }
        if ((location = ResourceLocation.tryParse((String)locationGroup)) == null) {
            Mod.LOGGER.error("invalid resource location for SoundEvent {}!", (Object)str);
            return null;
        }
        String rangeGroup = matcher.group("range");
        if (rangeGroup != null) {
            float range;
            try {
                range = Float.parseFloat(rangeGroup);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("invalid range for SoundEvent {}!", (Object)str);
                return null;
            }
            return SoundEvent.createFixedRangeEvent((ResourceLocation)location, (float)range);
        }
        return SoundEvent.createVariableRangeEvent((ResourceLocation)location);
    }
}

