/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.container;

import com.atsuishio.superbwarfare.Mod;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class ContainerDataManager
extends SimpleJsonResourceReloadListener {
    public static ContainerDataManager INSTANCE = new ContainerDataManager();
    private static final Gson GSON = new Gson();
    private static final String DIRECTORY = "sbw/containers";
    private final Map<ResourceLocation, List<Pair<String, Integer>>> containerData = new HashMap<ResourceLocation, List<Pair<String, Integer>>>();

    public ContainerDataManager() {
        super(GSON, DIRECTORY);
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        INSTANCE = new ContainerDataManager();
        event.addListener((PreparableReloadListener)INSTANCE);
    }

    @ParametersAreNonnullByDefault
    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager manager, ProfilerFiller profiler) {
        this.containerData.clear();
        pObject.forEach((id, json) -> {
            try {
                JsonObject obj = json.getAsJsonObject();
                ArrayList<Pair> list = new ArrayList<Pair>();
                JsonArray array = obj.getAsJsonArray("List");
                for (JsonElement arr : array) {
                    if (arr.isJsonObject()) {
                        JsonObject obj2 = arr.getAsJsonObject();
                        String type = obj2.get("Type").getAsString();
                        int weight = obj2.get("Weight").getAsInt();
                        list.add(Pair.of((Object)type, (Object)weight));
                        continue;
                    }
                    list.add(Pair.of((Object)arr.getAsString(), (Object)1));
                }
                this.containerData.put((ResourceLocation)id, (List<Pair<String, Integer>>)list);
            }
            catch (Exception e) {
                Mod.LOGGER.error("Failed to load container data for {}", id);
            }
        });
    }

    public Optional<List<Pair<String, Integer>>> getEntityTypes(ResourceLocation id) {
        return Optional.ofNullable(this.containerData.get(id));
    }
}

