/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun;

import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.init.ModItems;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum Ammo {
    HANDGUN(ChatFormatting.GREEN, () -> ModItems.HANDGUN_AMMO.get()),
    RIFLE(ChatFormatting.AQUA, () -> ModItems.RIFLE_AMMO.get()),
    SHOTGUN(ChatFormatting.RED, () -> ModItems.SHOTGUN_AMMO.get()),
    SNIPER(ChatFormatting.GOLD, () -> ModItems.SNIPER_AMMO.get()),
    HEAVY(ChatFormatting.LIGHT_PURPLE, () -> ModItems.HEAVY_AMMO.get());

    public final String translationKey;
    public final String serializationName;
    public final String name;
    public final String displayName;
    public final Supplier<Item> defaultItemSupplier;
    public final ChatFormatting color;
    public DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> dataComponent;

    private Ammo(ChatFormatting color, Supplier<Item> defaultItemSupplier) {
        String name;
        this.color = color;
        this.defaultItemSupplier = defaultItemSupplier;
        this.name = name = this.name().toLowerCase(Locale.ROOT);
        this.translationKey = "item.superbwarfare.ammo." + name;
        StringBuilder builder = new StringBuilder();
        boolean useUpperCase = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                useUpperCase = true;
                continue;
            }
            if (useUpperCase) {
                builder.append(String.valueOf(c).toUpperCase(Locale.ROOT));
                useUpperCase = false;
                continue;
            }
            builder.append(c);
        }
        this.displayName = String.valueOf(builder) + " Ammo";
        this.serializationName = String.valueOf(builder) + "Ammo";
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int count) {
        return new ItemStack((ItemLike)this.defaultItemSupplier.get(), count);
    }

    public static Ammo getType(String name) {
        for (Ammo type : Ammo.values()) {
            if (!type.serializationName.equals(name)) continue;
            return type;
        }
        return null;
    }

    public int get(ItemStack stack) {
        Integer count = (Integer)stack.get(this.dataComponent);
        return count == null ? 0 : count;
    }

    public void set(ItemStack stack, int count) {
        stack.set(this.dataComponent, (Object)count);
    }

    public void add(ItemStack stack, int count) {
        this.set(stack, this.safeAdd(this.get(stack), count));
    }

    public int get(CompoundTag tag) {
        return tag.getInt(this.serializationName);
    }

    public void set(CompoundTag tag, int count) {
        if (count < 0) {
            count = 0;
        }
        tag.putInt(this.serializationName, count);
    }

    public void add(CompoundTag tag, int count) {
        this.set(tag, this.safeAdd(this.get(tag), count));
    }

    public int get(PlayerVariable variable) {
        return variable.ammo.getOrDefault((Object)this, 0);
    }

    public void set(PlayerVariable variable, int count) {
        if (count < 0) {
            count = 0;
        }
        variable.ammo.put(this, count);
    }

    public void add(PlayerVariable variable, int count) {
        this.set(variable, this.safeAdd(this.get(variable), count));
    }

    public int get(Entity entity) {
        return this.get((PlayerVariable)entity.getData(ModAttachments.PLAYER_VARIABLE));
    }

    public void set(Entity entity, int count) {
        if (entity.level().isClientSide) {
            return;
        }
        PlayerVariable cap = ((PlayerVariable)entity.getData(ModAttachments.PLAYER_VARIABLE)).watch();
        this.set(cap, count);
        entity.setData(ModAttachments.PLAYER_VARIABLE, (Object)cap);
        cap.sync(entity);
    }

    public void add(Entity entity, int count) {
        this.set(entity, this.safeAdd(this.get(entity), count));
    }

    private int safeAdd(int a, int b) {
        long newCount = (long)a + (long)b;
        if (newCount > Integer.MAX_VALUE) {
            newCount = Integer.MAX_VALUE;
        } else if (newCount < 0L) {
            newCount = 0L;
        }
        return (int)newCount;
    }

    public String toString() {
        return this.serializationName;
    }
}

