/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.annotation.ServerOnly;
import com.atsuishio.superbwarfare.data.IDBasedData;
import com.atsuishio.superbwarfare.data.ModColor;
import com.atsuishio.superbwarfare.data.ObjectToList;
import com.atsuishio.superbwarfare.data.StringToObject;
import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.DamageReduce;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.FireModeInfo;
import com.atsuishio.superbwarfare.data.gun.GunType;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.data.gun.ReloadType;
import com.atsuishio.superbwarfare.data.gun.SeekType;
import com.atsuishio.superbwarfare.data.gun.SeekWeaponInfo;
import com.atsuishio.superbwarfare.data.gun.ShootPos;
import com.atsuishio.superbwarfare.data.gun.SoundInfo;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class DefaultGunData
implements IDBasedData<DefaultGunData> {
    @SerializedName(value="ID")
    public String id = "";
    public transient boolean isDefaultData = true;
    @SerializedName(value="MaxDurability")
    public int maxDurability = 0;
    @ServerOnly
    @SerializedName(value="DurabilityPerShoot")
    public int durabilityPerShoot = 1;
    @SerializedName(value="MaxEnergy")
    public int maxEnergy = 0;
    @ServerOnly
    @SerializedName(value="MaxReceiveEnergy")
    public int maxReceiveEnergy = -1;
    @ServerOnly
    @SerializedName(value="MaxExtractEnergy")
    public int maxExtractEnergy = -1;
    @SerializedName(value="RecoilX")
    public double recoilX;
    @SerializedName(value="RecoilY")
    public double recoilY;
    @SerializedName(value="Recoil")
    public double recoil;
    @SerializedName(value="RecoilTime")
    public int recoilTime = 0;
    @SerializedName(value="RecoilForce")
    public float recoilForce = 0.0f;
    @ServerOnly
    @SerializedName(value="ShootShake")
    public Vec3 shootShake = null;
    @SerializedName(value="DefaultZoom")
    public double defaultZoom;
    @SerializedName(value="MinZoom")
    public double minZoom = this.defaultZoom = 1.25;
    @SerializedName(value="MaxZoom")
    public double maxZoom = this.defaultZoom;
    @SerializedName(value="Spread")
    public double spread;
    @SerializedName(value="Damage")
    public double damage;
    @SerializedName(value="Headshot")
    public double headshot = 1.5;
    @SerializedName(value="Velocity")
    public double velocity;
    @SerializedName(value="Magazine")
    public int magazine;
    @SerializedName(value="Range")
    public int range = 128;
    @SerializedName(value="MeleeDamage")
    public double meleeDamage;
    @SerializedName(value="MeleeDuration")
    public int meleeDuration = 16;
    @SerializedName(value="MeleeDamageTime")
    public int meleeDamageTime = 6;
    @ServerOnly
    @SerializedName(value="Projectile")
    public StringToObject<ProjectileInfo> projectile = new StringToObject<ProjectileInfo>(new ProjectileInfo());
    @ServerOnly
    @SerializedName(value="ShootPos")
    public ShootPos shootPos = new ShootPos();
    @SerializedName(value="SeekWeaponInfo")
    public SeekWeaponInfo seekWeaponInfo = null;
    @SerializedName(value="AmmoCostPerShoot")
    public int ammoCostPerShoot = 1;
    @SerializedName(value="ProjectileAmount")
    public int projectileAmount = 1;
    @SerializedName(value="Weight")
    public double weight = 1.0;
    @SerializedName(value="DefaultFireMode")
    public String defaultFireMode;
    @SerializedName(value="AvailableFireModes")
    public ObjectToList<StringToObject<FireModeInfo>> availableFireModes;
    @SerializedName(value="ReloadTypes")
    public Set<ReloadType> reloadTypes;
    @SerializedName(value="SeekType")
    public SeekType seekType;
    @SerializedName(value="GunType")
    public GunType gunType;
    @SerializedName(value="AutoReload")
    public boolean autoReload;
    @SerializedName(value="WithdrawAmmoWhenChangeSlot")
    public boolean withdrawAmmoWhenChangeSlot;
    @SerializedName(value="ZoomReload")
    public boolean zoomReload;
    @SerializedName(value="ClearHoldProgressAfterShoot")
    public boolean clearHoldProgressAfterShoot;
    @SerializedName(value="BurstAmount")
    public int burstAmount;
    @SerializedName(value="BypassesArmor")
    public double bypassesArmor;
    @SerializedName(value="AmmoType")
    public ObjectToList<StringToObject<AmmoConsumer>> ammoConsumers;
    private transient List<AmmoConsumer> ammoConsumersCache;
    private transient List<FireModeInfo> fireModesCache;
    @SerializedName(value="NormalReloadTime")
    public int normalReloadTime;
    @SerializedName(value="EmptyReloadTime")
    public int emptyReloadTime;
    @SerializedName(value="BoltActionTime")
    public int boltActionTime;
    @SerializedName(value="PrepareTime")
    public int prepareTime;
    @SerializedName(value="PrepareLoadTime")
    public int prepareLoadTime;
    @SerializedName(value="PrepareAmmoLoadTime")
    public int prepareAmmoLoadTime;
    @SerializedName(value="PrepareEmptyTime")
    public int prepareEmptyTime;
    @SerializedName(value="IterativeTime")
    public int iterativeTime;
    @SerializedName(value="IterativeAmmoLoadTime")
    public int iterativeAmmoLoadTime;
    @SerializedName(value="IterativeLoadAmount")
    public int iterativeLoadAmount;
    @SerializedName(value="FinishTime")
    public int finishTime;
    @SerializedName(value="BurstCooldown")
    public int burstCooldown;
    @ServerOnly
    @SerializedName(value="SoundRadius")
    public double soundRadius;
    @SerializedName(value="RPM")
    public int rpm;
    @SerializedName(value="ExplosionDamage")
    public double explosionDamage;
    @SerializedName(value="ExplosionRadius")
    public double explosionRadius;
    @SerializedName(value="Gravity")
    public double gravity;
    @SerializedName(value="ShootDelay")
    public int shootDelay;
    @ServerOnly
    @SerializedName(value="HeatPerShoot")
    public double heatPerShoot;
    @SerializedName(value="AvailablePerks")
    public ObjectToList<String> availablePerks;
    @ServerOnly
    @SerializedName(value="DamageReduce")
    public DamageReduce damageReduce;
    @ServerOnly
    @SerializedName(value="NaturalCooldown")
    public double naturalCooldown;
    @ServerOnly
    @SerializedName(value="InWaterCooldownRate")
    public double inWaterCooldownRate;
    @ServerOnly
    @SerializedName(value="InSnowCooldownRate")
    public double inSnowCooldownRate;
    @ServerOnly
    @SerializedName(value="InFireCooldownRate")
    public double inFireCooldownRate;
    @ServerOnly
    @SerializedName(value="InLavaCooldownRate")
    public double inLavaCooldownRate;
    @SerializedName(value="ZoomSpreadRate")
    public double zoomSpreadRate;
    @SerializedName(value="SeekTime")
    public int seekTime;
    @SerializedName(value="SeekAngle")
    public double seekAngle;
    @SerializedName(value="SeekRange")
    public double seekRange;
    @SerializedName(value="MinTargetHeight")
    public double minTargetHeight;
    @SerializedName(value="MaxTargetHeight")
    public double maxTargetHeight;
    @SerializedName(value="SoundInfo")
    public SoundInfo soundInfo;
    @ServerOnly
    @SerializedName(value="ShootAnimationTime")
    public int shootAnimationTime;
    @ServerOnly
    @SerializedName(value="IsAntiAirProjectile")
    public boolean isAntiAirProjectile;
    @ServerOnly
    @SerializedName(value="IsClusterMunitionsProjectile")
    public boolean isClusterMunitionsProjectile;
    @ServerOnly
    @SerializedName(value="SparedAmount")
    public int sparedAmount;
    @ServerOnly
    @SerializedName(value="SparedAngle")
    public int sparedAngle;
    @ServerOnly
    @SerializedName(value="IsArmorPiercingProjectile")
    public boolean isArmorPiercingProjectile;
    @ServerOnly
    @SerializedName(value="IsHighExplosiveProjectile")
    public boolean isHighExplosiveProjectile;
    @ServerOnly
    @SerializedName(value="IsGrapeShotProjectile")
    public boolean isGrapeShotProjectile;
    @SerializedName(value="AddShooterDeltaMovement")
    public boolean addShooterDeltaMovement;
    @SerializedName(value="Icon")
    public ResourceLocation icon;
    @SerializedName(value="Crosshair")
    public String crosshair;
    @SerializedName(value="CrosshairZooming")
    public String crosshairZooming;
    @SerializedName(value="CrosshairColor")
    public ModColor crosshairColor;
    @SerializedName(value="Name")
    public String name;

    public DefaultGunData() {
        this.defaultFireMode = FireMode.SEMI.name;
        this.availableFireModes = new ObjectToList<StringToObject>(new StringToObject<FireModeInfo>(new FireModeInfo()));
        this.reloadTypes = Set.of(ReloadType.MAGAZINE);
        this.seekType = SeekType.NONE;
        this.gunType = GunType.SPECIAL;
        this.autoReload = false;
        this.withdrawAmmoWhenChangeSlot = false;
        this.zoomReload = true;
        this.clearHoldProgressAfterShoot = false;
        this.ammoConsumers = new ObjectToList<StringToObject>(new StringToObject[0]);
        this.prepareAmmoLoadTime = 1;
        this.iterativeAmmoLoadTime = 1;
        this.iterativeLoadAmount = 1;
        this.burstCooldown = 30;
        this.rpm = 600;
        this.gravity = 0.05;
        this.shootDelay = 0;
        this.heatPerShoot = 0.0;
        this.availablePerks = new ObjectToList<String>("@Ammo", "superbwarfare:field_doctor", "superbwarfare:powerful_attraction", "superbwarfare:intelligent_chip", "superbwarfare:monster_hunter", "superbwarfare:vorpal_weapon", "!superbwarfare:micro_missile", "!superbwarfare:longer_wire", "!superbwarfare:cupid_arrow");
        this.damageReduce = new DamageReduce();
        this.naturalCooldown = 0.25;
        this.inWaterCooldownRate = 1.1;
        this.inSnowCooldownRate = 1.5;
        this.inFireCooldownRate = 0.6;
        this.inLavaCooldownRate = 0.2;
        this.zoomSpreadRate = 0.1;
        this.seekTime = 20;
        this.seekAngle = 10.0;
        this.seekRange = 384.0;
        this.minTargetHeight = 0.0;
        this.maxTargetHeight = 114514.0;
        this.soundInfo = new SoundInfo();
        this.shootAnimationTime = 0;
        this.isAntiAirProjectile = false;
        this.isClusterMunitionsProjectile = false;
        this.sparedAmount = 10;
        this.sparedAngle = 15;
        this.isArmorPiercingProjectile = false;
        this.isHighExplosiveProjectile = false;
        this.isGrapeShotProjectile = false;
        this.addShooterDeltaMovement = false;
        this.icon = Mod.loc("textures/gun_icon/default_icon.png");
        this.crosshair = "@GunDefault";
        this.crosshairZooming = "@Empty";
        this.crosshairColor = new ModColor();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ProjectileInfo projectile() {
        return (ProjectileInfo)this.projectile.value;
    }

    public List<FireModeInfo> availableFireModes() {
        return this.availableFireModes.list.stream().map(m -> (FireModeInfo)m.value).toList();
    }

    public List<AmmoConsumer> getAmmoConsumers() {
        if (this.ammoConsumersCache == null) {
            this.ammoConsumersCache = this.ammoConsumers.list.stream().map(c -> {
                if (!((AmmoConsumer)c.value).initialized()) {
                    ((AmmoConsumer)c.value).init();
                }
                return (AmmoConsumer)c.value;
            }).filter(c -> {
                if (c.type == AmmoConsumer.AmmoConsumeType.INVALID) {
                    Mod.LOGGER.warn("invalid ammo string {} for {}", (Object)c.ammo, (Object)this.id);
                    return false;
                }
                return true;
            }).toList();
        }
        return this.ammoConsumersCache;
    }

    public List<FireModeInfo> getFireModes() {
        if (this.fireModesCache == null) {
            this.fireModesCache = this.availableFireModes.list.stream().map(c -> {
                ((FireModeInfo)c.value).init();
                return (FireModeInfo)c.value;
            }).toList();
        }
        return this.fireModesCache;
    }

    public List<String> availablePerks() {
        return this.availablePerks.list;
    }

    @Override
    public void limit() {
        this.maxDurability = Math.max(0, this.maxDurability);
        this.durabilityPerShoot = Math.max(0, this.durabilityPerShoot);
        this.maxEnergy = Math.max(0, this.maxEnergy);
        int temp = Mth.clamp((int)this.maxReceiveEnergy, (int)-1, (int)this.maxEnergy);
        this.maxReceiveEnergy = temp < 0 ? this.maxEnergy : temp;
        temp = Mth.clamp((int)this.maxExtractEnergy, (int)-1, (int)this.maxEnergy);
        this.maxExtractEnergy = temp < 0 ? this.maxEnergy : temp;
        this.meleeDuration = Math.max(1, this.meleeDuration);
        this.zoomSpreadRate = Mth.clamp((double)this.zoomSpreadRate, (double)0.0, (double)1.0);
        this.range = Math.max(1, this.range);
        this.meleeDamageTime = Math.min(this.meleeDuration - 1, this.meleeDamageTime);
        this.ammoCostPerShoot = Math.max(0, this.ammoCostPerShoot);
        this.projectileAmount = Math.max(0, this.projectileAmount);
        this.weight = Math.max(1.0, this.weight);
        this.magazine = this.projectileAmount == 0 && this.meleeDamage > 0.0 ? 0 : Math.max(0, this.magazine);
        if (this.reloadTypes == null) {
            this.reloadTypes = Set.of();
        }
        if (this.seekType == null) {
            this.seekType = SeekType.NONE;
        }
        this.burstAmount = Math.max(0, this.burstAmount);
        this.rpm = Mth.clamp((int)this.rpm, (int)1, (int)114514);
    }
}

