/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun.subdata;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public final class AmmoSlot {
    public static final String AMMO_SLOT = "AmmoSlot";
    private final CompoundTag tag;

    public AmmoSlot(CompoundTag data) {
        this.tag = data;
    }

    private CompoundTag getSlot() {
        return this.tag.getCompound(AMMO_SLOT);
    }

    private CompoundTag getOrCreateSlot() {
        if (!this.tag.contains(AMMO_SLOT)) {
            this.tag.put(AMMO_SLOT, (Tag)new CompoundTag());
        }
        return this.getSlot();
    }

    public int getAmmo(String slot) {
        int[] arr = this.getSlot().getIntArray(slot);
        return arr.length > 0 ? arr[0] : 0;
    }

    public int getVirtualAmmo(String slot) {
        int[] arr = this.getSlot().getIntArray(slot);
        return arr.length > 1 ? arr[1] : 0;
    }

    public void set(String slot, int ammo, int virtualAmmo) {
        if (ammo <= 0 && virtualAmmo <= 0) {
            this.reset(slot);
        } else {
            int[] arr = new int[]{ammo, virtualAmmo};
            this.getOrCreateSlot().putIntArray(slot, arr);
        }
    }

    public void reset(String slot) {
        CompoundTag slotTag = this.getSlot();
        slotTag.remove(slot);
        if (slotTag.isEmpty()) {
            this.tag.remove(AMMO_SLOT);
        }
    }

    public void reset() {
        this.tag.remove(AMMO_SLOT);
    }
}

