/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun.value;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStackValue {
    private final CompoundTag tag;
    private final String name;
    private final ItemStack defaultValue;
    private ItemStack cache;

    public ItemStackValue(CompoundTag tag, String name, ItemStack defaultValue) {
        this.tag = tag;
        this.name = name;
        this.defaultValue = defaultValue.copy();
        this.cache = defaultValue.copy();
    }

    public ItemStackValue(CompoundTag tag, String name) {
        this(tag, name, ItemStack.EMPTY);
    }

    public ItemStack get() {
        if (!this.cache.isEmpty()) {
            return this.cache;
        }
        if (this.tag.contains(this.name)) {
            return ItemStack.parseOptional((HolderLookup.Provider)RegistryAccess.EMPTY, (CompoundTag)this.tag.getCompound(this.name));
        }
        return this.defaultValue;
    }

    public void set(@NotNull ItemStack value) {
        if (ItemStack.isSameItemSameComponents((ItemStack)value, (ItemStack)this.defaultValue)) {
            this.tag.remove(this.name);
        } else {
            this.tag.put(this.name, value.save((HolderLookup.Provider)RegistryAccess.EMPTY));
        }
        this.cache = value.copy();
    }

    public void reset() {
        this.set(this.defaultValue);
    }
}

