/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.world.TDMSavedData;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ClaymoreEntity
extends Entity
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(ClaymoreEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.defineId(ClaymoreEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(ClaymoreEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier().multiply(0.2f, ModDamageTypes.CUSTOM_EXPLOSION).multiply(0.2f, ModDamageTypes.MINE).multiply(0.2f, ModDamageTypes.PROJECTILE_EXPLOSION);

    public ClaymoreEntity(EntityType<ClaymoreEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    public ClaymoreEntity(LivingEntity owner, Level level) {
        this((EntityType<ClaymoreEntity>)((EntityType)ModEntities.CLAYMORE.get()), level);
        if (owner != null) {
            this.setOwnerUUID(owner.getUUID());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty()).define(LAST_ATTACKER_UUID, (Object)"undefined").define(HEALTH, (Object)Float.valueOf(10.0f));
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Level level;
        amount = DAMAGE_MODIFIER.compute(source, amount);
        if (source.getEntity() != null) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)source.getEntity().getStringUUID());
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), this.getX(), this.getY() + 0.2, this.getZ(), 2, 0.02, 0.02, 0.02, 0.1, false);
        }
        this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        this.entityData.set(HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(HEALTH)).floatValue() - amount));
        return super.hurt(source, amount);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.getOwner();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
        compound.putString("LastAttacker", (String)this.entityData.get(LAST_ATTACKER_UUID));
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        if (compound.contains("Health")) {
            this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        }
        if (compound.contains("LastAttacker")) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)compound.getString("LastAttacker"));
        }
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            try {
                uuid = this.getServer() == null ? UUID.fromString(s) : OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.isOwnedBy((LivingEntity)player) && player.isShiftKeyDown()) {
            if (!this.level().isClientSide()) {
                this.discard();
            }
            if (!player.getAbilities().instabuild) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.CLAYMORE_MINE.get()));
            }
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        if (this.tickCount >= 12000 && !this.level().isClientSide()) {
            this.discard();
        }
        if (this.tickCount >= 40) {
            Vec3 center = new Vec3(x + 1.5 * this.getLookAngle().x, y + 1.5 * this.getLookAngle().y, z + 1.5 * this.getLookAngle().z);
            for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(1.25), e -> true)) {
                Player player;
                boolean condition;
                boolean bl = condition = this.getOwner() != target && (target instanceof LivingEntity || target instanceof VehicleEntity) && !(target instanceof TargetEntity) && (!(target instanceof Player) || !(player = (Player)target).isCreative() && !player.isSpectator()) && (this.getOwner() != null && !this.getOwner().isAlliedTo(target) || target.getTeam() == null || TDMSavedData.enabledTDM(target)) && !target.isShiftKeyDown();
                if (!condition) continue;
                ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
                this.discard();
                Mod.queueServerWork(1, () -> {
                    if (!level.isClientSide()) {
                        this.triggerExplode();
                    }
                });
                break;
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        if (((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f) {
            this.destroy();
        }
        this.refreshDimensions();
    }

    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            Entity attacker = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_ATTACKER_UUID));
            new CustomExplosion.Builder(attacker == null ? this : attacker).damage(((Integer)ExplosionConfig.CLAYMORE_EXPLOSION_DAMAGE.get()).floatValue() / 5.0f).radius(((Integer)ExplosionConfig.CLAYMORE_EXPLOSION_RADIUS.get()).intValue()).position(this.position()).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
            this.discard();
        }
    }

    private void triggerExplode() {
        new CustomExplosion.Builder(this).attacker((Entity)this.getOwner()).damage(((Integer)ExplosionConfig.CLAYMORE_EXPLOSION_DAMAGE.get()).intValue()).radius(((Integer)ExplosionConfig.CLAYMORE_EXPLOSION_RADIUS.get()).intValue()).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose p_33597_) {
        return super.getDimensions(p_33597_).scale(0.5f);
    }

    public boolean isPushable() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

