/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.capability.energy.SyncedEntityEnergyStorage;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@EventBusSubscriber(modid="superbwarfare")
public class DPSGeneratorEntity
extends LivingEntity
implements GeoEntity {
    public static final EntityDataAccessor<Integer> DOWN_TIME = SynchedEntityData.defineId(DPSGeneratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.defineId(DPSGeneratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.defineId(DPSGeneratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float damageDealt = 0.0f;
    protected final SyncedEntityEnergyStorage energyStorage = new SyncedEntityEnergyStorage(5120, 0, 2560, this.entityData, ENERGY);

    public DPSGeneratorEntity(EntityType<DPSGeneratorEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DOWN_TIME, (Object)0).define(ENERGY, (Object)0).define(LEVEL, (Object)0);
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        return NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    }

    @NotNull
    public ItemStack getItemBySlot(@NotNull EquipmentSlot pSlot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(@NotNull EquipmentSlot pSlot, @NotNull ItemStack pStack) {
    }

    public boolean causeFallDamage(float l, float d, @NotNull DamageSource source) {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Level", ((Integer)this.entityData.get(LEVEL)).intValue());
        IEnergyStorage entityCap = (IEnergyStorage)this.getCapability(Capabilities.EnergyStorage.ENTITY, null);
        if (entityCap == null) {
            return;
        }
        compound.putInt("Energy", entityCap.getEnergyStored());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(LEVEL, (Object)compound.getInt("Level"));
        IEnergyStorage entityCap = (IEnergyStorage)this.getCapability(Capabilities.EnergyStorage.ENTITY, null);
        if (entityCap == null) {
            return;
        }
        ((SyncedEntityEnergyStorage)entityCap).setEnergy(compound.getInt("Energy"));
        ((SyncedEntityEnergyStorage)entityCap).setCapacity(this.getMaxEnergy());
        ((SyncedEntityEnergyStorage)entityCap).setMaxExtract(this.getMaxTransfer());
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (source.is(DamageTypes.GENERIC_KILL)) {
            this.remove(Entity.RemovalReason.KILLED);
            return super.hurt(source, amount);
        }
        this.damageDealt += amount;
        if ((double)this.getHealth() < 0.01) {
            amount = 0.0f;
        }
        if (!this.level().isClientSide()) {
            this.level().playSound(null, BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()), (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        return super.hurt(source, (float)((double)amount / Math.pow(2.0, this.getGeneratorLevel())));
    }

    @SubscribeEvent
    public static void onTargetDown(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.getSource().is(DamageTypes.GENERIC_KILL)) {
            return;
        }
        Entity sourceEntity = event.getSource().getEntity();
        if (entity instanceof DPSGeneratorEntity) {
            DPSGeneratorEntity generatorEntity = (DPSGeneratorEntity)entity;
            event.setCanceled(true);
            generatorEntity.setHealth(1.0E-5f);
            if (sourceEntity instanceof Player) {
                Player player = (Player)sourceEntity;
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.TARGET_DOWN.get(), 1.0f, 1.0f);
                generatorEntity.entityData.set(DOWN_TIME, (Object)40);
            }
        }
    }

    public boolean isPickable() {
        return (Integer)this.entityData.get(DOWN_TIME) == 0;
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!player.getMainHandItem().isEmpty() && !player.getMainHandItem().is(ModTags.Items.TOOLS_CROWBAR)) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            if (!this.level().isClientSide()) {
                this.discard();
            }
            if (!player.getAbilities().instabuild) {
                player.addItem(new ItemStack((ItemLike)ModItems.DPS_GENERATOR_DEPLOYER.get()));
            }
        } else {
            this.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(player.getX(), this.getY(), player.getZ()));
            this.setXRot(0.0f);
            this.xRotO = this.getXRot();
            this.entityData.set(DOWN_TIME, (Object)0);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public void tick() {
        super.tick();
        if ((Integer)this.entityData.get(DOWN_TIME) > 0) {
            this.entityData.set(DOWN_TIME, (Object)((Integer)this.entityData.get(DOWN_TIME) - 1));
        }
        if (this.tickCount % 20 == 0) {
            float damage = this.getMaxHealth() - this.getHealth();
            IEnergyStorage entityCap = (IEnergyStorage)this.getCapability(Capabilities.EnergyStorage.ENTITY, null);
            if (entityCap != null) {
                if (damage > 0.0f) {
                    Entity attacker;
                    if (this.getLastDamageSource() != null && (attacker = this.getLastDamageSource().getEntity()) instanceof Player) {
                        Player player = (Player)attacker;
                        if (!this.level().isClientSide) {
                            float displayDamage = this.getLastDamageSource().is(ModDamageTypes.BEAST) ? Float.POSITIVE_INFINITY : this.damageDealt;
                            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.dps_generator.dps", (Object[])new Object[]{FormatTool.format1DZ(displayDamage)}), true);
                        }
                    }
                    ((SyncedEntityEnergyStorage)entityCap).setMaxReceive(entityCap.getMaxEnergyStored());
                    entityCap.receiveEnergy((int)Math.round(128.0 * (double)Math.max(this.getGeneratorLevel(), 1) * Math.pow(2.0, this.getGeneratorLevel()) * (double)damage), false);
                    ((SyncedEntityEnergyStorage)entityCap).setMaxReceive(0);
                }
                this.chargeBlockBelow();
                if ((double)this.getHealth() < 0.01) {
                    this.entityData.set(LEVEL, (Object)Math.min((Integer)this.entityData.get(LEVEL) + 1, 7));
                    ((SyncedEntityEnergyStorage)entityCap).setCapacity(this.getMaxEnergy());
                    ((SyncedEntityEnergyStorage)entityCap).setMaxExtract(this.getMaxTransfer());
                    if (!this.level().isClientSide()) {
                        this.level().playSound(null, BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()), (SoundEvent)ModSounds.DPS_GENERATOR_EVOLVE.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                    } else {
                        this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.DPS_GENERATOR_EVOLVE.get(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
                    }
                }
                this.setHealth(this.getMaxHealth());
                this.damageDealt = 0.0f;
            }
        }
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean isPushable() {
        return false;
    }

    @NotNull
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    protected void doPush(@NotNull Entity entityIn) {
    }

    protected void pushEntities() {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
        this.setNoGravity(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 10.0).add(Attributes.FLYING_SPEED, 0.0);
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 100) {
            this.spawnAtLocation(new ItemStack((ItemLike)ModItems.DPS_GENERATOR_DEPLOYER.get()));
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    private PlayState movementPredicate(AnimationState<DPSGeneratorEntity> event) {
        if ((Integer)this.entityData.get(DOWN_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.target.down"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.target.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    protected void chargeBlockBelow() {
        IEnergyStorage entityCap = (IEnergyStorage)this.getCapability(Capabilities.EnergyStorage.ENTITY, null);
        if (entityCap == null) {
            return;
        }
        if (!entityCap.canExtract() || entityCap.getEnergyStored() <= 0) {
            return;
        }
        BlockPos blockPos = this.blockPosition().below();
        IEnergyStorage cap = (IEnergyStorage)this.level().getCapability(Capabilities.EnergyStorage.BLOCK, blockPos, (Object)Direction.UP);
        if (cap == null || !cap.canReceive()) {
            return;
        }
        int extract = entityCap.extractEnergy(entityCap.getEnergyStored(), true);
        int extracted = cap.receiveEnergy(extract, false);
        if (extracted <= 0) {
            return;
        }
        this.level().blockEntityChanged(blockPos);
        entityCap.extractEnergy(extracted, false);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getGeneratorLevel() {
        return (Integer)this.entityData.get(LEVEL);
    }

    public int getMaxEnergy() {
        return switch (this.getGeneratorLevel()) {
            case 1 -> 25600;
            case 2 -> 102400;
            case 3 -> 409600;
            case 4 -> 0x190000;
            case 5 -> 0x640000;
            case 6 -> 0x1900000;
            case 7 -> 0x6400000;
            default -> 5120;
        };
    }

    public int getMaxTransfer() {
        return this.getMaxEnergy() / 2;
    }

    public void beastCharge() {
        if ((Integer)this.entityData.get(LEVEL) < 7) {
            this.entityData.set(LEVEL, (Object)7);
            Object object = this.getCapability(Capabilities.EnergyStorage.ENTITY, null);
            if (object instanceof SyncedEntityEnergyStorage) {
                SyncedEntityEnergyStorage storage = (SyncedEntityEnergyStorage)((Object)object);
                storage.setCapacity(this.getMaxEnergy());
                storage.setMaxExtract(this.getMaxTransfer());
                storage.setEnergy(this.getMaxEnergy());
            }
        }
    }

    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ModItems.DPS_GENERATOR_DEPLOYER.get());
    }
}

